# update_thread.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

sub update_thread {

   my ($r_in,$r_setup) = @_; 
   my (@newrow, $level);
   my $r_rowdata = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");
   my $lock, $user_rating, $num_read;

   # DCF 2000 MOD---DEC 6 99
   # Add user rating and mesg view to the thread -- needed for 
   # recontruction of the database.txt
   my $first_line = shift @{$r_rowdata};
   chomp($first_line);
   unless ($first_line =~ /\|/) {
      $r_in->{'next_file_num'} = $first_line;
      $user_rating = '';
      $lock = '';
      $num_read = 0;
   }
   else {
      ($r_in->{'next_file_num'},$lock,$user_rating,$num_read) = split( /$split_delim/,$first_line);
   }

   $r_in->{'next_file_num'}++;
   $first_line = join("$join_delim",$r_in->{'next_file_num'},$lock,$user_rating,$num_read);
   push(@newrow,"$first_line\n");

   $r_in->{'omm'} = 0 unless($r_in->{'omm'});

   # Now, if reverse_thread is on, then find where we'll
   # thread the message
   if ($r_setup->{'reverse_thread'} eq "on") {

      my $r_message = {};
      my $count = 0;
      my @sublevel;
      my $templevel = 0;

      # Pull off sublevels
      foreach (@{$r_rowdata}) {
         chomp;
         my @temp = split /$split_delim/;
         $r_message->{$count} = \@temp;
         $count++;
      } #End of foreach  

      foreach ( sort { $a <=> $b } keys %{$r_message} ) {
         if ($r_message->{$_}->[0] == $r_in->{'omm'}) {
            $level = 1 + $r_message->{$_}->[1];
            $templevel = $level;
            push(@sublevel,$_);
         }
         elsif ($templevel) {
            if ($r_message->{$_}->[1] <= $templevel - 1) {
               $templevel = "";
            }
            else {
               push(@sublevel,$_);
            }
         }
      } #End of foreach

      $temp = pop(@sublevel);
      $r_in->{'omm'} = $r_message->{$temp}->[0];

   }

   # At this point, $$r_in->{'omm'} is the message
   # Right before current thread
   # Now, just go thru the data again and thread it correctly
   foreach (@{$r_rowdata}) {
      chomp;
      push(@newrow,"$_\n");
      my @temp = split /$split_delim/;
      if ($r_in->{'omm'} eq $temp[0]) {
         my $temp;
         $level = $temp[1] + 1 unless ($r_setup->{'reverse_thread'} eq "on");
         $temp = join("$join_delim",
            $r_in->{'next_file_num'},
            $level,
            $r_in->{'subject'},
            $r_in->{'name'},
            $r_in->{'email'},
            $r_in->{'localtime'},
            $r_in->{'date'},
            $r_in->{'body'} );
         push(@newrow,$temp,"\n");
      }
   }

   # Write to output file
   writedata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext",\@newrow);

}

1;