# update_database.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
#
#======================================================================#
# function update_database                                             #
# takes input message from post form and adds to the database          #
#======================================================================#

sub update_database {

   my ($datafile,$r_in) = @_;

   my $temp_time = substr($r_in->{'localtime'},0,5);
   my $last_date = "$temp_time $r_in->{'date'}";

   my $r_rowdata = readdata($datafile);

   foreach ($j = 0;$j < @$r_rowdata;$j++) {
      if ($r_rowdata->[$j] =~ /^$r_in->{'om'}$split_delim/) {
         my ($num,$origdate,$origtime,
            $origname,$origsubject,$origcaption,$lock,$read,
            $user_rating,$replies) = split(/$split_delim/, $r_rowdata->[$j]);
         $replies ++;
         $new_data =
            join("$join_delim",$num,$r_in->{'date'},$r_in->{'localtime'},
              $origname,$origsubject,$origcaption,$lock,$read,$user_rating,$replies);
         splice(@$r_rowdata, $j, 1);
         $j --;
         last;
      }
   }

   unshift(@$r_rowdata, "$new_data\n");
   writedata($datafile,$r_rowdata);

   # Update total number of messages
   $r_setup->{'forum_posts'}->{$forum}++;
   
   # Update last modifed date in the forum file
   $r_setup->{'forum_last'}->{$forum} = $last_date;

   save_forum_info("$password_file_dir/$forum_file",$r_setup);

}

1;