# site_map.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# site_map
# utility for displaying the site map
#===================================================================

sub site_map {

   my ($r_in,$r_setup) = @_;

   my $r_conf_forums;
   my $r_conf_count;
   my $r_user_mark = get_user_mark($r_in,$r_setup);
   my $current_time = time_format($r_in->{'localtime'});
   my $current_date = date_format($r_in->{'date'});

   my $menu_button = create_button('lobby',$r_in,$r_setup);
   my $heading = $forum_title;

   print_header();
   print_header_end();
   
   my $html_output .= qq~
      <TABLE BORDER="0" WIDTH="$table_width" CELLPADDING="3" CELLSPACING="1">
      <TR><TD ALIGN="RIGHT"><font face="$font_face_3" color="$font_color_3" size="1">
      $current_date $current_time $time_zone<br></TD></TR>
      <TR><TD ALIGN="LEFT" VALIGN="BOTTOM" bgcolor="$bg_color_0"><font 
      face="$font_face_0" color="$font_color_0" size="$font_size_0">
      Conference Site Map
      </TD></TR>
      <TR><TD ALIGN="LEFT" VALIGN="BOTTOM"><font 
      face="$font_face_3" color="$font_color_3" size="$font_size_3">
      ~;

   foreach (@{$r_setup->{'forums'}}) {
      if ($r_setup->{'forum_status'}->{$_} eq "on" && 
         check_forum_access($r_in,$r_setup,$_) ) {

         if ($r_in->{'conf'}) {
            if ($r_in->{'conf'} eq $r_setup->{'forum_conf'}->{$_}) {
               push( @{ $r_conf_forums->{$r_setup->{'forum_conf'}->{$_}} } , $_);
               $r_conf_count->{$r_setup->{'forum_conf'}->{$_}}++;
            }
         }

         else {
            push( @{ $r_conf_forums->{$r_setup->{'forum_conf'}->{$_}} } , $_);
            $r_conf_count->{$r_setup->{'forum_conf'}->{$_}}++;
         }

      }

   }

   foreach (@{$r_setup->{'conf'}}) {
   
      if ($r_conf_count->{$_}) {

         $html_output .= qq~
            <font size="3" face="$font_face_0" color="$font_color_0">
            <a href="$boardurl?conf=$_"><b>$r_setup->{'conf_name'}->{$_}</b></a></font>
            <font size="2" face="$font_face_0" color="$font_color_0">
            <ul>
         ~;
   
         foreach (@{ $r_conf_forums->{$_} }) {
   
            if ($r_setup->{'forum_status'}->{$_} eq "on" && 
                  check_forum_access($r_in,$r_setup,$_) ) {
   
               $html_output .= qq~
               <li>
               <a href="$boardurl?az=list&forum=$_" target="_blank"><b>$r_setup->{'forum_name'}->{$_}</b></a>~;
      
            }
         } #End of foraech

         $html_output .= "</ul></font>\n";
      }

   }# End of foreach

   $html_output .= "</td></tr></table>";

   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;