# show_thread.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# show_thread
# script for dynamically displaying a thread
#======================================================================#

sub show_thread {

   my ($r_in,$r_setup) = @_;
   my $html_main_body;
   my $html_orig_body;
   my $r_user_mark = get_user_mark($r_in,$r_setup);

   require "$cgilib/dcforumlib2.pl";

   $| = 1;

   print_header();
   print_header_end();

   # Create menu buttons
   my $heading = $forum_title;
   my $sub_heading;
   my $html_orig;
   my $orig_link;
   my $next_flag;
   
   # Colspan needed for calling navigation menu
   $r_in->{'colspan'} = 2;

#   my $menu_button = create_button('message',$r_in,$r_setup);
   
   # Oppps, no access allowed
   if ($r_setup->{'forum_status'}->{ $forum } ne "on") {
      ($heading,$sub_heading,$html_output) = 
         access_error('forum off',$r_in,$r_setup);
      return ($heading,$sub_heading,$html_output);
   }
   elsif (!check_forum_access($r_in,$r_setup,$forum)) {
      ($heading,$sub_heading,$html_output) = 
         access_error('forum private',$r_in,$r_setup);
      return ($heading,$sub_heading,$html_output);
   }

   # $next flag displays prev and next thread as
   # threaded discussion
   if ($r_setup->{'threaded_main_listing'} eq 'on') {
      $next_flag = 0;
   }
   
   # If $omm in not specified, then read in the html file
   # and just print it
   if ($r_in->{'omm'} eq '') {
      my $r_thread  = readdata("$maindir/$forum/$r_in->{'om'}.$ext");
      print "@{$r_thread}\n";
      exit;
   }

   # Read in thread data
   my $r_thread = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");

   # Shift out the first record
   shift(@$r_thread);

   # initialize the first step
   my $prev_level = 0;
   
   # For each message
   foreach (@$r_thread) {

      my $marker;
      chomp;
      my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = split /$split_delim/;
      $subject = dc_decode($subject);
      # Chop subject    
      $subject = trim_text($subject,$subject_length_max);

      # create link to the original message
      if ($omm == 0) {
         my $ltime = time_format($ltime);
         my $date = date_format($date);
         $r_in->{'subject'} = $subject;
         $html_orig = navigation_menu($r_in,$r_setup);
         if ($r_in->{'omm'} == 0) {
            $orig_link = qq~
            <font color="$font_color_special">$subject</font>, 
            <b>$name</b>, <font size="1">$date, $ltime</font>
            ~;             
         }
         else {
            $orig_link = qq~
            <a href="$boardurl?az=show_thread&omm=$omm&om=$r_in->{'om'}&forum=$forum">$subject</a>, 
               <b>$name</b>, <font size="1">$date, $ltime</font>
            ~;
         }

         $sub_heading = "\"$subject\"";

      } #End of if $omm

      if ($omm == $r_in->{'omm'}) {
         $r_in->{'subject'} = $subject;
         $r_in->{'name'} = $name;
         $r_in->{'email'} = $email;
         $r_in->{'ltime'} = $ltime;
         $r_in->{'date'} = $date;
         # backward compatibility code
         # Need to get rid of all the HTML codes
         $body = dcf99_dcf00($body);
         $r_in->{'body'} = text_to_html($body);
         $html_main_body = html_main_body($r_in,$r_setup);
      }

      # Check to see if the user is a team member
      $name = check_team($name,$team);
      $level = $r_setup->{'level_max'} if 
         ($level > $r_setup->{'level_max'});
      my $icon = "reply_message.gif";
      my $space = ($level-2)*$level_spacing + 1;

      if ($r_user_mark->{$forum} ne "") {
         if (check_new($ltime,$date,$r_user_mark->{$forum})) {
            $marker = " <img src=\"$imgurl/newmark.gif\"> ";
         }
      }

      $ltime = time_format($ltime);
      $date = date_format($date);

      $icon = 'message.gif' if ($level == 1);
      $space = 1 if ($level == 1);

      unless ($omm == $r_in->{'omm'}) {

         if ($r_setup->{'use_icons_toc'} eq 'on') {
            $toc .= qq~
            <img src=\"$imgurl/blank.gif\" width=\"$space\" height=\"14\"><img 
            src=\"$imgurl/$icon\"> <a 
            href="$boardurl?az=show_thread&omm=$omm&om=$r_in->{'om'}&forum=$forum">$subject</a>
            , $marker <b>$name</b>, <font size="1">$date, ($omm)</font><br>~;
         }
         else {
            if ($level > $prev_level) {
               for ($j=0;$j<$level-$prev_level;$j++) {
                  $toc .= "<ul>\n";
                  $ul_count++;
               }
            }
            elsif ($level < $prev_level) {
               for ($j=0;$j<$prev_level-$level;$j++) {
                  $toc .= "</ul>\n";
                  $ul_count--;
               }
            }

            $prev_level = $level;
               $toc .= qq~
                   <li><a href="$boardurl?az=show_thread&omm=$omm&om=$r_in->{'om'}&forum=$forum">$subject</a>, $marker
                   <b>$name</b>, <font size="1">$date, $ltime ($omm)</font>
                   ~;
         }
      }
      else {

         if ($r_setup->{'use_icons_toc'} eq 'on') {
            $toc .= qq~
            <img src=\"$imgurl/blank.gif\" width=\"$space\" height=\"14\"><img 
            src=\"$imgurl/$icon\"> <font color="$font_color_special">$subject</font>, $marker
            <b>$name</b>, <font size="1">$date, ($omm)</font><br>~;
         }
         else {

            if ($level > $prev_level) {
               for ($j=0;$j<$level-$prev_level;$j++) {
                  $toc .= "<ul>\n";
                  $ul_count++;
               }
            }
            elsif ($level < $prev_level) {
               for ($j=0;$j<$prev_level-$level;$j++) {
                  $toc .= "</ul>\n";
                  $ul_count--;
               }
            }
   
            $prev_level = $level;
                  $toc .= qq~
                   <li><font color="$font_color_special">$subject</font>
                   , <b>$name</b>, <font size="1">$date, $ltime</font>
                   ~;
         }

      }# End of unless

      $toc = '' if ($omm == 0);

   }

   # Complete ul tags
   for ($j=0;$j<$ul_count;$j++) {
      $toc .= "</ul>\n";
   }

   toggle_color();
   
   # Create main-lobby icons
     # they will be placed at the botton of table of contents
   
     $main_lobby .= qq~<font size="$font_size_4" color="$font_color_4" face="$font_face_4">
   <a href="$boardurl"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Lobby</font></a> |
   <a href="$boardurl?az=list&forum=$forum"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Topics</font></a> |
      <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=previous_topic&archive=$r_in->{'archive'}&omm=$next_flag"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Previous Topic</font></a> |
   <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=next_topic&archive=$r_in->{'archive'}&omm=$next_flag"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Next Topic</font></a></font>~;
     my $prev_next = qq~<font size="$font_size_4" color="$font_color_4" face="$font_face_4">
      <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=previous_topic&archive=$r_in->{'archive'}&omm=$next_flag"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Previous Topic</font></a> |
   <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=next_topic&archive=$r_in->{'archive'}&omm=$next_flag"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Next Topic</font></a></font>~;

   $html_output .=qq~
   <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="3">
   <TR><TD ALIGN="LEFT" VALIGN="BOTTOM" bgcolor="$bg_color_4">
   <a href="$boardurl?az=email_to_friend&om=$r_in->{'om'}&forum=$forum"><img
   src="$imgurl/email_to_friend.gif" align="bottom" border="0"><font 
   SIZE="1" FACE="$font_face_4" color="$font_color_4">Email this topic to a friend</font></a><br>
   <a href="$boardurl?az=printer_format&om=$r_in->{'om'}&forum=$forum"><img
   src="$imgurl/printer_friendly.gif" align="bottom" border="0"><font 
   SIZE="1" FACE="$font_face_4" 
   color="$font_color_4">Printer-friendly version of this topic</font></a></TD>
   <TD ALIGN="RIGHT" VALIGN="BOTTOM" >
   <font SIZE="$font_size_4" FACE="$font_face_4" color="$font_color_4">
   $prev_next</font></TD>
   </TR>
   $html_orig
   </TABLE>
   
   <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="3">
   <TR BGCOLOR="$bg_color_0">
   <TD ALIGN="LEFT">
   <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
   Current Message
   </font></TD>
   </TR></TABLE>
   <br>
   $html_main_body
   <br>
   <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="3">
   <TR BGCOLOR="$bg_color_0">
   <TD ALIGN="LEFT">
   <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
   Table of Contents
   </font></TD>
   </TR></TABLE>
   <TABLE BORDER="0" WIDTH="$table_width" cellspacing="1" cellpadding="3">
   <TR BGCOLOR="$bgcolor"><TD ALIGN="LEFT" VALIGN="TOP">
   <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
   <img src="$imgurl/file.gif"> $orig_link
   </FONT></TD></TR>
   <TR BGCOLOR="$bgcolor"><TD ALIGN="LEFT" VALIGN="TOP">
   <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
   $toc
   </FONT>
          </TD>
    </TR><TR BGCOLOR="$bgcolor"><TD ALIGN="Right" VALIGN="TOP">
   <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
   $main_lobby
   </FONT>
          </TD>
    </TR>~;
    
   # Ok, if user_rating is ON then put rating feedback   
   if ($r_setup->{'user_rating'} eq 'on') {
      $html_output .= qq~
   <TR BGCOLOR="$bg_color_4"><TD ALIGN="RIGHT" COLSPAN="2">
      <font SIZE="$font_size_4" FACE="$font_face_4" 
         color="$font_color_special">Rate this topic (1=skip it, 10=must read)?
         [ ~;

      for ($j=1;$j<11;$j++) {
         $html_output .= qq~
         <a href="$boardurl?az=user_rating&om=$r_in->{'om'}&forum=$forum&rating=$j&archive=$r_in->{'archive'}">
         <font SIZE="$font_size_4" FACE="$font_face_4" 
            color="$font_color_special">$j</font></a> |~;
      }

      chop($html_output);
      $html_output .= qq~        
            ] </font>               
            </TD></TR>~;
   }

    
   
   $html_output .= qq~
   </table>
    ~;

   
   return ($heading, $sub_heading, $html_output,$menu_button);
   
}

1;