# search_form.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function search_form                                                 #
# displays the search form                                             #
#======================================================================#

sub search_form {

   my ($r_in,$r_setup) = @_;
   my $heading = $forum_title;
   my $sub_heading = "Use the form below to search the forum";
   my $menu_button = create_button("search",$r_in,$r_setup);

   my @search_day = qw(1 2 3 4 7 14 30 90 365);
   my %search_days = (
      1=>"Last 1 day",
      2=>"Last 2 days",
      3=>"Last 3 days",
      4=>"Last 4 days",
      7=>"Last 1 week",
      14=>"Last 2 week",
      30=>"Last 1 month",
      90=>"Last 3 month",
      365=>"Last 1 year"
   );

   my @search_fields = qw(
      All
      Author
      Subject
      Message
   );

   print_header();
   print_header_end();

   my $html_output .=qq~
      <center>
      <table border="0" cellpadding="2" WIDTH="$table_width">
      <tr><th align="right" bgcolor="$bg_color_3"><FONT SIZE="$font_size_3" 
      FACE="$font_face_3" color="$font_color_3"><FORM ACTION="$boardurl" METHOD="POST">
      <INPUT TYPE="HIDDEN" NAME="az" VALUE="search">
      Keyword(s):</th><td bgcolor="$bg_color_3">
      <INPUT TYPE="TEXT" SIZE="30" NAME="keywords" value="$r_in->{'keywords'}">
      </td></tr>~;

      toggle_color();
      $html_output .=qq~
      <tr><th align="right" bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      <b>*</b>Search Which Forum(s)?
      </font>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      <SELECT NAME="s_forum">~;

      foreach (@{$r_setup->{'forums'}}) {

         my $display = 'yes';
         if ($r_setup->{'forum_type'}->{$_} eq 'Private') {
            $display = "no";
            if ($r_in->{'userdata'}->{'Group'} eq "admin" or
                  $r_in->{'userdata'}->{'Forums'} =~ /$_/) {
               $display = "yes";
            }
         }

         if ($display eq 'yes') {
            if ($_ eq $r_in->{'s_forum'}) {
               $html_output .=qq~
               <option VALUE="$_" selected>$r_setup->{'forum_name'}->{$_} ($r_setup->{'forum_type'}->{$_})
               ~;
             }
             else {
               $html_output .=qq~
               <option VALUE="$_">$r_setup->{'forum_name'}->{$_} ($r_setup->{'forum_type'}->{$_})
               ~;
            }
         }
       }

            if ($r_in->{'s_forum'} eq "all") {
            $html_output .=qq~
            <OPTION VALUE="all" selected>Search All Forums~;
            }
            else {
            $html_output .=qq~
            <OPTION VALUE="all">Search All Forums~;
            }

       $html_output .=qq~
      </SELECT>         
         </td>
         </tr>~;
         
      toggle_color();
      $html_output .=qq~
         <tr>
      <th align="right" bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Search which field(s)?
      </font>
         </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <select name="fields">~;
       foreach (@search_fields) {
           if ($_ eq $r_in->{'fields'}) {
             $html_output .=qq~
             <option VALUE="$_" selected>$_
             ~;
           }
           else {
             $html_output .=qq~
             <option VALUE="$_">$_
            ~;
           }
      }

      $html_output .=qq~
         </select>
         </td>
         </tr>~;
         
      toggle_color();
      $html_output .=qq~
         <tr>
      <th align="right" bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <b>**</b>Search how many days in the past?
      </font>
         </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <select name="days">~;

       foreach (@search_day) {
           if ($_ eq $r_in->{'days'}) {
             $html_output .=qq~
             <option VALUE="$_" selected>$search_days{$_}
             ~;
           }
           else {
             $html_output .=qq~
             <option VALUE="$_">$search_days{$_}
            ~;
           }
      }

      $html_output .=qq~
         </select>
         </td>
         </tr>~;
         
      toggle_color();
      $html_output .=qq~
         <tr>
      <th align="right" bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Search the Archive?
      </font>
         </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">~;
               
         if ($r_in->{'archive'}) {
            $html_output .=qq~
            <input type="checkbox" name="archive" value="yes" checked>~;
         }
         else {
            $html_output .=qq~
            <input type="checkbox" name="archive" value="yes">~;
         }

       $html_output .=qq~
         </td>
         </tr>~;
         
      toggle_color();
      $html_output .=qq~
         <tr>
      <td bgcolor="$bg_color_3">
      &nbsp;
      </td>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      <INPUT TYPE="SUBMIT" VALUE="Search Now!">
      <INPUT TYPE="RESET" VALUE="Reset">
      </FORM>
         </td>
         </tr>~;
         
      toggle_color();
      $html_output .=qq~
         <tr>
      <td bgcolor="$bg_color_3" colspan="2">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <b>*</b>Note: Searching every forum may take a while.
         <br>
         <b>**</b>Note: Searching all threads may take a while.
         <br>
         </font>
         </td>
         </TR>
         </TABLE>
      </center>
      <P>~;   

   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;
