# search.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function search                                                      #
# performs keyword search                                              #
#======================================================================#

sub search {

   my ($r_in,$r_setup) = @_;

   require "$cgilib/search_form.pl";
   require "$cgilib/dcforumlib2.pl";

   print_header();

   my $user_group = $r_in->{'userdata'}->{'Group'};
   my $last_read = $r_in->{'last_read'};
   my $html_output;
   my $exact_match = 'off';
   my $keywords = $r_in->{'keywords'};
   my @keyword_list = split(/\s+/,$keywords);
   my $search_field = $r_in->{'fields'};

   if ($r_in->{'check_private'} eq "yes" or
         $r_setup->{'forum_type'}->{ $r_in->{'s_forum'} } eq 'Private') {
         $r_in->{'userdata'} = check_user($r_in,$r_setup);
   }


   my ($dum, $dum, $temp,$dum)  =  search_form($r_in,$r_setup);

   print_header_end();

   my $heading = 'DCForum Search';
   my $sub_heading = '';
   my $menu_button = create_button("search",$r_in,$r_setup);
   
   my $table_heading;
   if ($r_setup->{'display_caption'} eq "on") {
      $table_heading = get_table_heading('main');
   }
   else {
      $table_heading = get_table_heading();
   }

#   if ($r_in->{'archive'}) {
#      $database = "arc_$database";
#   }

   if ($keywords eq "") {
      display_status("No Keywords",$r_in,$r_setup);
      exit(0);
   }

   my $number_of_hits = 0;

   if ($r_in->{'s_forum'} eq "all" ) {
      @forums = @{ $r_setup->{'forums'} };
   }
   else {
      @forums = ("$r_in->{'s_forum'}");
   }

   $html_output .=qq~
      <TABLE BORDER="0" CELLPADDING="3" WIDTH="$table_width">
   ~;
    
   foreach (@forums) {
  
      toggle_color('reset');

      my $forum = $_;
      my $topdir;
      my $topurl;

      my $hit = "no";
      my $html_new_mesg = "";
      my $access = "yes";
   
      #Search only the forums that users are allowed to access

      if ($r_setup->{'forum_type'}->{$_} eq 'Private') {
            $access = "no";
            if ($r_in->{'userdata'}->{'Group'} eq "admin" or
                  $r_in->{'userdata'}->{'Forums'} =~ /$_/) {
               $access = "yes";
               $topdir = "$privatedir/$forum";
            }
      }
      else {
         $access = "yes";
         $topdir = "$maindir/$forum";
         $topurl = "$mainurl/$forum";
      }

      
      if ($r_setup->{'forum_status'}->{$forum} eq "on"  && $access eq "yes") {   

         my $r_forum_data = readdata("$topdir/$database");
         my $forum_number_of_hits = 0;
   
         foreach (@$r_forum_data) {

            my ($num,$date,$ltime,$name,$subject,$caption,$lock,$read,
            $user_rating,$replies) = split /$split_delim/;

            $user_rating =~ s/^\s+//g;
            my @votes = split(/\,/,$user_rating);
            my $num_vote = @votes;
            my $rating = 0;
            if ($num_vote > 0) {
               foreach (@votes) {
                  $rating += $_;
               }
               $rating = sprintf("%.1f",$rating / $num_vote);
            }
            else {
               $rating = '-';
            }
      
            $subject = dc_decode($subject);
            $caption = dc_decode($caption);

            if ($r_setup->{'display_caption'} eq "on" 
               and $caption ne "") {
               $caption = "<br>$caption...";
               $caption = trim($caption);
               $caption =~ s/&pip;/$split_delim/g;
               $col_span = 5;
            }
            else {
               $caption = "";
               $col_span = 5;
            }

            $col_span++ if ($r_setup->{'user_rating'} eq 'on');      
            $col_span++ if ($r_setup->{'read_count'} eq 'on');    

            if (length($subject) > $subject_length_max) {
               $subject = substr($subject,0,$subject_length_max);
               $subject .= "...";
            }

            my ($hh,$minute,$second) = split(/\:/, $ltime);
            my ($mmonth,$dd,$yy) = split(/\//, $date);
            $yy += 1900 if ($yy < 100);
            my $mesg_mark = compute_time($yy, $mmonth, $dd, $hh, $minute, $second);
  
            unless ($mesg_mark > $last_read ) {
               unless ($r_in->{'arc_database'}) {
                  last;
               }
            }
            else {
   
               my $are_we_in_head = 0;
               my $filename = "$num";
   
               $fullpath = "$topdir/$thread_dir/$filename.$thread_ext";
      
               @not_found_words = @keyword_list; 
      
               unless (open(SEARCHFILE, $fullpath)) {
                  next;
               }
               else {
   
               while(<SEARCHFILE>) {
                  chomp;
                  my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = split /$split_delim/;
                  my $string;
                  $subject = dc_decode($subject);
                  $body = dc_decode($body);
                  
                  if ($search_field eq "Author") {
                     $string = $name;
                  }
                  elsif ($search_field eq "Subject") {
                     $string = $subject;
                  }
                  elsif ($search_field eq "Message") {
                     $string = $body;
                  }
                  else {
                     $string = $subject . $name . $body;
                  }

                  FindKeywords($exact_match, $string, *not_found_words);

               } # End of SEARCHFILE
   
               close (SEARCHFILE);
 
               if (@not_found_words < 1) {
 
                  $forum_number_of_hits++;
                  $number_of_hits++;

                  if ($forum_number_of_hits == 1) {

                     $html_output .= qq~
                     <TR><TH ALIGN="RIGHT" COLSPAN="$col_span" BGCOLOR="$bg_color_4">
                     <FONT SIZE="$font_size_4" COLOR="$font_color_4" FACE="$font_face_4">
                     <a href="$boardurl?az=list&forum=$forum">
                     $r_setup->{'forum_name'}->{$forum} Forum</a>
                     </FONT></TD></TR>
                     ~;
                     $html_output .= $table_heading;
                  }
   
                  $hit = "yes";
                  toggle_color();

                  $html_output .=qq~
                  <TR BGCOLOR="$bgcolor">~;
   
                  if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                       $html_output .=qq~
                           <TD valign="top"><img 
                           src="$imgurl/folder.gif"></td>
                           <TD valign="top"><FONT SIZE="$font_size" 
                           COLOR="$font_color" FACE="$font_face"><a 
                           href="$boardurl?az=show_thread&om=$num&forum=$forum"><b>$subject</b></a>
                           $caption</FONT></TD>
                       ~;
                  }
                  else {
                        $html_output .=qq~
                           <TD bgcolor="$bg_color_2" valign="top"><img 
                           src="$imgurl/folder.gif"></td>
                           <TD valign="top"><FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                           <a href="$mainurl/$forum/$num\.$ext"><b>$subject</b></a>
                           $caption</FONT>
                           </TD>
                        ~;
                  }
   
                  my $this_time = time_format($ltime);
                  my $ldate = date_format($date);
         
                  if ($r_setup->{'display_caption'} eq "on") {
               
                     $html_output .=qq~
                     <TD ALIGN="Left" VALIGN="TOP" COLSPAN="3">
                        <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                        <b>$name</b><br>
                        <b>$replies</b> Messages                     ~;
                     if ($r_setup->{'read_count'} eq 'on') {
                        $html_output .=qq~
                        <br><b>$read</b> views<br>~;        
                     }           
   
                        $html_output .=qq~
                        <font size="1">$date $ltime</font></FONT>
                     </TD>
                     </TR>
                     ~;
   
                  }
                  else {
                     $html_output .=qq~
                     <TD ALIGN="CENTER"  VALIGN="TOP"><FONT SIZE="$font_size" 
                     COLOR="$font_color" FACE="$font_face">$name</FONT></TD>      
                     <TD ALIGN="CENTER" VALIGN="TOP"><FONT SIZE="$font_size" 
                     COLOR="$font_color" FACE="$font_face">$ldate $this_time</FONT></TD>
                     <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2"><FONT 
                        SIZE="$font_size_2" 
                     COLOR="$font_color_2" FACE="$font_face_2">$replies</FONT></TD>
                     ~;



                     if ($r_setup->{'read_count'} eq 'on') {
                        $html_output .=qq~
                        <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2">
                        <FONT SIZE="$font_size_2" COLOR="$font_color_2" 
                           FACE="$font_face_2">$read</FONT>
                        </TD>~;        
                     }

                     if ($r_setup->{'user_rating'} eq 'on') {
                        $html_output .=qq~
                        <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2">
                        <FONT SIZE="$font_size_2" COLOR="$font_color_2" 
                           FACE="$font_face_2">$rating</FONT>
                        </TD>~;        
                     }

                     $html_output .=qq~
                     </TR>
                     ~;
                                       
                  }
   
               } # If there are no not_found_words
   
            } # unless
              
         } # If message is within last n days
   
      } # If access - yes
   
   } # Foreach file

   } #Foreach forum
  
   if ($number_of_hits == 0) {
      display_status("No Match",$r_in,$r_setup);
   }
  
   $html_output .= "</table>\n";

   $html_output .= $temp;

   return ($heading, $sub_heading, $html_output,$menu_button);

} # End of Search Subroutine


####
# subroutine FindKeyWords
# Written By Gunther Berzenik
####

sub FindKeywords {

   local ($exact_match, $line, *not_found_words) = @_;
   my ($x, $match_word);

   if ($exact_match eq "on") {
      for ($x = @not_found_words; $x > 0; $x--) {
         $match_word = $not_found_words[$x - 1];
         if ($line =~ /\b$match_word\b/i) {
            splice(@not_found_words,$x - 1, 1);
         } # End of If
      } # End of For Loop
   }
   else {
      for ($x = @not_found_words; $x > 0; $x--) {
         $match_word = $not_found_words[$x - 1];
         if ($line =~ /$match_word/i) {
            splice(@not_found_words,$x - 1, 1);
         } # End of If
      } # End of For Loop
   } # End of ELSE

} # End of FindKeywords

1;