# retrieve_password.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

sub retrieve_password {

   my ($r_in,$r_setup) = @_; 

   require "$cgilib/dcforumlib2.pl";
   require "$cgilib/auth_lib.pl";
   require "$cgilib/auth_lib_2.pl";

   my $r_local = {};
   my $az_type;
   my $heading, $sub_heading, $html_output;

   $heading = $forum_title;

   print_header();
   print_header_end();
   
   $r_local = auth_init($r_in,\@login_fields,\%field_form_type);

   if ($r_in->{'command'}) {

      # End of HTTP Header
      print_header_end();

      # Check and see if all required fields are completed
  
      my $user_id = $r_in->{'user_id'};
      my $user_email = $r_in->{'user_email'};

      my $new_password = get_session_id();
      $new_password = substr($new_password,1,6);

      srand(time|$$);
      my $salt = "";
      my $random = "abcdefghijklmnopqrstuvwxyz1234567890";
      for (1..2) {
            $salt .= substr($random,int(rand(36)),1);
      }

      my $cypted_password = my_crypt($new_password,$salt);

      # Read in user data
      my $r_data = readdata("$password_file_dir/$password_file");
      my $hit = '';
      my @row_data;
      for ($j=0;$j<@{$r_data};$j++) {
         my $row = $r_data->[$j];
         chomp($row);
         my $r_entry = [ split (/$split_delim/,$row) ];

         $r_entry->[$r_local->{'login_fields'}->{'EMail'}] 
               = remove_antispam($r_entry->[$r_local->{'login_fields'}->{'EMail'}]);

         if ($r_entry->[$r_local->{'login_fields'}->{'Username'}]
               eq $r_in->{'user_id'} 
               and $r_entry->[$r_local->{'login_fields'}->{'EMail'}] 
               eq $user_email) {

            $r_entry->[$r_local->{'login_fields'}->{'Password'}] = $cypted_password;
            foreach (@login_fields) {
               push(@row_data,$r_entry->[$r_local->{'login_fields'}->{$_}]);
            }
            my $temp_row = join("$join_delim",@row_data);
            $r_data->[$j]="$temp_row\n";
            $hit = 'yes';
            last;

         }

      }#End of foreach

      if ($hit) {
         # Update user database
         writedata("$password_file_dir/$password_file",$r_data);

my $username_password = qq~
Username: $r_in->{'user_id'}
Password: $new_password
~;

         my $r_mesg = readdata("$password_file_dir/$lost_password_file");
         # Send new password to the user
         my $subject = shift(@{$r_mesg});
         chomp($subject);
         my $mail_message = join("",@{$r_mesg});
         $mail_message =~ s/\r//g;
         $mail_message =~ s/USERNAME_PASSWORD/$username_password/;
         $mail_message =~ s/^[\s\t]+//g;

         send_mail($password_file_dir, $r_setup->{'auth_sendmail_path'},
         $r_setup->{'auth_admin_email_address'},
         $r_in->{'user_email'},$subject,$mail_message );

         $sub_heading = qq~
         Your new password has been sent to your email.<br>&nbsp;<br>
         If you do not receive it with in next 24 hours, <br>
         please contact
         the site administrator.
         <br>Thank you.<p>~;
      
         return ($heading, $sub_heading, $html_output,$menu_button);

      }
      else {
         $sub_heading = qq~
         There is no account that matches the username and the<br>
         email address you submitted.  Please try again or<br>
         contact the site administrator.<p>~;
      }

   }
   else {
      $sub_heading = qq~
      Please enter your username and email address.<br>
      A new password will be generated and sent to your email account.<p>~;
   }

      $html_output = qq~
      <form action="$boardurl" method="POST">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="doit">
      <table border="0" width="$table_width">
              <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
              Your Username </font></th>
              <td  bgcolor="$bg_color_3">
              <input type="text" name="user_id"
               value="$r_in->{'user_id'}" size="20">
              </td></tr>
              <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
              Your Email Address</font></th>
              <td  bgcolor="$bg_color_3">
              <input type="text" name="user_email"
              value="$r_in->{'user_email'}" size="20">
              </td></tr>
              <tr>
              <td bgcolor="$bg_color_3">
              &nbsp;
              </td>
              <td bgcolor="$bg_color_3">
              <input type="submit" value="Submit">
              </td></tr>
         </table>
      </form>
      ~;


   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;
