# list.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# list                                                                 #
# display threads in a nonthreaded mode                                #
#======================================================================#

sub list {
  
   my ($r_in,$r_setup) = @_;
   my $heading = $title;
   my $time_mark = $r_in->{'time_now'};
   my $temp_output;
   my $exist = "";
   my $msg_num;
   my $colspan = 5;
   my $r_user_mark = get_user_mark($r_in,$r_setup);
   my $moderator_email = $r_setup->{'forum_owner_email'}->{$forum};
   my $current_time = time_format($r_in->{'localtime'});
   my $current_date = date_format($r_in->{'date'});
   my $datafile  = "$maindir/$forum/$database";
   my $r_rowdata = readdata($datafile);
   my $num_messages = @{$r_rowdata};
   my $num_next = int(($num_messages - 1)/$mesg_max) + 1;
   my $start = $r_in->{'mm'} + 1;
   my $stop = $r_in->{'mm'} + $mesg_max;
   
  # End of HTTP Header
   &print_header();
   &print_header_end();

   # Create menu buttons
   my $menu_button = create_button('list',$r_in,$r_setup);
   
   # Oppps, forum is offline
   if ($r_setup->{'forum_status'}->{ $forum } ne "on") {
      ($heading,$sub_heading,$html_output) = 
         access_error('forum off',$r_in,$r_setup);
   }
   # Oppps, access is not allowed
   elsif ( ! check_forum_access($r_in,$r_setup,$forum) ) {
      ($heading,$sub_heading,$html_output) = 
         access_error('forum private',$r_in,$r_setup);
   }
   else {
      $stop = $num_messages if ($stop > $num_messages);
   
      my $heading = $forum_title;
   
      if ($r_in->{'archive'}) {
         $other = "[<a href=\"$boardurl?forum=$forum&az=list\">Current</a>
         ($r_setup->{'forum_threads'}->{$forum})]\n";
      }
      else {
         $other = "[<a href=\"$boardurl?forum=$forum&az=list&archive=yes\">Archive</a>
         ($r_setup->{'forum_archive'}->{$forum})]\n";
      }
   
      $stop--;
      $start--;
     
      for ($j=1;$j<=$num_next;$j++) {
   
         my $mesg_marker = ($j-1)*$mesg_max;
         my $j_start = ($j-1)*$mesg_max + 1;
         my $j_stop = $j*$mesg_max;
   
         $j_stop=$num_messages if ($j_stop > $num_messages);
   
         if ($mesg_marker == $start) {      
            $temp_output .=qq~
            [$j] ~;
         }
         else {
            $temp_output .=qq~
            [<A HREF="$boardurl?az=list&forum=$forum&mm=$mesg_marker&archive=$r_in->{'archive'}\">$j</A>] ~;
         }
      }
   
      $html_output .= qq~
         <TABLE BORDER="0" WIDTH="$table_width" cellspacing="1" cellpadding="2">
            <TR><TD ALIGN="RIGHT" VALIGN="BOTTOM" COLSPAN="5" BGCOLOR="$bg_color_4">
            <font face="$font_face_4" color="$font_color_4" size="1">
      ~;
   
      if ($r_in->{'userdata'}->{'Username'}) {
         $html_output .=  "$logged_on_as <b>$r_in->{'userdata'}->{'Username'}</b><br>";
      }
      else {
         $html_output .= "<b>$not_logged_on</b><br>";
      }
   
      $html_output .= qq~
      Moderator: <a href="mailto:$r_setup->{'forum_owner_email'}->{$forum}">$r_setup->{'forum_owner'}->{$forum}</a><br>
      Forum_type: $r_setup->{'forum_type'}->{$forum}<br>
      $current_date $current_time $time_zone<br>
      </FONT></TD></TR>
      <TR><TD COLSPAN="5" ALIGN="RIGHT" VALIGN="BOTTOM" BGCOLOR="$bg_color_4">
      <font face="$font_face_4" color="$font_color_4" size="$font_size_4">
      $temp_output $other
      </FONT>
      </TD></TR>
      <TR><TD COLSPAN="5" ALIGN="LEFT" VALIGN="BOTTOM" BGCOLOR="$bg_color_2">
      <font face="$font_face_2" color="$font_color_2" size="$font_size_2">
      <b><a href="$boardurl">Lobby</a> : ~;
      
      if ($r_setup->{'conf_listing'} eq 'on') {
         $html_output .= qq~
         <a href="$boardurl?conf=$r_setup->{'forum_conf'}->{$forum}">$r_setup->{
            'conf_name'}->{ $r_setup->{'forum_conf'}->{$forum} }Conference</a> : ~;
      }
      
      $html_output .= qq~
         $r_setup->{'forum_name'}->{$forum} Forum</b></FONT>
         </TD></TR>
      <a name="TOP">&nbsp;</a>
      ~;
   
      if ($r_setup->{'threaded_main_listing'} 
            eq "on" && $r_in->{'archive'} eq '') {
         $table_heading .= qq~
         <TR BGCOLOR="$bg_color_0">
            <TH ALIGN="LEFT" colspan="5">
               <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                     Discussions</font></TH></TR></TABLE>~;
      }
      elsif ($r_setup->{'display_caption'} eq "on") {
         $table_heading = get_table_heading('main');
      }
      else {
         $table_heading = get_table_heading();
      }
   
      $html_output .= $table_heading;
     
      my @row = @$r_rowdata[$start..$stop];
     
      toggle_color('reset');
   
      foreach (@row) {
   
         my $thisimg = "folder.gif";
         my $marker = '';
         my ($num,$date,$ltime,$name,$subject,$caption,$lock,$read,
            $user_rating,$replies) = split(/$split_delim/, $_);
   
         # Check to see if the user is a team member
         $name = check_team($name,$team);
         
         if ($r_setup->{'display_caption'} eq "on" && $caption ne "") {
            $caption = "<br>$caption...";
         }
         else {
            $caption = "";
         }
   
         if ($r_user_mark->{$forum} ne "") {
            if (check_new($ltime,$date,$r_user_mark->{$forum})) {
                   $marker = " <img src=\"$imgurl/newmark.gif\"> ";
            }
         }
         if ($lock or $r_in->{'archive'}) {
                   $thisimg = "locked_folder.gif";
         }
         if (length($subject) > $subject_length_max) {
            $subject = substr($subject,0,$subject_length_max);
            $subject .= "...";
         }
   
         # Fully threaded main listing
   
          if ($r_setup->{'threaded_main_listing'} eq "on" 
            and $r_in->{'archive'} eq '') {
   
            $colspan = 1;
            # If threaded_main is on, then display threaded main
   
            my $r_thread = readdata("$maindir/$forum/$thread_dir/$num.$thread_ext");
   
            # We don't need the first two records
            shift(@$r_thread);
            shift(@$r_thread);
   
            # total number of replies
            my $re_num = @{$r_thread};
   
            $ltime = time_format($ltime);
            $date = date_format($date);
   
            toggle_color();
   
            $html_output .=qq~
               <TABLE BORDER="0" WIDTH="$table_width" cellspacing="1" cellpadding="3">
               <TR BGCOLOR="$bgcolor">
               <TD ALIGN="LEFT" VALIGN="TOP">
               <img src="$imgurl/$thisimg">
               ~;
   
            if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
               $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum"><b>$subject</b></a> $marker
                  <b>$name</b>, $date, $ltime~;
            }
            else {
               $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$mainurl/$forum/$num\.$ext"><b>$subject</b></a> $marker
                  <b>$name</b>, $date, $ltime~;
            }
   
            $html_output .= "</TD></TR>\n";
   
            toggle_color();
   
            $html_output .= qq~
            <TR><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  ~;
   
            my $prev_level = 0;
            my $ul_count = 0;
   
            foreach (@$r_thread) {

               my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = split /$split_delim/;
   
               if (length($subject) > $subject_length_max) {
                  $subject = substr($subject,0,$subject_length_max);
                  $subject .= "...";
               }
   
               $subject =~ s/&pip;/$split_delim/g;
   
               # Check to see if the user is a team member
               $name = check_team($name,$team);
   
               my $icon = "file.gif";
               my $new_icon = '';
               my $space = ($level-1)*$level_spacing + 1;
               $space = 18 if ($level == 1);
   
               if ($r_user_mark->{$forum} ne "") {
                  my ($hh,$minute,$second) = split(/\:/, $ltime);
                  my ($mmonth,$dd,$yy) = split(/\//, $date);
                  $yy += 1900 if ($yy < 101);
                     my $last_mesg = compute_time($yy, $mmonth, $dd, $hh, $minute, $second);
                  $icon = "new_file.gif" if ($last_mesg > $r_user_mark->{$forum});
                  $new_icon = "<img src=\"$imgurl/newmark.gif\">" if ($last_mesg > $r_user_mark->{$forum});
               }
   
               $icon = "folder.gif" if ($level == 1);
               $ltime = time_format($ltime);
               $date = date_format($date);
   
               if ($level > $prev_level) {
                  for ($j=0;$j<$level-$prev_level;$j++) {
                     $html_output .= "<ul>\n";
                     $ul_count++;
                  }
               }
               elsif ($level < $prev_level) {
                  for ($j=0;$j<$prev_level-$level;$j++) {
                     $html_output .= "</ul>\n";
                     $ul_count--;
                  }
               }
   
               $prev_level = $level;
               
               if ($lock) {
               
                     $html_output .= qq~
                  <li><a href="$mainurl/$forum/$num\.$ext#$omm">$subject</a> $new_icon
                  <b>$name</b>, <font size="1">$ltime, $date</font>
                  ~;
               }
               else {
                     $html_output .= qq~
                  <li><a href="$boardurl?az=show_thread&omm=$omm&om=$num&forum=$forum">$subject</a> $new_icon
                  <b>$name</b>, <font size="1">$ltime, $date</font>
                  ~;
               
               }
   
            } #end of foreach $r_thread
   
            for ($j=0;$j<$ul_count;$j++) {
               $html_output .= "</ul>\n";
            }
   
   
            $html_output .=qq~
                  </FONT></TD></TR></table>
               ~;
   
   
         }
         elsif ($r_setup->{'display_caption'} eq "on") {
   
            $caption = trim($caption);
            $caption =~ s/&pip;/$split_delim/g;
            $html_output .=qq~
               <TR><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bg_color_2">
               <img src="$imgurl/$thisimg"></TD><TD ALIGN="LEFT" WIDTH="100%" VALIGN="TOP" BGCOLOR="$bgcolor">~;
   
            if ($re_num > $r_setup->{'max_messages'}) {
   
               if ($r_in->{'archive'} eq '') {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum&omm=0">$subject</a>~;
   
                  if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                     $html_output .=qq~
                     [<a href="$boardurl?az=show_thread&om=$num&forum=$forum">Display All</a>]
                     ~;
                  }
                  else {
                     $html_output .=qq~
                     [<a href="$mainurl/$forum/$num\.$ext">Display All</a>]
                     ~;
                  }
               }
               else {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum">$subject</a>~;
               }
   
                  $html_output .=qq~
                    $marker<br>$caption
                  </FONT></TD>
                  ~;
            }
            else {
               if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum">$subject</a>
                    $marker $caption</FONT></TD>
                  ~;
               }
               else {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$mainurl/$forum/$num\.$ext">$subject</a>
                    $marker $caption</FONT></TD>
                  ~;
               }
            }
      
            $ltime = time_format($ltime);
            $date = date_format($date);
      
            $html_output .=qq~
            <TD ALIGN="Left" VALIGN="TOP" COLSPAN="3" BGCOLOR="$bg_color_2">
               <FONT SIZE="$font_size_2" COLOR="$font_color_2" FACE="$font_face_2">
               <b>$name</b><br>
               <b>$replies</b> messages<br>
               <font size="1">$date $ltime</font></FONT>
            </TD>
            </TR>
            ~;
            toggle_color();
   
         }
         else {
   
            $html_output .=qq~
               <TR BGCOLOR="$bgcolor"><TD ALIGN="LEFT" VALIGN="TOP" bgcolor="$bg_color_2">
               <img src="$imgurl/$thisimg"></TD><TD ALIGN="LEFT" VALIGN="TOP">~;
   
            if ($re_num > $r_setup->{'max_messages'}) {
   
               if ($r_in->{'archive'} eq '') {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum&omm=0">$subject</a>~;
                  if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                     $html_output .=qq~
                     [<a href="$boardurl?az=show_thread&om=$num&forum=$forum">Display&nbsp;All</a>]
                     ~;
                  }
                  else {
                     $html_output .=qq~
                     [<a href="$mainurl/$forum/$num\.$ext">Display&nbsp;All</a>]
                     ~;
                  }
               }
               else {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum">$subject</a>~;
               }
   
               $html_output .= "  $marker $caption</FONT></TD>\n";
   
            }
            else {
   
               if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum">$subject</a>  $marker
                  </FONT></TD>
                  ~;
               }
               else {
                  $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$mainurl/$forum/$num\.$ext">$subject</a>  $marker
                  </FONT></TD>
                  ~;
               }   
            }
   
            $ltime = time_format($ltime);
            $date = date_format($date);
   
            $html_output .=qq~
            <TD ALIGN="CENTER"  VALIGN="TOP">
               <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">$name</FONT></TD>      
            <TD ALIGN="CENTER" VALIGN="TOP">
               <FONT SIZE="1" COLOR="$font_color" FACE="$font_face">$date $ltime</FONT>
            </TD>
            <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2">
               <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">$replies</FONT>
            </TD>
            </TR>
            ~;
            toggle_color();
   
         }
   
   
     } #End of foreach row
   
     if ($r_setup->{'threaded_main_listing'} 
            eq "on" && $r_in->{'archive'} eq '') {
      $html_output .=qq~
         <TABLE BORDER="0" WIDTH="$table_width" cellspacing="1" cellpadding="3">~;
     }
      
      $html_output .=qq~
      <TR><TD COLSPAN="$colspan" BGCOLOR="$bg_color_0" ALIGN="CENTER">
         <font size="$font_size_0">&nbsp;</font></TD></TR>
      <TR><TD COLSPAN="$colspan" ALIGN="RIGHT" VALIGN="BOTTOM" BGCOLOR="$bg_color_4">
      <font face="$font_face_4" color="$font_color_4" size="$font_size_4">
      $temp_output $other
      </FONT>
      </TD></TR></TABLE>~;
   }

   return ($heading, $sub_heading, $html_output,$menu_button);

}


1;