# read_count.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# read_count                                                           #
# display and keep track of message views                              #
#======================================================================#

sub read_count {

   my ($r_in,$r_setup) = @_;
   my $num_views;
   
   # First update the database.txt
   my $r_data = readdata("$maindir/$forum/$database");
   for($j=0;$j<@$r_data;$j++) {
      my $line = $r_data->[$j];
      chomp($line);
      my ($num,$date,$ltime,$name,$subject,
         $caption,$lock,$read,$user_rating,$replies) = split (/$split_delim/,$line);
      if ($num == $r_in->{'om'}) {
         $read++;
         $num_views = $read;
         my $temp = join("$join_delim",$num,$date,
            $ltime,$name,$subject,$caption,$lock,$read,$user_rating,$replies);
         $r_data->[$j] = "$temp\n";
         last;
      }
   }
   writedata("$maindir/$forum/$database",$r_data);

   # Next update the thread in Data.txt
   $r_data = []; # Flush $r_data
   $r_data = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}\.$thread_ext");

   my $first_line, $lock, $next_file_num, $user_rating, $num_read;
   $first_line = shift @{$r_data};
   chomp($first_line);

   # following unless statement is needed for
   # backward compatibility
   unless ($first_line =~ /\|/) {
      $next_file_num = $first_line;
      $lock = '';
      $user_rating = '';
   }
   else {
      ($next_file_num,$lock,$user_rating,$num_read) = split( /$split_delim/,$first_line);
   }

   $first_line = join("$join_delim",$next_file_num,$lock,$user_rating,$num_views);
   unshift(@{$r_data},"$first_line\n");

   writedata("$maindir/$forum/$thread_dir/$r_in->{'om'}\.$thread_ext",$r_data);

   if ( $r_setup->{'threaded_main_listing'} eq 'on' and $r_in->{'omm'} eq '0') {
      print_header();
      print_header_end();
      require "$cgilib/show_thread.pl";
      $r_in->{'forum'} = $forum;
      my ($heading,$sub_heading,$html_output,$menu_button) = show_thread($r_in,$r_setup);
      return ($heading,$sub_heading,$html_output,$menu_button);
   }

   unless ($r_setup->{'forum_type'}->{$forum} eq 'Private' 
         or $r_in->{'auto_sense'} eq 'on') {
      print "Location: $mainurl/$forum/$r_in->{'om'}.$ext\#$r_in->{'omm'}\n\n";
   }
   else {
      print_header();
      print_header_end();
      require "$cgilib/show_thread.pl";
      $r_in->{'forum'} = $forum;
      my ($heading,$sub_heading,$html_output,$menu_button) = show_thread($r_in,$r_setup);
      return ($heading,$sub_heading,$html_output,$menu_button);
   }

   exit;
}

1;