# print_topic.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function print_topic
# display the topic in printer friendly format
#======================================================================#

sub print_topic {

   my ($r_in,$r_setup) = @_;
   my $output, $mesg;
   require "$cgilib/dcforumlib2.pl";
   
   print_header();
   print_header_end();

   my $r_thread = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");
   shift(@$r_thread);

   my $prev_level = 0;
   my $ul_count = 0;

   foreach (@$r_thread) {
      chomp;

      my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = split /$split_delim/;
      $body =~ s/&pip;/$split_delim/g;
      $subject =~ s/&pip;/$split_delim/g;
      $body = text_to_html($body);
      $subject = dc_decode($subject);
      $ltime = time_format($ltime);
      $date = date_format($date);

      $email = '';

      unless ($r_in->{'az'} eq 'email_to_friend') {

         if ($omm == 0) {
            $output .= qq~
            <b><font size=2>Original Message<hr>"$subject"</font></b><br>
            Posted by $name $email on $date at $ltime<br>
            <blockquote>$body</blockquote><hr>~;
         }
         else {

            $mesg .= qq~
            <b>"$subject"</b><br>
            Posted by $name $email on $date at $ltime<br>
            <blockquote>
            $body
            </blockquote>
            <hr>~;

            if ($level > $prev_level) {
               for ($j=0;$j<$level-$prev_level;$j++) {
                  $toc .= "<ul>\n";
                  $ul_count++;
               }
            }
            elsif ($level < $prev_level) {
               for ($j=0;$j<$prev_level-$level;$j++) {
                  $toc .= "</ul>\n";
                  $ul_count--;
               }
            }

            $prev_level = $level;
            $toc .= qq~
               <li><b>$subject</b>,<b>$name</b>, $ltime, $date
            ~;
         }

      }
      else {

         $body =~ s/<p>/\n\n/gi;
         $body =~ s/<br>/\n/gi;
         $body =~ s/\&nbsp;/ /gi;
         $body =~ s/<([^>]|\n)*>//g;

         if ($omm == 0) {
            $output .= qq~
               ========================================================
               Original Message - "$subject"
               Posted by $name $email on $date at $ltime
            ........................................................
               $body
               ========================================================
               ~;
            $output =~ s/^\s+//g;
         }
         else {
            $mesg .= qq~Reply Number $omm - "$subject"
            Posted by $name $email on $date at $ltime
            ........................................................
            $body
            ========================================================
            ~;
            $mesg =~ s/^\s+//g;
         }

      } # else

   }

   for ($j=0;$j<$ul_count;$j++) {
      $toc .= "</ul>\n";
   }

   unless ($r_in->{'az'} eq 'email_to_friend') {
      $output .= "<b><font size=2>Table of contents</font></b><hr>\n";
      $output .= "$toc\n";
      $output .= "<hr><b><font size=2>Messages in this discussion</font></b><hr>\n";
      $output .= "$mesg\n";
   }
   else {
      $output .= "$mesg\n";
   }

   $output =~ s/\n\s+/\n/g;
   
   return $output;

}

1;