# n_mesg.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function n_mesg                                                      #
# displays the topics from last x days                                 #
#======================================================================#

sub n_mesg {

   my ($r_in,$r_setup) = @_;
   my $table_heading;
   my $col_span;
   my $user_group = $r_in->{'userdata'}->{'Group'};
   my $any_hits = "no";
   my $r_user_mark = get_user_mark($r_in,$r_setup);
   my $heading = $forum_title;
   my $sub_heading = "<b>Reading new or recent messages</b>";
   my $menu_button = create_button("new_message",$r_in,$r_setup);

   # column span for listing topics
   my $colspan = 5;

   # If user_rating is ON, then we need extra column
   if ($r_setup->{'user_rating'} eq 'on') {
      $colspan++;
   }

   # If read_count is ON, then we need extra column
   if ($r_setup->{'read_count'} eq 'on') {
      $colspan++;
   }

   # Reference colspan so that it can be used globally
   $r_in->{'colspan'} = $colspan;

   print_header();
   print_header_end();

   my $html_output = qq~
   <p><TABLE BORDER="0" CELLPADDING="3" 
      CELLSPACING="1" WIDTH="$table_width">
   ~;

   if ($r_setup->{'display_caption'} eq "on") {
      $table_heading = get_table_heading('main');
   }
   else {
      $table_heading = get_table_heading();
   }

   foreach $forum (@{$r_setup->{'forums'}}) {
  
      my $hit = "no";
      my $html_new_mesg;
      my $f_ext;
      my $access = "no";
      my $last_mark = $r_in->{'last_read'};

      toggle_color('reset');

      if ($r_user_mark->{$forum} ne "") {
         $last_mark = $r_user_mark->{$forum};
      }
      elsif ($session) {
         $last_mark = 0;
      }

      if ($r_setup->{'forum_type'}->{$forum} eq 'Private') {
         if ($user_group eq "admin" ||
                  $user_group eq "moderator" ||
                  $user_group eq "member") {
             $access = "yes";
             $fullpath = "$privatedir/$forum";
             $f_ext = $privateext;
         }
      }
      else {
         $fullpath = "$maindir/$forum";
         $access = "yes";
         $f_ext = $ext;
      }

      if ($r_setup->{'forum_status'}->{$forum} eq "on"  && $access eq "yes") {   

         my $r_rowdata = &readdata("$fullpath/$database");
    
         foreach (@$r_rowdata) {

            my $folder = "file.gif";
            chomp;
            my ($num,$date,$ltime,$name,$subject,$caption,$lock,$read,
               $user_rating,$replies) = split /$split_delim/;
            $folder = "locked_file.gif" if ($lock);
            $user_rating =~ s/^\s+//g;
            my @votes = split(/\,/,$user_rating);
            my $num_vote = @votes;
            my $rating = 0;
            if ($num_vote > 0) {
               foreach (@votes) {
                  $rating += $_;
               }
               $rating = sprintf("%.1f",$rating / $num_vote);
            }
            else {
               $rating = '-';
            }
      
            $subject = dc_decode($subject);
            $caption = dc_decode($caption);

            if ($r_setup->{'display_caption'} eq "on" 
              and $caption ne "") {

               $caption = "<br>$caption...";
               $caption = trim($caption);
               $caption =~ s/&pip;/$split_delim/g;

            }
            else {
               $caption = "";
            }

            if (length($subject) > $subject_length_max) {
               $subject = substr($subject,0,$subject_length_max);
               $subject .= "...";
            }

            my ($hh,$minute,$second) = split(/\:/, $ltime);
            my ($mmonth,$dd,$yy) = split(/\//, $date);
            my $mesg_mark = compute_time($yy, $mmonth, $dd, $hh, $minute, $second);
    
            if ($mesg_mark > $last_mark ) {
               toggle_color();
               $hit = "yes";
               $html_new_mesg .=qq~
               <TR BGCOLOR="$bgcolor">
               <TD ALIGN="Left" VALIGN="TOP" bgcolor="$bg_color_2"><img 
               src="$imgurl/$folder"></td>
               <TD valign="top">~;

               if ($r_setup->{'read_count'} eq 'on') {
                     $html_new_mesg .=qq~
                     <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                     <a href="$boardurl?az=read_count&om=$num&forum=$forum"><b>$subject</b></a>
                     $caption
                     </FONT></TD>~;
               }
               else {
                  if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                     $html_new_mesg .=qq~
                     <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                     <a href="$boardurl?az=show_thread&om=$num&forum=$forum"><b>$subject</b></a>
                     $caption
                     </FONT></TD>~;
                  }
                  else {
                     $html_new_mesg .=qq~
                     <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                     <a href="$mainurl/$forum/$num\.$f_ext"><b>$subject</b></a>
                     $caption</FONT>
                     </TD>~;
                  }              
               }

               $ltime = time_format($ltime);
               $date = date_format($date);
      
               if ($r_setup->{'display_caption'} eq "on") {
            
                  $html_new_mesg .=qq~
                  <TD ALIGN="Left" VALIGN="TOP" COLSPAN="3" bgcolor="$bg_color_2">
                     <FONT SIZE="$font_size_2" COLOR="$font_color_2" FACE="$font_face_2">
                     <b>$name</b><br>
                     <b>$replies</b> Messages<br>~;

                  if ($r_setup->{'read_count'} eq 'on') {
                     $html_new_mesg .=qq~
                     <b>$read</b> views<br>~;         
                  }           

                     $html_new_mesg .=qq~
                     <font size="1">$date $ltime</font></FONT>
                  </TD>
                  </TR>
                  ~;
               }
               else {
            
                  $html_new_mesg .=qq~
                  <TD ALIGN="CENTER"  VALIGN="TOP"">
                     <FONT SIZE="$font_size" COLOR="$font_color" 
                     FACE="$font_face">$name</FONT></TD>      
                  <TD ALIGN="CENTER" VALIGN="TOP">
                     <FONT SIZE="$font_size" COLOR="$font_color" 
                     FACE="$font_face">$date $ltime</FONT>
                  </TD>
                  <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2">
                     <FONT SIZE="$font_size_2" COLOR="$font_color_2" 
                     FACE="$font_face_2">$replies</FONT>
                  </TD>~;

                  if ($r_setup->{'read_count'} eq 'on') {
                     $html_new_mesg .=qq~
                     <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2">
                     <FONT SIZE="$font_size_2" COLOR="$font_color_2" 
                     FACE="$font_face_2">$read</FONT>
                     </TD>~;        
                  }           

                  if ($r_setup->{'user_rating'} eq 'on') {
                     $html_new_mesg .=qq~
                     <TD ALIGN="CENTER" VALIGN="TOP" bgcolor="$bg_color_2">
                     <FONT SIZE="$font_size_2" COLOR="$font_color_2" 
                     FACE="$font_face_2">$rating</FONT>
                     </TD>~;        
                  }           

                  $html_new_mesg .=qq~
                  </TR>
                  ~;
               }

             }

            else {
               last;
            }


         } #END of foreach


      } #END of if

      if ($hit eq "yes") {
         $any_hits = "yes";
         $html_output .=qq~
         <TR><TH ALIGN="RIGHT" COLSPAN="$colspan" BGCOLOR="$bg_color_4">
         <a href="$boardurl?az=list&forum=$forum"><FONT SIZE="2" 
            COLOR="$font_color_4" FACE="$font_face_4">
         $r_setup->{'forum_name'}->{$forum} Forum</FONT></a></TD></TR>
         ~;
         $html_output .= $table_heading;
         $html_output .= $html_new_mesg;
      }

   } # END OF EACH FORUM
   
   if ($any_hits eq "no") {
      $html_output .=qq~
         <TR><TH ALIGN="CENTER" COLSPAN="$colspan" BGCOLOR="$bg_color_4">
         <FONT SIZE="2" COLOR="$font_color_4" FACE="$font_face_4">
         There were no new messages posted in last $r_in->{'days'} days.
         </FONT/>
         </TH></TR>~;
   }

   $html_output .= "</TABLE>\n";  

   return ($heading, $sub_heading, $html_output,$menu_button);
     
}

1;