# mark.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#


#======================================================================#
# mark                                                                 #
# time stamp a forum or all forums                                     #
#======================================================================#

sub mark {

   my ($r_in, $r_setup) = @_;

   require "$cgilib/dcforumlib2.pl";

   my $exist = "";
   my $user_file = "$logdir/$r_in->{'userdata'}->{'Username'}\.log";
   my @start;
   my @rows;

   $r_in->{'userdata'} = check_user($r_in,$r_setup);

   # initialize an array of forum name and some
   # arbitrary number which will be saved if the user clicked on
   # Mark icon for the first time

   check_datafile($user_file,[]);
   $r_rows = readdata($user_file);

   if ($forum eq "all") {
      foreach (@{$r_setup->{'forums'}}) {
         my $temp = join("=",$_,$r_in->{'time_now'});
         push(@rows,"$temp\n")
      }
   }
   else {

      foreach $pair (@{$r_rows}) {
         chomp($pair);
         my ($forum_name,$lastread) = split(/=/,$pair);
         if ($forum_name eq $forum) {
            $exist = "yes";
            $temp = join("=",$forum,$r_in->{'time_now'});
            push(@rows,"$temp\n");
         }
         else {
            push(@rows,"$pair\n");
         }
      }

      unless ($exist) {
         $temp = join("=",$forum,$r_in->{'time_now'});
         push(@rows,"$temp\n");
      }

   }

   writedata($user_file,\@rows);

   unless ($r_setup->{'conf_listing'} eq 'on') {
      print "Location: $boardurl\n\n";
   }
   else {
      print "Location: $boardurl?conf=$r_in->{'conf'}\n\n";
   }
}

1;