# lobby.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function lobby                                                       #
# displays the forums in conferences                                   #
#======================================================================#

sub lobby {

   my ($r_in,$r_setup) = @_;
 
   my $r_conf_forums = {};
   my $r_conf_count = {};
   my $r_user_mark = {};
   my $heading, $sub_heading, $menu_button, $html_output;
   my $current_time = time_format($r_in->{'localtime'});
   my $current_date = date_format($r_in->{'date'});
   my $colspan = 5;

   # Create menu buttons
   $menu_button = create_button('lobby',$r_in,$r_setup);

   # Define heading
   $heading = $forum_title;

   # Send HTTP header and end it
   print_header();
   print_header_end();


   # Ger user's time stamps
   $r_user_mark = get_user_mark($r_in,$r_setup);

   # shrink colspan by one
   $colspan--;

   $html_output .= qq~
      <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="2">
      <TR><TD ALIGN="LEFT" VALIGN="BOTTOM" colspan="$colspan" BGCOLOR="$bg_color_4">
         <font face="$font_face_4" color="$font_color_4" size="1">&nbsp;<br>~;

   # if announcement exists, then display
   # announcement link
   if (-s "$password_file_dir/$announcement" > 2) {
         $html_output .= qq~
         <img src="$imgurl/announcement.gif" align="top"><a 
         href="$boardurl?az=read_announcements"><font face="$font_face_4" 
         color="$font_color_4" size="1">Announcements</FONT></a><br>~;
   }

   if ($r_in->{'userdata'}->{'Username'}) {
       $html_output .=  qq~
         <img src="$imgurl/user_profiles.gif" align="bottom" border="0"><a 
            href="$boardurl?az=user_profiles"><font 
               face="$font_face_4" color="$font_color_4" size="1">View User Profiles</font></a><br>
       <img src="$imgurl/read_new.gif"><a 
         href=\"$boardurl?az=n_mesg&user=$r_in->{'userdata'}->{'Username'}\"><font 
         face="$font_face_4" color="$font_color_4" size="1">Read New Messages</font></a><br>~;  
   }
   else {
       $html_output .=  qq~
       <img src="$imgurl/read_new.gif"><a 
         href="$boardurl?az=n_mesg&days=3"><font 
         face="$font_face_4" color="$font_color_4" size="1">Read Recent Messages</font></a><br>~;  
   }

   $html_output .= qq~
      </FONT></TD><TD ALIGN="RIGHT" VALIGN="BOTTOM" BGCOLOR="$bg_color_4">
         <font face="$font_face_4" color="$font_color_4" size="1">~;


   # If the lobby only lists conferences, then
   # include site map link 
   if ($r_setup->{'conf_listing'} eq 'on' and $r_in->{'conf'} eq '') {
      $html_output .= qq~
      <a href="$boardurl?az=site_map"><font face="$font_face_4" 
         color="$font_color_4" size="$font_size_4">Site Map</FONT></a><br>~;
   }

   # If the user is lodded on, show username
   # and date and time
   if ($r_in->{'userdata'}->{'Username'}) {
      $html_output .=  qq~
      Logged on as <b>$r_in->{'userdata'}->{'Username'}</b><br>
            $current_date $current_time $time_zone
      ~;
   }
   else {
       $html_output .=  qq~
       <b>First time visitor?</b> <a href="$boardurl?az=user_register">Please Register</a>~;
   }



   $html_output .= qq~
      </FONT></TD></TR>
   ~;

   # increase colspan by 1
   $colspan++;
   $r_in->{'colspan'} = $colspan;
   
   # display navigation menu
   $html_output .= navigation_menu($r_in,$r_setup);
   $html_output .= "</Table>";

   $html_output .= qq~
      <TABLE BORDER="0" WIDTH="$table_width" CELLPADDING="3" CELLSPACING="1">~;

   foreach (@{$r_setup->{'forums'}}) {

      if ($r_setup->{'forum_status'}->{$_} eq "on" && 
         check_forum_access($r_in,$r_setup,$_) ) {

         if ($r_in->{'conf'}) {
            if ($r_in->{'conf'} eq $r_setup->{'forum_conf'}->{$_}) {
                   push( @{ $r_conf_forums->{$r_setup->{'forum_conf'}->{$_}} } , $_);
                      $r_conf_count->{$r_setup->{'forum_conf'}->{$_}}++;
            }
         }

         else {
                push( @{ $r_conf_forums->{$r_setup->{'forum_conf'}->{$_}} } , $_);
               $r_conf_count->{$r_setup->{'forum_conf'}->{$_}}++;
         }

      }

   }

   toggle_color('reset');

   # Display forums in the lobby, in the order of the
   # conferences
   unless ($r_setup->{'conf_listing'} eq 'on' and $r_in->{'conf'} eq '') {

      foreach $conf (@{$r_setup->{'conf'}}) {
   
         if ($r_conf_count->{$conf} and $r_setup->{'conf_status'}->{$conf} eq 'on') {
            $html_output .= qq~
            <TR><TD ALIGN="CENTER" VALIGN="TOP" BGCOLOR="$bg_color_0" colspan="2">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            $r_setup->{'conf_name'}->{$conf} Conferences</font></TD><TD 
            ALIGN="CENTER" VALIGN="TOP" BGCOLOR="$bg_color_0">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Forum&nbsp;Type
            </font></TD>
            <TD ALIGN="CENTER" VALIGN="TOP" BGCOLOR="$bg_color_0">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Moderator
            </font></TD>
            <TD ALIGN="CENTER" VALIGN="TOP" BGCOLOR="$bg_color_0">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Forum&nbsp;Information
            </font></TD>
            </TR>
            ~;
   
            foreach (@{ $r_conf_forums->{$conf} }) {
   
               if ($r_setup->{'forum_status'}->{$_} eq "on" && 
                  check_forum_access($r_in,$r_setup,$_) ) {
   
                  my $thisimg = "folder.gif";
                  if ($r_setup->{'forum_queue'}->{$_} eq 'on') {
                     $thisimg = "locked_folder.gif";
                  }

                  my $moderator_email = $r_setup->{'forum_owner_email'}->{$_};
                  my $marker = "";
   
                  $r_setup->{'forum_desc'}->{$_} =~ s/&gt;/>/g;
                  $r_setup->{'forum_desc'}->{$_} =~ s/&lt;/</g;
   
                  my ($ltime,$date) = split(/\s/, $r_setup->{'forum_last'}->{$_});
   
                  if ($r_user_mark->{$_} ne '') {
                     if (check_new($ltime,$date,$r_user_mark->{$_})) {
                        $marker = "<img src=\"$imgurl/newmark.gif\">";
                     }

                  }
                  elsif ($r_in->{'userdata'}->{'Username'} and
                     $r_setup->{'forum_threads'}->{$_}) {
                     $marker = "<img src=\"$imgurl/newmark.gif\">";
                  }
   
                  $ltime .= ":00";
                  $ltime = time_format($ltime);
                  $date = date_format($date);
   
                  $html_output .= qq~
                  <TR><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bg_color_2">
                  <img src="$imgurl/$thisimg"><br></td><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
                  <font size="$font_size" face="$font_face" color="$font_color">
                  <b><a href="$boardurl?az=list&forum=$_&conf=$conf">$r_setup->{'forum_name'}->{$_}</a>
                  $marker<br></b></font>
                  <font size="$font_size" face="$font_face" color="$font_color">
                  $r_setup->{'forum_desc'}->{$_}
                  </font></TD><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
                   <font size="$font_size" face="$font_face" color="$font_color">
                  $r_setup->{'forum_type'}->{$_}~;
                  
                  $html_output .= qq~
                  </font></td>
                  <TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
                   <font size="$font_size" face="$font_face" color="$font_color">
                   ~;

                  # display forum moderators
                  my @owners = split(/,/,$r_setup->{'forum_owner'}->{$_});
                  foreach (@owners) {
                     $html_output .= qq~
                     &nbsp;&nbsp;<a href="$boardurl?az=email_user&userid=$_">$_</a><br>
                     ~;
                  }
                  
                  $html_output .= qq~
                  </font></TD><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bg_color_2">
                   <font size="$font_size" face="$font_face" color="$font_color">
                  <font size="1">$date $ltime</font><br>
                  <b>$r_setup->{'forum_threads'}->{$_}</b><font size="1">&nbsp;Topics</font>
                  <br><b>$r_setup->{'forum_posts'}->{$_}</b><font size="1">&nbsp;Messages</font>
                  </font></td>
                  </TR>~;

#                 Don't display the archived messages
#                 <br><b>$r_setup->{'forum_archive'}->{$_}</b><font size="1">Archive_discussions</font>

                  toggle_color();
   
               }
            }
         }

      }# End of foreach

   }
   # display only conferences in the Lobby
   else {

      $html_output .= qq~
      <TR><TH ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bg_color_0" colspan="2">
      <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
      Conferences
      </font></TD></TR>
      ~;
      
      my @conf_count;
      foreach (@{$r_setup->{'conf'}}) {
         if ($r_setup->{'conf_status'}->{$_} eq 'on') {
            push(@conf_count,$_);
         }
      }

      my $num_conf = @conf_count;
      for ($j=0;$j<$num_conf/2;$j++) {

         my $this = $conf_count[2*$j];
         $html_output .= qq~
            <TR>
            <TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
            <img src="$imgurl/folder.gif">
            <font size="$font_size" face="$font_face" color="$font_color">
            <b><a href="$boardurl?conf=$this">$r_setup->{'conf_name'}->{$this}</a> 
            </b>($r_conf_count->{$this})<br>$r_setup->{'conf_desc'}->{$this}</font><br>
            <font size="$font_size" face="$font_face" color="$font_color">
            $conf_desc
            </font></TD>~;

         $this = $conf_count[2*$j+1];

         if ($r_setup->{'conf_name'}->{$this}) {
            $html_output .= qq~
            <TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
            <img src="$imgurl/folder.gif">
            <font size="$font_size" face="$font_face" color="$font_color">
            <b><a href="$boardurl?conf=$this">$r_setup->{'conf_name'}->{$this}</a></B>
            ($r_conf_count->{$this})
            <br>$r_setup->{'conf_desc'}->{$this}</font><br>
            <font size="$font_size" face="$font_face" color="$font_color">
            $conf_desc</font></TD>~;
         }
         else {
            $html_output .= qq~
            <TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bgcolor">
            &nbsp;
            </font></TD>~;
         }

           toggle_color();

         $html_output .= qq~
           </TR>~;

      }
   
   }

   $html_output .= "</TABLE>";
   
   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;