#!/usr/bin/perl
# init.cgi
# Part of DCForum2000 Version 1.0 by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# to accept the terms of this Agreement. This Agreement is
# a legal contract, which specifies the terms of the license
# As part of the installation process, you will be asked
# and warranty limitation between you and DCScripts and DCForum.
# You should carefully read this terms agreement as outlined in
# the readme.txt file included with this distribution before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of the Software.
###################################################################

sub init {

   print_header();
   print_header_end();

   $| = 1;

   print qq~
      <html>
      <head>      
      </head>
      <body>
   ~;
   
   unless ($r_in->{'init'}) {
      print qq~
      <font size=2 face=verdana color=#000066>
      <font size=3><strong>
      Welcome to DCForum Setup Program.
      <p>
      The program will now create required folders and files.
      Should there be any errors, please go back and check your settings.<p>
      <a href="$adminurl?init=yes">Click here to continue with initial setup</a>
      </strong></font></body></html>~;
      exit;
   }

   my %setup_vars = (
      bg_color_0 => '#000099',
      font_color_0 => '#FFFFFF',
      font_face_0 => 'Verdana',
      font_size_0 => '1',
      bg_color_1 => '#FFFFFF',
      font_color_1 => '#000099',
      font_face_1 => 'Verdana',
      font_size_1 => '2',
      bg_color_2 => '#E7E7DE',
      font_color_2 => '#000099',
      font_face_2 => 'Verdana',
      font_size_2 => '2',
      bg_color_3 => '#E7E7DE',
      font_color_3 => '#000099',
      font_face_3 => 'Verdana',
      font_size_3 => '2',
      bg_color_4 => '#FFFFFF',
      font_color_4 => '#000099',
      font_face_4 => 'Verdana',
      font_size_4 => '1',
      bg_color_5 => '#FFFFFF',
      font_color_5 => '#000099',
      font_color_6 => '#FF0000',
      font_face_5 => 'Verdana',
      font_size_5 => '1',
      forum_title => 'DCForum2000 Discussion Forum',
      time_offset => '0',
      time_zone => 'GMT',
      date_format => 'mmm-dd-yy',
      mesg_max => '30',
      level_max => '12',
      level_spacing => '18',
      subject_length_max => '35',
      word_length_max => '40',
      max_messages => '20',
      max_threads_allowed => '200',
      auto_archive => 'off',
      message_indent => 'on',
      hide_private => 'on',
      use_icons => 'off',
      use_icons_toc => 'off',
      display_caption => 'off',
      caption_length => '150',
      allow_expand => 'on',
      table_width => '100%',
      icon_text => 'off',
      show_orig_mesg => 'off',
      html_allowed => 'off',
      edit_allowed => 'on',
      edit_time_out => '60',
      image_allowed => 'on',
      conf_listing => 'off',
      threaded_main_listing => 'off',
      threaded_discussion => 'on',
      reverse_thread => 'on',
      email_to_admin => 'off',
      email_to_mod => 'off',
      email_notification => 'off',
      subscription => 'off',
      display_ip_address => 'off',
      ip_blocking => 'off',
      read_count => 'off',
      user_rating => 'on',
      file_upload => 'on',
      file_upload_size => '50',
      auth_bad_word_list => 'fuck,shit,tits,motherfuck,dick,blowjob',
      auth_admin_email_address => 'you@youremail.com',
      auth_sendmail_path => '/usr/lib/sendmail',
      auth_smtp_server => 'mail.yoursmtpserver.com',
      auth_register_via_email => 'off',
      auth_allow_registration => 'on',
      auth_default_group => 'normal',
      auth_activate_user_on_registration => 'on',
      auth_allow_password_remembering => 'on',
      auth_notify_admin_on_registration => 'off',
      auth_notify_user_on_activation => 'off',
      auth_allow_account_mod => 'off',
      auth_allow_password_mod => 'on',
      auth_bad_emails => 'hotmail.com,usa.net,iname.com,excitemail.com'
   
   );
   
   foreach (keys %setup_vars) {
      my $temp = join("$join_delim",$_,$setup_vars{$_});
      push (@variables,"$temp");
   }

   @dir_list = (
      $profile_dir,
      $sessiondir,
      $tempdir,
      $logdir
   );
   
   $error = '';

   unless (-e "$uploaddir") {
      if (check_d("$uploaddir")) {
         $error = 1;
         $ERROR .= "<li>ERROR: Could not create <b>$uploaddir</b> directory.
         Please check and make sure \$maindir 
         (currently set to \"$maindir\") exists and is defined correctly.
         Also make sure that this directory is set to 777.
         <p>";
      }
   }
   
   foreach (@dir_list) {
      unless (-e "$_") {
         if (check_d("$_")) {
            $error = 1;
            $ERROR .= "<li>ERROR: Could not create <b>$_</b> directory.
            Please check and make sure \$password_file_dir (Currently set
            to \"$password_file_dir\") exists and is defined correctly.
            Also make sure that this directory is set to 777.
            <p>";
         }
      }
   }
   
   
   @init_files = (
   $password_file,
   $team_file_name,
   $conf_file,
   $forum_file,
   $ipfile,
   $bad_ip_list,
   $subscription,
   $subscription_list,
   $faq_list,
   $logfile,
   $queue,
   $announcement,
   $upload_log
   );
   
   foreach (@init_files) {
      unless (-e "$password_file_dir/$_") {
         unless( check_f("$password_file_dir/$_") ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $board_setup_file...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }
      }
   }
   
   unless (-e "$password_file_dir/$board_setup_file") {
         unless( check_f("$password_file_dir/$board_setup_file",\@variables) ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $board_setup_file...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }
   }

   # Create Email registration reply body

   unless (-e "$password_file_dir/$email_registration_file") { 

         my $note = qq~DCForum Registration Information
Thank you for registering to use our forum.
Following is your login information:

USERNAME_PASSWORD

Please goto $boardurl and select login icon to login.
Then, to change your password, click on DCUser Icon.

Thank you.

Your Signature Block
~;

         unless( check_f("$password_file_dir/$email_registration_file",["$note"] ) ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $email_registration_file...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }


   }

   # Create Email subscription body
   unless (-e "$password_file_dir/$subscription_message_file") {  

         my $note = qq~Subscription to forum at $boardurl
Thank you for subscribing to our forum.
Following are new messages posted in the forums
that you are subscribed to.  If you have any questions or
comments, please email us you\@yourdomain.com.

Thank you again,

Your signature...
~;
         unless( check_f("$password_file_dir/$subscription_message_file ",["$note"] ) ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $subscription_message_file ...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }


   }

   # Create Email notification message body
   unless (-e "$password_file_dir/$email_notification_file") { 
         my $note = qq~You have new message in forum
A new message has been posted in the forum.

EMAIL_NOTIFICATION_MESSAGE

You receive this email because you asked to be 
notified of follow-up messages when you posted a 
message in this thread.  This notification service 
informs you of new messages in the above mentioned 
thread only.

Thank you for using our forum.


Your Signature Block
~;
         unless( check_f("$password_file_dir/$email_notification_file",["$note"] ) ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $email_notification_file...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }
   }

   # Create message files for lost password reply
   unless (-e "$password_file_dir/$lost_password_file") {   

         my $note = qq~Forum Account Information at $homeurl.
This email is sent by DCForum Email retrieval system
at $homeurl.  If you have not requested this service,
please reply to this email and let the administrator
of the web site be aware.  Thank you.
------------------------------------------------
Here is your account information:

USERNAME_PASSWORD

Goto $boardurl
and click on Login icon or login text.
Please change your password the first time you login
by clicking on the User icon or text and choosing
"Change Password" option.


Thank you.

Forum Administrator
~;
         unless( check_f("$password_file_dir/$lost_password_file ",["$note"] ) ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $lost_password_file...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }


   }


   # Create User Manager reply body

   unless (-e "$password_file_dir/$account_action_file") {  

         my $note = qq~DCForum Account Status Report
This email is generated by the forum program at
$boardurl.  Following change has been made to your account:

ACCOUNT_CHANGE

If you have any questions, please contact us at
you\@yourdomain.com

Thank you.

Your Signature Block
~;

         unless( check_f("$password_file_dir/$account_action_file",["$note"] ) ) {
            $error = 1;
            $ERROR .=  "<li>ERROR - could not create $account_action_file...check and 
            see if $password_file_dir is defined properly and set to correct permission
            <p>";
         }


   }

   
   if ($error) {
   
      print qq~ 
      <font size=3 face=verdana color=#000066>
      <strong>
      There may have been some errors during setup.  Here is the error
      listing:<p>
      </strong>
      <font size="2" color="#FF0000">
      <ul>
      $ERROR
      </ul>
      </font>
      <p>
      <strong>
      Please check and make sure that all files and directories have
      been created.  You can verify this by browsing your web site directory
      using your FTP program.  Once you've verified your settings,
      please run dcadmin.pl again.
      </strong>
      <br></font></font>~;
   }
   else {
   
      print qq~ 
      <font size=3 face=verdana color=#000066><strong>
      All initial folders and files have been created.  Now try running
      <a href="$adminurl">Admin Utility</a>...be sure to first register by
      clicking on "New User? Click here to register and create an account
      Link.
      <br></font></strong></font>~;
      
      open(F,">$password_file_dir/init.lock") or
         my_die ("Can't create $password_file_dir/init.lock", $!);
         close(F);
   
   }

   print "</body></html>";
   
   exit;

}

sub check_f {

   my($datafile,$r_variables) = @_;

      if ( open(FILE,">$datafile") ) {

         foreach (@{$r_variables}) {
            print FILE "$_\n";
         }
         close(FILE);
         chmod(0666,$datafile);
         return 1;

      }
      else {
         return 0;
      }

}

#======================================================================#
# check_d                                                            #
# checks a directory and creates it if it is empty                     #
#======================================================================#

sub check_d {

   my($folder) = shift;

   unless (mkdir($folder,0777)) {
      chmod(0777,$folder);
      return 1;
   }
   else {
      return 0;
   }
}


1;

