# html_reference.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function html_reference                                              #
# displays simple html reference                                       #
#======================================================================#

sub html_reference {

   my ($r_in,$r_setup) = @_;
   local $html_output;

   local $heading = $forum_title;
   local $sub_heading = 'HTML Reference Lookup Table';

   print_header();
   print_header_end();

   $html_output = qq~

      <table border="0" cellpadding="2" WIDTH="$table_width">

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      HTML tags can be used in your message simply by using [ and ]
      symbols in place of &lt; and &gt; symbols, respectively.
      </font>
      </th></tr>

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Special Tags
      </font>
      </th></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Code
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [code] Your Code [/code]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      HREF link with text display
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [link:URL|Text]<br>
      URL is without the "http://".<br>
      Example: [link:www.dcscripts.com|DCScripts]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [ and ]
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      &l; and &r;
      </FONT>
      </td></tr>

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Text Formatting
      </font>
      </th></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Bold
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [b]Text[/b]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Italic
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [i]Text[/i]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Underline
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [u]Text[/u]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Heading 1
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [h1]Text[/h1]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Heading 2
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [h2]Text[/h2]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Heading 3
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [h3]Text[/h3]
      </FONT>
      </td></tr>

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Font Tag
      </font>
      </th></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Font
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [font color="color" size="size" face="face"]Text[/font]
      </FONT>
      </td></tr>

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Links and Images
      </font>
      </th></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Hyperlink
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      No tags needed - just type the URL starting with http://
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Images
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      No tags needed - just type the URL starting with http://
      </FONT>
      </td></tr>

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Formatted List
      </font>
      </th></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Unordered Lists with &lt;li>
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [ul]<br>
      [li]<br>
      [li]<br>
      ...<br>
      [/ul]
      </FONT>
      </td></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Ordered Lists with &lt;ol>
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [ol]<br>
      [li]<br>
      [li]<br>
      ...<br>
      [/ol]
      </FONT>
      </td></tr>

      <tr><th bgcolor="$bg_color_0" colspan="2" align="left">
      <FONT SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Tables
      </font>
      </th></tr>

      <tr>
      <th bgcolor="$bg_color_3" align="left">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      Typical Use
      </FONT>
      </th>
      <td bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      [table border="number" cellspacing="number" cellpadding="number"]<br>
      [tr]<br>
      [td] Text in first row, first column[/td]<br>
      [td] Text in first row,  second column[/td]<br>
      [/tr]<br>
      [tr]<br>
      [td] Text in second row, first column[/td]<br>
      [td] Text in second row, second column[/td]<br>
      [/tr]<br>
      [/table]
      </FONT>
      </td></tr>

      <tr>
      <td bgcolor="$bg_color_3">
      &nbsp;
      </td>
      <td bgcolor="$bg_color_3" align="right">
      <A HREF = "javascript:window.close();"><FONT 
      SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">Close 
      this Window</font></A></td>
      </tr></TABLE>
      </FORM>~;   

      require "$cgilib/blank_template.pl";

      exit;


}

1;
