# help.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# help                                                                 #
# display help page                                                    #
#======================================================================#

sub help {

   my ($r_in,$r_setup) = @_;
   my $menu_button = create_button("help",$r_in,$r_setup);
   my $heading = $forum_title;
   my $sub_heading = 'Forum FAQs';
   my %questions, %answers;

   print_header();
   print_header_end();

   
   %questions = (
   1=>'What is the lobby?',
   2=>'What is a conference?',
   3=>'What is a forum?',
   4=>'What is a thread?',
   4.5=>'What is a subscription?',
   5=>'Why are there so many different types of forums?',
   6=>'When I post a message in one forum, it posts ok. 
      But in another forum, it won\'t post.  Why?',
   7=>'How do I register?',
   8=>'How can I keep track of new messages?',
   9=>'I want to use the private forums.  How do I do that?',
   10=>'How do I use HTML tags?',
   11=>'How do I post images?',
   12=>'How do I use HTML links?',
   13=>'How do I use those smiley icons?',
   14=>"Why do some forums show 
      <img src=\"$imgurl/locked_folder.gif\" border=\"0\"> icon when others show 
      <img src=\"$imgurl/folder.gif\"  border=\"0\">?",
   15=>"Why do some topics show 
      <img src=\"$imgurl/locked_file.gif\" border=\"0\"> icon when others show 
      <img src=\"$imgurl/file.gif\"  border=\"0\">?",
   16=>'Why do some topics have [view all] next to the subject?',
   17=>'What are those little icons next to the usernames in the messages?'
   );

   $answers{4.5} = qq~
   Subscription is a feature that lets register users
   periodically receive email notification of new messages.
   As a registed user, you can choose to select one or 
   more forums to subscribe to.
   To subscribe, select user menu icon from the Lobby or the
   Main Listing.  Or, you can just click on the subscribe link
   in the main listing. 
   ~;

   $answers{17} = qq~
   There can be upto three icons next to the usernames.
   First is the email icon <img src="$imgurl/email.gif">.
   You can email that person by clicking on this icon.  Second icons
   is the profile icon <img src="$imgurl/profile_small.gif">.  You
   can check out user's profile by clicking on this icon.  Lastly,
   clicking on the IP icon <img src="$imgurl/ip.gif"> will display
   the user's IP address IF this feature is enabled by the administrator.
   ~;

   $answers{14} = qq~
   Those forums with <img src="$imgurl/locked_folder.gif"> icons
   are moderated forums.  When you post your messages in these
   forums, they are not immediately posted.  Instead, your messages
   are stored in message queueing system until the administrator
   or the moderator approves them.
   ~;

   $answers{15} = qq~
   Those threads with <img src="$imgurl/locked_file.gif"> icons
   are locked threads, meaning that they are read-only.
   ~;

   $answers{16} = qq~
   When a topic contains too many replies, it can take a long time
   for your browser to download the entire file.  This can be annoying
   if you've already read most of the messages in that topic.
   To overcome this, a topic will automatically switch into
   the auto-sensing mode when then number of replies exceed certain
   number set by the administrator.  In this mode, you can view
   one message at a time, thereby eliminating the need to wait for
   th entire topic to download.
   ~;

   $answers{13} = qq~
   You can imbedd emotion icons by typing a combination of
   special characters.  For example, to imbedd <img src="$imgurl/happy.gif">
   you would type :-).  There are a dozen or so emotion icons which are
   listed in this
   <a href="javascript:makeRemote('$boardurl?az=emotion_icon_short_cuts')">
      emotion icon short cuts table</a>.
   ~;

   $answers{12} = qq~
   To use HTML links, just type in the URL.  For example,
   typing http://www.dcscripts.com would result in
   <a href="http://www.dcscripts.com">http://www.dcscripts.com</a>.
   ~;
   $answers{1} = qq~
   <b>Lobby</b> is the 'front door' of this discussion forum.
   By default, it is where all available forums are displayed.
   On the other hand, only the conferences maybe displayed 
   if the administrator has chosen that option.
   ~;

   $answers{2} = qq~
   A <b>conference</b> is a collection of forums
   that are related.  For example, you may have a conference titled
   <b>Programming</b> which contains 3 forums <b>Perl</b>, <b>Java</b>,
   and <b>Basic</b>.
   ~;

   $answers{3} = qq~
   A <b>forum</b> is where the discussions on related topics
   take place.  When you enter a forum, you will see the
   listing of topics.  Each topic contains the original message
   and, if applicable, replies to that message.
   ~;

   $answers{4} = qq~
   A <b>thread</b> is another word for a topic.  Each thread contains
   one original message and all replies to that message.  By default,
   it is fully-threaded in that there is a table of contents which
   shows you the flow of the discussion.  If the linear style option
   is chosen by the administrator, the thread will display the
   replies in the order of their response date.
   ~;

   $answers{5} = qq~
   There are three forum types: <b>public, protected,
   and private</b>:
   <ul>
   <li><b>Public Forum</b>:  Public forum is where everyone can participate
      without registration.  Everyone is allowed to read and post new threads.
   <li><b>Protected Forum</b>:  Protected forum is read-only for non-registered members.
      That is, if you want to post your own messages, you must first register.
   <li><b>Private Forum</b>:  Private forum is only accessible by registered members with
      one of the following user group: admin, moderator, and member.  In order to access the
      forums, however, the moderator of each forum must grant access on user to user basis.
   </ul>
   Additionally, each forum can be either open or 
   moderated (See FAQ #6).~;
   
   $answers{6} = qq~
   Each forum can be set to 'open' or 'moderated'.  If a
   forum is moderated, then all messages must be approved by
   the administrator (or the moderator) of that forum
   before they are posted.  The moderated forums are denoted by
   <img src="$imgurl/locked_folder.gif"> icons in the lobby.
   ~;
   
   $answers{7} = qq~
   To register, goto the <b>lobby</b> and click on the Login icon
   <img src="$imgurl/login.gif"> (or login text link)
   in the forum menu section below the heading.  This will
   bring up the login window.  If registration option is enabled
   by the administrator,
   there should be an HTML link for new user registration on this
   page.  Click on " Register to create an account" to bring up
   the registration form.  Complete and submit the form to
   create a new account.
   ~;
   
   $answers{8} = qq~
   In order to keep track of message read, you must be a
   registered user AND must be logged on.
   Once logged on, you use the Mark icon
   <img src="$imgurl/mark.gif">.  After finish reading messages in
   a forum, simply click on this icon and that's it.  The next time
   you visit this site, all forums and topics containing unread
   messages will show <img src="$imgurl/newmark.gif"> image next to them.
   ~;

   $answers{9} = qq~
   The administrator or the
   moderator of a private forum must grant you access.  
   Contact your administrator or the forum moderator and
   let them know you want access to a private forum.
   ~;

   $answers{10} = qq~
   If HTML is enabled in this forum, 
   then you can use [ and ] instead of < and > signs
   to post HTML tags.  For example, you'd use<br>
   [b]bold[/b] instead of &lt;b>bold&lt;/b>.
   To help you out, there is also an HTML reference
   available in the POST form.
   ~;

   $answers{11} = qq~
   To imbedd images in your message, just type the image URL.
   For example, if you type "$imgurl/folder.gif" you'd get
   <img src="$imgurl/folder.gif">.
   ~;

   my $html_output = qq~
  
   <TABLE CELLPADDING="2" BORDER="0" WIDTH="$table_width" ALIGN="CENTER">
   <TR><TD ALIGN="LEFT" BGCOLOR="$bg_color_0">
       <FONT COLOR="$font_color_0" Face="$font_face_0" size="$font_size_0">
       <b>DCForum FAQ</b>
       </FONT></TD></TR>~;
   
   if ($r_in->{'selected'}) {
      $html_output .= qq~
          <TR><TD ALIGN="LEFT" BGCOLOR="$bg_color_1">
          <FONT COLOR="$font_color_1" Face="$font_face_1" size="$font_size_1">
          <b>"$questions{$r_in->{'selected'}}"</b>
          <blockquote>
          $answers{$r_in->{'selected'}}
          </blockquote>
          </FONT></TD></TR>
       ~;
   }
   
      $html_output .= qq~
       <TR><TD ALIGN="LEFT" BGCOLOR="$bg_color_2">
       <FONT COLOR="$font_color_2" Face="$font_face_2" size="$font_size_2"><ol>
       ~;
   
   foreach (sort {$a <=> $b} keys %questions) {
      if ($_ == $r_in->{'selected'}) {
         $html_output .= qq~
         <li><font color="$font_color_special">$questions{$_}</font>
         ~;
      }
      else {
         $html_output .= qq~
         <li><a href="$boardurl?az=help&selected=$_">$questions{$_}</a>
         ~;
      }  
   }
  
   $html_output .= qq~
      </ol>
         </FONT></TD></TR></TABLE>
       ~;

   return ($heading, $sub_heading, $html_output,$menu_button);

  
}

1;