# email_to_friend.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#


#======================================================================#
# function email_to_friend                                             #
# display post form for the user                                       #
#======================================================================#

sub email_to_friend {

   require "$cgilib/dcforumlib2.pl";
   require "$cgilib/print_topic.pl";

   my ($r_in,$r_setup) = @_;
   my $heading = "Send a topic to a friend";
   my $sub_heading = "";
   my $html_output;

   my $menu_button = create_button('help',$r_in,$r_setup);

   print_header();
   print_header_end();

   my $r_thread = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");
   shift(@$r_thread);

   my $str = shift @$r_thread;
   chomp;

   my ($omm,$level,$subject,$name,$email,
         $ltime,$date,$body) = split(/$split_delim/,$str);

   $subject = dc_decode($subject);

   if ($r_in->{'command'} eq 'doit') {

      my $mail_output = $r_in->{'to_message'} . "\n\n";
      $mail_output .= print_topic($r_in,$r_setup);
      $mail_output =~ s/&gt;/>/g;

      send_mail($password_file_dir,$r_setup->{'auth_sendmail_path'},
            $r_setup->{'auth_admin_email_address'},
            $r_in->{'to_email'},
            "EMail from $r_in->{'from_name'} ($r_in->{'from_email'})",$mail_output );
                                                         
      $sub_heading = "Your message has been sent";
      

   }
   else {

      $sub_heading = "Complete the following form to send this topic to a friend";
      $html_output .= qq~
      <form method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="doit">
      <input type="hidden" name="om" value="$r_in->{'om'}">
      <input type="hidden" name="forum" value="$r_in->{'forum'}">
      <table border="0" width="$table_width">
      <tr><th align="right" bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Topic to send:
         </font></th><td bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         <a href="$boardurl?az=show_thread&om=$r_in->{'om'}&forum=$r_in->{'forum'}"><b>$subject</b></a> - Posted by $name
         </font></td></tr>
      <tr><th align="right" bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Your Name:
         </font>
         </th>
         <td bgcolor="$bg_color_3">
         <input type="text" name="from_name" size="40" value="$r_in->{'userdata'}->{'Username'}">
         </td></tr>
      <tr><th align="right" bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Your EMail:
         </font>
         </th>
         <td bgcolor="$bg_color_3">
         <input type="text" name="from_email" size="40"  value="$r_in->{'userdata'}->{'EMail'}">
         </td></tr>
      <tr><th align="right" bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Your Friend's Name:
         </font></th>
         <td bgcolor="$bg_color_3">
         <input type="text" name="to_name" size="40">
         </td></tr>
      <tr><th align="right" bgcolor="$bg_color_3">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Your Friend's EMail:
         </font>
         </th>
         <td bgcolor="$bg_color_3">
         <input type="text" name="to_email" size="40">
         </td></tr>
      <tr><th align="right" bgcolor="$bg_color_3" valign="top">
         <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         Message to your friend:
         </font>
         </th>
         <td bgcolor="$bg_color_3">
         <textarea name="to_message" rows="5" cols="40" wrap="virtual"></textarea>
         </td></tr>
      <tr><th align="right" bgcolor="$bg_color_3">
         &nbsp;
         </th>
         <td bgcolor="$bg_color_3">
         <input type="submit" value="Send it now!">
         </td></tr>
      </table>
      </form>
      ~;
   }

   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;