# email_users.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function email_users                                                 #
# sending emails to the users who wanted them                          #
#======================================================================#

sub email_users {

   my ($r_in,$r_setup) = @_;
   my $body = $r_in->{'body'};

   unless ($r_in->{'om'} and -e "$maindir/$forum/$email_dir/$r_in->{'om'}.$email_ext") {

      my @temp;
      push(@temp,"$r_in->{'subject'}\n");
      if ($r_in->{'email_notification'} and $r_in->{'userdata'}->{'EMail'}) {
         push(@temp,"$r_in->{'userdata'}->{'EMail'}\n");
      }

      writedata("$maindir/$forum/$email_dir/$r_in->{'om'}.$email_ext",\@temp);

      my $url;
      unless ($r_setup->{'forum_type'}->{$forum} eq 'Private') {
         $url = "$mainurl/$forum/$r_in->{'om'}.$ext";
      }
      else {
         $url = "$boardurl?az=show_thread&om=$r_in->{'om'}&forum=$forum";              
      }

      $body =~ s/<br>/\n/gi;
      $body =~ s/<p>/\n\n/gi;
      $body =~ s/<([^>]|\n)*>//g;

        my $mail_message .= qq~A new topic has been posted in your discussion forum ($forum).
------------------------------------------------------------------
"$r_in->{'subject'}"
Posted by $r_in->{'name'}
Message URL: $url

$body

~;

      my $r_mesg = readdata("$password_file_dir/$email_notification_file");
      my $email_notification_subject = shift(@{$r_mesg});

      if ($r_setup->{'email_to_admin'} eq 'on') {
         send_mail($password_file_dir, $r_setup->{'auth_sendmail_path'},
            $r_setup->{'auth_admin_email_address'},
            $r_setup->{'auth_admin_email_address'},
            $email_notification_subject,$mail_message );
      }

      # NEED TO REWORK THIS SECTION
      if ($r_setup->{'email_to_mod'} eq 'on') {
         my @moderator_emails = split(/\,/, $r_setup->{'forum_owner_email'}->{$forum} );
         foreach $moderator_email (@moderator_emails) {
            $moderator_email = remove_antispam($moderator_email);
            unless ($moderator_email eq $r_setup->{'auth_admin_email_address'}) {
               if (check_email($moderator_email)) {
                  send_mail($password_file_dir, $r_setup->{'auth_sendmail_path'},
                     $r_setup->{'auth_admin_email_address'},$moderator_email,
                     $email_notification_subject,$mail_message );
               }
            }
         }
      }


      
   }

   else {

      email_notification($r_in,$r_setup);

      if ($r_in->{'email_notification'}) {
         appenddata("$maindir/$forum/$email_dir/$r_in->{'om'}\.$email_ext",$r_in->{'userdata'}->{'EMail'});
      }

   }

}

#======================================================================#
# function email_notification                                          #
# sending emails to the users who wanted them                          #
#======================================================================#

sub email_notification {

   my ($r_in, $r_setup) = @_;
   my $r_data = {};

   my $poster_email = remove_antispam( $r_in->{'userdata'}->{'EMail'} );

   if (-e "$maindir/$forum/$email_dir/$r_in->{'om'}\.$email_ext") {
      $r_data = readdata("$maindir/$forum/$email_dir/$r_in->{'om'}\.$email_ext");
   }

   my $num = @{$r_data};

   my $thread_subject = shift(@{$r_data});
   chomp($thread_subject);

   # generate mail message
   my $url;
   unless ($r_setup->{'forum_type'}->{$forum} eq 'Private') {
      $url = "$mainurl/$forum/$r_in->{'om'}\.$ext";
   }
   else {
      $url = "$boardurl?az=show_thread&om=$r_in->{'om'}&forum=$forum";              
   }

   my $r_mesg = readdata("$password_file_dir/$email_notification_file");
   my $email_notification_subject = shift(@{$r_mesg});
   my $email_notification_message = join("",@{$r_mesg});
   $email_notification_message =~ s/\r//g;
   my $mail .= qq~Subject: "$thread_subject"
Posted by $r_in->{'name'}
Message URL: $url~;

   $email_notification_message =~ s/EMAIL_NOTIFICATION_MESSAGE/$mail/g;

   if ($num > 1) {

      my %seen = ();

      foreach (@{$r_data}) {
         chomp;
         $email = remove_antispam($_);
         push(@emails, $email) unless $seen{$email}++;
      }

      foreach (@emails) {
         unless ($_ eq $poster_email) {
            send_mail($password_file_dir, $r_setup->{'auth_sendmail_path'},
               $r_setup->{'auth_admin_email_address'},
               $_,$email_notification_subject,$email_notification_message );
         }
      }

   }

}

###
# function check_email
#
###

sub check_email {

   my ($email) = shift;
    if ($email =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/ || 
        ($email !~ /^.+\@localhost$/ && 
         $email !~ /^.+\@\[?(\w|[-.])+\.[a-zA-Z]{2,3}|[0-9]{1,3}\]?$/)) {
        return(0);
    }    
    else {
        return(1);
    }
}

1;