# edit.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function edit.pl                                                     #
# allows users to edit their message                                   #
#======================================================================#

sub edit {

   my ($r_in,$r_setup) = @_;

   require "$cgilib/dcforumlib2.pl";
   require "$cgilib/post.pl";

   my $menu_button = create_button('help',$r_in,$r_setup);

   $r_in->{'userdata'} = check_user($r_in,$r_setup);

   print_header();
   print_header_end();

   my $heading = "Edit Your Message";

   # Get the message
   my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = 
      get_record("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext",
         $r_in->{'omm'});

      $r_in->{'body'} = $body;
      $r_in->{'subject'} = $subject;
      $r_in->{'name'} = $name;
      $r_in->{'email'} = $email;
      $r_in->{'az'} = 'e_mesg';

   # Now check and see if the message belongs to the rightful owner
   unless ($r_in->{'userdata'}->{'Username'} eq $name) {
      $html_output .= qq~
         <p>&nbsp;
         <center>
         <FONT SIZE="4" FACE="$font_face_3" COLOR="$font_color_3">
         <b>ERROR: You can't edit this message.  You don't own it!</b>
         </FONT>
         </center>
         <p>&nbsp;
         <p>&nbsp;
         <p>&nbsp;
      ~;
      return ($heading, $sub_heading, $html_output,$menu_button);
   }
   elsif (old_post($ltime,$date) and $r_setup->{'edit_time_out'}) {
      $html_output .= qq~
         <p>&nbsp;
         <center>
         <FONT SIZE="3" FACE="$font_face_3" COLOR="$font_color_3">
         <b>ERROR: You can't edit this message.</b><br>
         </FONT>
         <FONT SIZE="2" FACE="$font_face_3" COLOR="$font_color_3">
         <b>You can only edit message within 
         $r_setup->{'edit_time_out'} minutes
         after your initial post.</b><br>
         </FONT>
         </center>
         <p>&nbsp;
         <p>&nbsp;
         <p>&nbsp;
      ~;
      return ($heading, $sub_heading, $html_output,$menu_button);    
   }

   my $sub_heading = "<B>Make your corrections and re-submit your message</B>";

   ($dum, $dum, $html_output,$menu_button) = post($r_in,$r_setup);

   return ($heading, $sub_heading, $html_output,$menu_button);

}

#======================================================================#
# function old_post                                                    #
# checks to see if edit previllage is expired                          #
#======================================================================#

sub old_post {

   my ($ltime,$ldate) = @_;

   my ($h1,$m1,$s1) = split(/\:/, $ltime);
   my ($mm1,$d1,$y1) = split(/\//, $ldate);

   $m1 = $m1 + $r_setup->{'edit_time_out'};

   my ($h2,$m2,$s2) = split(/\:/,$r_in->{'localtime'});
   my ($mm2,$d2,$y2) = split(/\//,$r_in->{'date'});

   my $t1 = compute_time($y1, $mm1, $d1, $h1, $m1, $s1);
   my $t2 = compute_time($y2, $mm2, $d2, $h2, $m2, $s2);

   if ($t2 > $t1) {
       return 1;
   }
   else {
       return 0;
   }


}

1;  
