# e_mesg.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function e_mesg                                                      #
# complets user changes to the message                                 #
#======================================================================#

sub e_mesg {

   my ($r_in,$r_setup) = @_; 

   require "$cgilib/dcforumlib2.pl";
#  require "$cgilib/rand_lock.pl";
   require "$cgilib/update_thread.pl";
   require "$cgilib/show_thread.pl";

   unless ($r_in->{'userdata'}->{'Username'}) {
      unless ($r_setup->{'forum_type'}->{$forum} eq "Public" 
               or $r_in->{'userdata'}->{'Username'}) {
         $r_in->{'userdata'} = check_user($r_in,$r_setup);
      }
      else {
         $r_in->{'email'} = add_antispam($r_in->{'email'});
      }
   }

   if ($r_in->{"preview"}){
      require "$cgilib/pview.pl";
      ($heading, $sub_heading, $html_output,$menu_button) = pview($r_in,$r_setup);
      return ($heading, $sub_heading, $html_output,$menu_button);
   }
   
#  if (check_rand_lock($r_in->{'rand1'})) {
      get_form_variables($r_in,$r_setup);
      edit_message($r_in,$r_setup);
      create_message($r_in,$r_setup);
#   }

   $r_in->{'omm'} = $orig_omm;
   if ($r_setup->{'forum_type'}->{ $forum } eq 'Private') {
      print_header();
      print_header_end();
      $r_in->{'indent'} = '';
      $heading = "Edited your message!";
      $sub_heading = "<b>Below is your new message</b><br>&nbsp;&nbsp;<br>";
      ($heading, $sub_heading, $html_output,$menu_button) = show_thread($r_in,$r_setup);
   }
   else {
      print "Location: $mainurl/$forum/$r_in->{'om'}.$ext#$r_in->{'omm'}\n\n";
      exit(0);
   }

   return ($heading, $sub_heading, $html_output,$menu_button);
}

#####
#
# subroutine edit_message
# routine to edit message
#
#####

sub edit_message {

   my ($r_in,$r_setup) = @_; 
   my (@newrow);
   my $r_rowdata = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");
   my $ltime = time_format($r_in->{'localtime'});
   my $ldate = date_format($r_in->{'date'});

   my $temp = "[font size=\"1\" color=\"#FF0000\"]LAST EDITED ON $ldate AT $ltime ($time_zone)[/font][p]";

   $r_in->{'body'} = $temp . $r_in->{'body'};

   # First get the number of messages and the next message number
   $temp = shift @{$r_rowdata};

   # Write to @newrow, which will overright @$r_rowdata
   push(@newrow,"$temp");

   # At this point, $$r_in->{'omm'} is the message
   # Right before current thread
   # Now, just go thru the data again and thread it correctly

   foreach (@{$r_rowdata}) {
      chomp;
      my @temp = split /$split_delim/;
      if ($r_in->{'omm'} eq $temp[0]) {
         $temp[$#temp] = "$r_in->{'body'}";
         my $temp_string = join("$join_delim",@temp);
         push(@newrow,"$temp_string\n");
      }
      else {
         push(@newrow,"$_\n");
      }
   }

   # Write to output file
   writedata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext",\@newrow);

}


1;