# dcforumlib2.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# function create_thread                                               #
# creates a thread datafile                                            #
#======================================================================#

sub create_thread {

   my ($r_in,$r_setup) = @_;
   my @text;
   my $text;
   # The first line contains next message number, user ratings, and
   # the number of time this topic has been read
   $text = join("$join_delim",0,'',0,0);
   push(@text,"$text\n");
   $text = join("$join_delim","0","0",$r_in->{'subject'},
      $r_in->{'name'},$r_in->{'email'},$r_in->{'localtime'},
      $r_in->{'date'},$r_in->{'body'});
   push(@text,"$text\n");
   writedata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext",\@text);

}

#======================================================================#
# function create_message                                              #
# creates the html thread file                                         #
#======================================================================#

sub create_message {

   my ($r_in,$r_setup) = @_;

   # Local variables
   my $dir, $extension, $http_header;
   my $table_of_contents;
   my $html_output;
   my $html_main_body;
   my $html_orig_body;
   my $r_row, $r_rowdata, $num_messages, $last_few_messages;
   my $heading, $sub_heading, $main_lobby, $html_forum_links;
   my $main_lobby;
   my $text_locked;

   if ($r_in->{'lock'}) {
      $text_locked = qq~<font color="$font_color_special"><b>
         Locked thread - Read only</b></font>~;
   }
   
   if ($r_in->{'archive'}) {
      $text_locked = qq~<font color="$font_color_special"><b>
         Archived thread - Read only</b></font>~;
   }

   # If forum typs is Private then set proper path and file extension
   if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
      $dir = $privatedir;
      $extension = $privateext;
   }
   else {
      $dir = $maindir;
      $extension = $ext;
   }

   # Read in from thread.txt database
   my $r_rowdata = readdata("$dir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");

   # First line contains next message number, user rating, and number of reads
   # don't needed for creating thread.html
   shift(@{$r_rowdata}); # shift our first line

   # Number of messages and last few messages
   my $num_messages = @{$r_rowdata} - 1;
   my $last_few_messages = $num_messages - int($num_messages/5);

   $table_of_contents = "<h3 align=center>No message in this topic</h3>" if ($num_messages < 1);

   # Ready to create thread.html 
   # $r_row is a reference to a hash whose values are
   # reference to an array whose elements are fields of
   # each message

   my $r_row = {};
   foreach (@{$r_rowdata}) {
      chomp;
      my @temp = split /$split_delim/;
      $r_row->{$temp[0]} = \@temp;
   }

   $main_lobby .= qq~<font size="$font_size_4" color="$font_color_4" face="$font_face_4">
   <a href="$boardurl"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Lobby</font></a> |
   <a href="$boardurl?az=list&forum=$forum"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Topics</font></a> |
   <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=previous_topic&archive=$r_in->{'archive'}"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Previous Topic</font></a> |
   <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=next_topic&archive=$r_in->{'archive'}"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Next Topic</font></a></font>~;

   my $prev_next .= qq~<font size="$font_size_4" color="$font_color_4" face="$font_face_4">
   <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=previous_topic&archive=$r_in->{'archive'}"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Previous Topic</font></a> |
   <a href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=next_topic&archive=$r_in->{'archive'}"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Next Topic</font></a></font>~;

   $html_output .= qq~
   <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="4">
   <TR><TD ALIGN="LEFT" VALIGN="BOTTOM" COLSPAN="2" bgcolor="$bg_color_4"><a 
   href="$boardurl?az=email_to_friend&om=$r_in->{'om'}&forum=$forum"><img
   src="$imgurl/email_to_friend.gif" align="bottom" border="0"><font 
   SIZE="1" FACE="$font_face_4" color="$font_color_4">Email this topic to a friend</font></a><br>
   <a href="$boardurl?az=printer_format&om=$r_in->{'om'}&forum=$forum"><img
   src="$imgurl/printer_friendly.gif" align="bottom" border="0"><font 
   SIZE="1" FACE="$font_face_4" 
   color="$font_color_4">Printer-friendly version of this topic</font></a></TD>
   <TD ALIGN="RIGHT" VALIGN="BOTTOM" COLSPAN="2" BGCOLOR="$bg_color_4">
   <font face="$font_face_4" color="$font_color_4" size="$font_size_4">
   <font color="$font_color_special"><b>$text_locked</b></font>&nbsp;
   <br>$prev_next&nbsp;</FONT></TD></TR>~;

   $r_in->{'colspan'} = 4;
   $html_output .= navigation_menu($r_in,$r_setup);

   # First, if fully threaded dicussion, then thread it.

   if ($r_setup->{'threaded_discussion'} eq 'on') {
      my $prev_level = 0;
      my $ul_count = 0;
      foreach (@{$r_rowdata}) {
         my ($omm,$level,$subject,$name,$email,
            $ltime,$date,$body) = split /$split_delim/;
         $r_in->{'omm'} = $omm;
         $r_in->{'level'} = $level;
         $r_in->{'subject'} = $subject;
         $r_in->{'name'} = $name;
         $r_in->{'email'} = $email;
         $r_in->{'ltime'} = $ltime;
         $r_in->{'date'} = $date;

         # backward compatibility code
         # Need to get rid of all the HTML codes
         $body = dcf99_dcf00($body);
         $r_in->{'body'} = text_to_html($body);
         $r_in->{'subject'} = dc_decode($r_in->{'subject'});
         my $trim_subject = trim_text($r_in->{'subject'},$subject_length_max);

         $ltime = time_format($ltime);
         $date = date_format($date);

         # Check to see if the user is a team member
         $name = check_team($name,$team);

         # See if it's original, level 1 reply, or others         
         if ($omm == 0) {
            $r_in->{'indent'} = "";
            $html_orig_body .= html_main_body($r_in,$r_setup);
            $sub_heading = "\"$r_in->{'subject'}\"";
            
         }
         elsif ($level == 1) {
            if ($r_setup->{'use_icons_toc'} eq 'on') {
               $table_of_contents .= qq~
               <img src="$imgurl/message.gif">
               <a href="#$r_in->{'omm'}">$trim_subject</a>,
               <b>$name</b>, <font size="1">$date, ($r_in->{'omm'})</font><br>
               ~;
            }
            else {
               if ($level > $prev_level) {
                  for ($j=0;$j<$level-$prev_level;$j++) {
                     $table_of_contents .= "<ul>\n";
                     $ul_count++;
                  }
               }
               elsif ($level < $prev_level) {
                  for ($j=0;$j<$prev_level-$level;$j++) {
                     $table_of_contents .= "</ul>\n";
                     $ul_count--;
                  }
               }

               $prev_level = $level;
               $table_of_contents .= qq~
               <li><a href="#$r_in->{'omm'}">$trim_subject</a>,
               <b>$name</b>, <font size="1">$ltime, $date, ($r_in->{'omm'})</font>
               ~;
            }

            $r_in->{'indent'} = "";
            $html_main_body .= html_main_body($r_in,$r_setup) . "<br>\n";
         }
         else {
            my $icon = "reply_message.gif";
            $icon = "last_file.gif" if ($omm > $last_few_messages);
            my $space = ($level-2)*$level_spacing + 1;
            $r_in->{'indent'} = 18*($level-1);
            if ($r_setup->{'use_icons_toc'} eq 'on') {
               $table_of_contents .= qq~
               <img src="$imgurl/blank.gif" width="$space" height="14"><img 
               src="$imgurl/$icon"> <a 
               href="\#$r_in->{'omm'}">$trim_subject</a>,
               <b>$name</b>, <font size="1">$date, ($r_in->{'omm'})</font><br>
               ~;
            }
            else {

               if ($level > $prev_level) {
                  for ($j=0;$j<$level-$prev_level;$j++) {
                     $table_of_contents .= "<ul>\n";
                     $ul_count++;
                  }
               }
               elsif ($level < $prev_level) {
                  for ($j=0;$j<$prev_level-$level;$j++) {
                     $table_of_contents .= "</ul>\n";
                     $ul_count--;
                  }
               }

               $prev_level = $level;
               $table_of_contents .= qq~
               <li><a href="#$r_in->{'omm'}">$trim_subject</a>,
               <b>$name</b>, <font size="1">$ltime, $date, ($r_in->{'omm'})</font>
               ~;
            }

            $html_main_body .= html_main_body($r_in,$r_setup) . "<br>\n";

         }

      }

      for ($j=0;$j<$ul_count;$j++) {
         $table_of_contents .= "</ul>\n";
      }

      $html_output .= qq~
      <TR BGCOLOR="$bg_color_0">
      <TD ALIGN="LEFT" COLSPAN="4">
      <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
      Original message</font></TD></TR></TABLE>
      <br>
      $html_orig_body
      <br>~;

      if ($num_messages > 0) {
         $html_output .= qq~
         <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="4">
         <TR BGCOLOR="$bg_color_0">
         <TD ALIGN="LEFT">
         <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
         <a name="TOP">&nbsp;</a>Table of contents</font></TD></TR></TABLE>
         <br><TABLE 
         BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="4">
         <TR><TD ALIGN="LEFT" COLSPAN="2">
         <font SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
         $table_of_contents
         </font></TD></TR></TABLE><p>
         <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="4">
         <TR><TD ALIGN="right" COLSPAN="2">
         $main_lobby
         </TD></TR></TABLE><TABLE BORDER="0" WIDTH="$table_width" 
         cellspacing="0" cellpadding="4">
         <TR BGCOLOR="$bg_color_0">
         <TD ALIGN="LEFT">
         <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
         Messages in this topic
         </font></TD></TR></TABLE>
         <br>
         ~;
      }
   }
   else {

      $html_output .= qq~
         <TR BGCOLOR="$bg_color_0">
         <TD ALIGN="LEFT" colspan="$r_in->{'colspan'}">
         <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
         Messages in this topic
         </font></TD></TR></TABLE>
         <br>~;

      foreach (sort {$a <=> $b} keys %{$r_row}) {
         my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = @{$r_row->{$_}};
         $r_in->{'omm'} = $omm;
         $r_in->{'level'} = $level;
         $r_in->{'subject'} = $subject;
         $r_in->{'name'} = $name;
         $r_in->{'email'} = $email;
         $r_in->{'ltime'} = $ltime;
         $r_in->{'date'} = $date;

         # backward compatibility code
         # Need to get rid of all the HTML codes
         $body = dcf99_dcf00($body);
         $r_in->{'body'} = text_to_html($body);
         $r_in->{'subject'} = dc_decode($r_in->{'subject'});

         if ($omm ==0) {
            $sub_heading = "\"$r_in->{'subject'}\"";
         }

         $html_main_body .= html_main_body($r_in,$r_setup);
         $html_main_body .= "<br>";

      }

   }

   $html_output .= qq~

   $html_main_body

   <TABLE BORDER="0" WIDTH="$table_width" cellspacing="0" cellpadding="3">
   <TR BGCOLOR="$bg_color_4"><TD ALIGN="LEFT">
   <br>
   <font size="$font_size_4" color="$font_color_4" face="$font_face_4">~;

   if ($r_in->{'lock'}) {
      $html_output .= qq~ 
      <a href="$adminurl?az=admin_board_manager&command=admin_unlock_threads&forum=$forum&selected=$r_in->{'om'}"><font 
      size="$font_size_4" color="$font_color_4" face="$font_face_4">Unlock</font></a> | ~;
   }
   elsif ($r_in->{'lock'} eq '' and $r_in->{'archive'} eq '') {
      $html_output .= qq~ 
      <a href="$adminurl?az=admin_board_manager&command=admin_lock_threads&forum=$forum&selected=$r_in->{'om'}"><font 
      size="$font_size_4" color="$font_color_4" face="$font_face_4">Lock</font></a> |~;
   }
   
   unless ($r_in->{'archive'}) {
      $html_output .= qq~ 
      <a href="$adminurl?az=admin_board_manager&command=admin_archive_threads&forum=$forum&selected=$r_in->{'om'}"><font 
      size="$font_size_4" color="$font_color_4" face="$font_face_4">Archive</font></a> | ~;
   }

   $html_output .= qq~ 
   <a href="$adminurl?az=admin_board_manager&command=admin_remove_threads&forum=$forum&selected=$r_in->{'om'}&archive=$r_in->{'archive'}"><font 
   size="$font_size_4" color="$font_color_4" face="$font_face_4">Remove</font></a> </font>
   <br>
   </TD><TD ALIGN="RIGHT">
   <br>
   $main_lobby
   </TD></TR>
   ~;

   # Topic rating system
   if ($r_setup->{'user_rating'} eq 'on') {
      $html_output .= qq~
      <TR BGCOLOR="$bg_color_4"><TD ALIGN="RIGHT" COLSPAN="2">
      <font SIZE="$font_size_4" FACE="$font_face_4" 
         color="$font_color_special">Rate this topic (1=skip it, 10=must read)?
         [ ~;

      for ($j=1;$j<11;$j++) {
         $html_output .= qq~
         <a href="$boardurl?az=user_rating&om=$r_in->{'om'}&forum=$forum&rating=$j&archive=$r_in->{'archive'}">
         <font SIZE="$font_size_4" FACE="$font_face_4" 
            color="$font_color_special">$j</font></a> |~;
      }

      chop($html_output);
      $html_output .= qq~        
            ] </font>               
            </TD></TR>~;
   }

   $html_output .= qq~
   </TABLE>~;
   
   $heading = $forum_title;
   my $title = $heading . " - " . $sub_heading;
   my $http_header = qq~
   <META HTTP-EQUIV="Expires" CONTENT="Tues, 04 Dec 1996 21:00:00 GMT">
   <META HTTP-EQUIV="pragma" content="no cache">~;

   unless ($r_in->{'html_forum_link'}) {
      $html_forum_links = forum_links($r_in,$r_setup);
   }

   my %namespace = (
      FORUMLINKS => $html_forum_links,
      MENU => $menu_button,
      HTTPHEADER => $http_header,
      TITLE => $title,
      HEADER => $heading,
      SUBHEADER => $sub_heading,
      HTMLOUTPUT => $html_output
   );

   my $html_file = return_output($templatefile,\%namespace);
   my @html_file;
   $html_file[0] = $html_file;
   writedata("$dir/$forum/$r_in->{'om'}\.$extension",\@html_file);
   return 0;

}

#======================================================================#
# function html_main_body                                              #
# creates the message for threads                                      #
#======================================================================#

sub html_main_body {

   my ($r_in,$r_setup) = @_;
   my $url_name;
   my $p_icons;
   my $html_main_body;
   my $icon_text = '';  
   my $omm = $r_in->{'omm'};
   my $text_omm = "$omm. " if ($omm);
   my $profile_name = '';
   my $profile_icon = '';
   my $this_time = time_format($r_in->{'ltime'});
   my $this_date = date_format($r_in->{'date'});

   if (-e "$profile_dir/$r_in->{'name'}.$profile_ext") {
      $profile_icon = qq~<a href=\"$boardurl?az=user&command=show_profile&user=$r_in->{'name'}\"><img 
      src="$imgurl/profile_small.gif" alt="Click to view user profile" border="0"></a>~;
   }

   $html_main_body .= qq~<TABLE BORDER="0" WIDTH="$table_width" 
   CELLPADDING="4" Cellspacing="0">~;

   if ($r_in->{'indent'} && $r_setup->{'message_indent'} eq 'on') {
       $html_main_body .= qq~
          <tr><td rowspan="5" width="$r_in->{'indent'}"><img 
          src="$imgurl/blank.gif" width="$r_in->{'indent'}" height="10"></td>
          </tr>~;
   }

   if ($r_in->{'userdata'}->{'EMail'}) {
      $p_icons .= qq~<a 
         href="$boardurl?az=email_user&userid=$r_in->{'name'}"><IMG SRC="$imgurl/email.gif" 
         border="0" alt="Click to EMail $name"></a>~;
   }
   elsif ($r_in->{'email'}) {
         $p_icons .= qq~<a 
            href="mailto:$r_in->{'email'}"><IMG SRC="$imgurl/email.gif" 
             border="0" alt="Click to email $name"></a>~;
   }
   
   if ($profile_icon) {
      $p_icons .= qq~$profile_icon~;
   }

   my $url_name = dc_encode($r_in->{'name'});

   $p_icons .= qq~<a 
      href="$boardurl?az=view_ip&forum=$forum&om=$r_in->{'om'}&omm=$r_in->{'omm'}&name=$url_name"><IMG SRC="$imgurl/ip.gif" 
      border="0" alt="Click to check IP address of the poster"></a>~;
   
   $html_main_body .= qq~
      <TR BGCOLOR="$bg_color_2"><TD align="Left" width="50%">
      <FONT SIZE="$font_size_2" FACE="$font_face_2" COLOR="$font_color_2">
      <a name="$omm"><b>$r_in->{'name'}</b></a> $p_icons</font></td>
      <TD align="right" valign="top" width="50%">
      <FONT SIZE="1" FACE="$font_face_2" COLOR="$font_color_2">
      $this_date,&nbsp;$this_time&nbsp;($time_zone)
         </font></td></tr>
      <TR BGCOLOR="$bg_color_2"><TD colspan="2" width="100%" ALIGN="LEFT">
         <FONT SIZE="$font_size_2" FACE="$font_face_2" COLOR="$font_color_2">
         $text_omm <b>"$r_in->{'subject'}"</b></FONT></TD></TR>
      <TR BGCOLOR="$bg_color_1"><td colspan="2" width="100%">
         <FONT SIZE="$font_size_1" FACE="$font_face_1" COLOR="$font_color_1">
         <blockquote>
         $r_in->{'body'}
         </blockquote></FONT></TD></TR>
      <TR BGCOLOR="$bg_color_2"><TD ALIGN="LEFT" valign="top" width="30%">
         <FONT SIZE="1" FACE="$font_face_2" COLOR="$font_color_2">&nbsp;
    ~;

   my @menu_stuff;
   my $temp;

   unless ($r_in->{'archive'} eq "yes"  or $r_in->{'lock'}) {
      if ($omm) {
         $temp =qq~ <a href="$adminurl?az=admin_board_manager&command=admin_remove_messages&forum=$forum&thread_select=$r_in->{'om'}&selected=$omm"><FONT 
            SIZE="1" FACE="$font_face_3" COLOR="$font_color_3">Remove</font></a> ~;
         push(@menu_stuff,$temp);
      }
      $temp = qq~
         <a href="$boardurl?az=alert&forum=$forum&om=$r_in->{'om'}&omm=$omm"><FONT 
         SIZE="1" FACE="$font_face_3" COLOR="$font_color_3">Alert</font></a> ~;
      push(@menu_stuff,$temp);
   }

   $temp = join("\|",@menu_stuff);
   
   $html_main_body .= qq~
      $temp</FONT></TD>
      <TD ALIGN="RIGHT" valign="top">
      <FONT SIZE="1" FACE="$font_face_3" COLOR="$font_color_3">~;
      
   @menu_stuff = ();

   if ($r_setup->{'edit_allowed'} eq "on" 
      and $r_in->{'archive'} eq '' and $r_in->{'lock'} eq '') {
        $temp = qq~ <a href="$boardurl?az=edit&forum=$forum&om=$r_in->{'om'}&omm=$omm"><FONT 
         SIZE="1" FACE="$font_face_3" COLOR="$font_color_3">Edit</FONT></a> ~;
      push(@menu_stuff,$temp);
   }

   unless ( $r_in->{'archive'} eq "yes"  or $r_in->{'lock'}) {
      $temp = qq~
         <a href="$boardurl?az=post&forum=$forum&om=$r_in->{'om'}&omm=$omm"><FONT 
         SIZE="1" FACE="$font_face_3" COLOR="$font_color_3">Reply</FONT></a> ~;
      push(@menu_stuff,$temp);
      $temp = qq~
         <a href="$boardurl?quote=not_empty&az=post&forum=$forum&om=$r_in->{'om'}&omm=$omm"><FONT 
         SIZE="1" FACE="$font_face_3" COLOR="$font_color_3">Reply With Quote</FONT></a> ~;
      push(@menu_stuff,$temp);
   }

   push(@menu_stuff," <a href=\"\#TOP\"><FONT 
      SIZE=\"1\" FACE=\"$font_face_3\" COLOR=\"$font_color_3\">Top</FONT></a> ");

   $temp = join("\|",@menu_stuff);
   $html_main_body .= qq~
   $temp</FONT></TD></TR></TABLE>~;       

   return $html_main_body;
}


#======================================================================#
# function get_record                                                  #
# reads in one record                                                  #
#======================================================================#

sub get_record {

   my ($r_rowdata,$omm) = @_;
   my ($level,$subject,$name,$email,$ltime,$date,$body);

   my $r_rowdata = readdata("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext");
   # First get the number of messages and the next message number

   my $temp = shift @{$r_rowdata};
   foreach (@{$r_rowdata}) {
      chomp;
      my @temp = split /$split_delim/;
      if ($omm eq $temp[0]) {
         ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = @temp;
         $body =~ s/&pip;/$split_delim/g;
         $subject =~ s/&pip;/$split_delim/g;
         last;
      }
   }

   return ($omm,$level,$subject,$name,$email,$ltime,$date,$body);
}

#======================================================================#
# function display_status                                              #
# STDERR - the general output function                                 #
#======================================================================#

sub display_status {

   my ($type,$r_in,$r_setup) = @_;
   my $dum,$temp;
   my $heading, $sub_heading,$html_output,$menu_button;

   $heading = $forum_title;
   
   print_header();
   print_header_end();

   #opps, posting error...let it be set
   $r_in->{'posting_error'} = 'on';
   if ($type eq "EMail") {
      require "$cgilib/post.pl";
      $heading = "ERROR: Incorrect EMail";
      $r_in->{'body'} =~ text_to_form($r_in->{'body'});
      $sub_heading = "In order for us to notify you via EMail, you must submit valid email address";
      ($dum, $dum, $html_output,$menu_button) = post($r_in,$r_setup);
   }
   elsif ($type eq "No Keywords") {
      $heading = "ERROR: $type";
      $sub_heading = "<b>You forgot to provide keyword(s) for your search.
              Please try again</b>";
      $html_output = "<center>\n";
      ($dum, $dum, $temp,$menu_button) = search_form($r_in,$r_setup);
      $html_output .= $temp;
      $html_output .= "</center>\n";
   }
   elsif ($type eq "No Match") {
      my $dum;
      $heading = "Search Result: No Match";
      $sub_heading = "<b>Your Keyword(s) 
            \"$r_in->{'keywords'}\" did not match. Please try again</b>";
      $html_output = "<center>\n";
      ($dum, $dum, $temp,$menu_button) = search_form($r_in,$r_setup);
      $html_output .= $temp;
      $html_output .= "</center>\n";
   }
   elsif ($type) {
      require "$cgilib/post.pl";
      $r_in->{'body'} =~ text_to_form($r_in->{'body'});
      $sub_heading = "ERROR: No $type<br>";
      $sub_heading .= "You forgot to fill in the \"$type\" field in your posting.";
      ($dum, $dum, $html_output,$menu_button) = post($r_in,$r_setup);
   }
   else {
      $heading = "General Error";
   }

   # create forum_links
   $html_forum_links = forum_links($r_in,$r_setup);

   my %namespace =  (
     FORUMLINKS => $html_forum_links,
     MENU => $menu_button,
     TITLE => $heading,
     HEADER => $heading,
     SUBHEADER => $sub_heading,
     HTMLOUTPUT => $html_output
   );

  display_output($templatefile,\%namespace);

  exit(0);

}

#======================================================================#
# function remove_badwords                                             #
# remove bad words in the badword list                                 #
#======================================================================#

sub remove_badwords {
    my ($r_in,$r_setup) = @_;
    my @words = split(/\,/, $r_setup->{'auth_bad_word_list'});
    foreach (@words) {
      unless ($_ eq ' ') {
        $r_in->{'subject'} =~ s/\b$_\b/#####/ig;
        $r_in->{'body'} =~ s/\b$_\b/#####/ig;
      }
    }
    return 0;

}

#======================================================================#
# function format_quote                                                #
# reads in original message and quotes it                              #
#======================================================================#

sub format_quote {

   my $quote = shift;

   my @reply_paragraphs = split(/\n/,$quote);
   $quote = "";

   foreach $para (@reply_paragraphs) {
      if ($para =~ />/) {
         my @lines = split(/\n/,$para);
         foreach (@lines) {
            chomp;
            s/\r//g;
            $quote .= ">$_";
         }
      }
      else {
         my @reply_body = split(/\s/,$para);
         my $j = 0;
         $quote .= ">";
        foreach (@reply_body) {
           $quote .= "$_ ";
           if ($j == 5) {
              $quote .= "\n>";
              $j = 0;
           }
           $j++;
        }
     }

     $quote .= "\n";
  }

  return $quote;

}

#======================================================================#
# function get_form_variable                                           #
# reads in one record                                                  #
#======================================================================#

sub get_form_variables {

   my ($r_in,$r_setup) = @_;
   print_header();

   remove_badwords($r_in,$r_setup);
   unless ($r_in->{'name'}) {
      display_status("Name",$r_in,$r_setup);
   }

   if ($r_in->{'subject'}) {
      $r_in->{'subject'} = dc_encode($r_in->{'subject'});
   }
   else {
      display_status("Subject",$r_in,$r_setup);
   }

   if ($r_in->{"email_notification"}) {
      unless ($session) {
         unless ( check_email($r_in->{'email'}) ) {
            display_status(EMail,$r_in,$r_setup);
         }
      }
   }  


   if ($r_in->{'body'}) {
      $r_in->{'orig_body'} = form_to_text($r_in->{'body'});
      $r_in->{'body'} = dc_encode($r_in->{'body'});
   }
   else {
      display_status("Message",$r_in,$r_setup);
   }

}

#======================================================================#
# function emotion_icons                                               #
# Looks for emotion shortcuts and replaces it with icons               #
#======================================================================#

sub emotion_icons {

   my $text = shift;
   $text =~ s/:-\(/<img src="$imgurl\/angry.gif">/g;
   $text =~ s/:-\)/<img src="$imgurl\/happy.gif">/g;
   $text =~ s/:-\(/<img src="$imgurl\/sad.gif">/g;
   $text =~ s/;-\)/<img src="$imgurl\/wink.gif">/g;
   $text =~ s/:\(/<img src="$imgurl\/angry.gif">/g;
   $text =~ s/:\o/<img src="$imgurl\/shocked.gif">/g;
   $text =~ s/:D/<img src="$imgurl\/bigsmile.gif">/g;
   $text =~ s/:\+/<img src="$imgurl\/flue.gif">/g;
   $text =~ s/\}\>/<img src="$imgurl\/devil.gif">/g;
   $text =~ s/:\'\(/<img src="$imgurl\/cry.gif">/g;
   $text =~ s/:P/<img src="$imgurl\/tongue.gif">/g;
   $text =~ s/:9/<img src="$imgurl\/yum.gif">/g;
   $text =~ s/:\*/<img src="$imgurl\/kiss.gif">/g;
   $text =~ s/:7/<img src="$imgurl\/loveit.gif">/g;

   return $text;
}


#======================================================================#
# function urllink                                                     #
# automatically links h refs                                           #
#======================================================================#
# MOD - 10.11.99
# If file extension ends in gif or jpg
# it uses <img src> instead

sub url_link {

   my $text = shift;
   my $urls = '(' . join ('|', qw{
                                 http
                                 ftp 
                                 mailto
                                 }
                           )
                     . ')';
   my $ltrs = '\w';
   my $gunk = '/#~:.?+=&%@!\-';
   my $punc = '/.:?\-';
   my $any = "${ltrs}${gunk}${punc}";
   $text =~ s{\b(${urls}:[$any]+?)(?=[$punc]*[^$any]|\Z)}
            {  my $temp = $1;
               if ($temp =~ /gif$|jpg$/i) {
                  $temp = "<img src=\"$temp\">";
               }
               else {
                  $temp = "<a href=\"$temp\" target=\"_blank\">$temp</a>";
               }
               $temp;
            }goei;

   return $text;

}

#===============================================================#
# function text_to_html                                         #
# translates database text to HTML tags                         #
#===============================================================#

sub text_to_html {
   my $text = shift;
   $text = dcf99_dcf00($text);
   $text = dc_decode($text);
   $text = form_to_text($text);
   # auto URL linking
   $text = url_link($text);
   # emotion icons
   $text = emotion_icons($text);
   # convert [] tags to <> tags
   $text = format_html($text);
   return $text;
}

#===============================================================#
# function format_html                                          #
# translates database text to HTML tags                         #
#===============================================================#

sub format_html {
   my $text = shift;
   $text =~ s/\&quot\;/"/g;
   $text =~ s/\[code\]/<font face="courier" size="3"><pre>/gi;
   $text =~ s/\[\/code\]/<\/pre><\/font>/gi;
   $text =~ s/\[link:(([^\]\|]|\n)*)\|(([^\]]|\n)*)\]/<a href="http:\/\/$1" target="_blank">$3<\/a>/gi;
   $text =~ s/\[(([^\]]|\n)*)\]/<$1>/gi;
   $text =~ s/&l;/\[/gi;
   $text =~ s/&r;/\]/gi;
   return $text;     
}

#===============================================================#
# function dcf99_dcf00                                          #
# translates dcf99 text to dcf00 format                         #
#===============================================================#

sub dcf99_dcf00 {
   my $text = shift;
   $text =~ s/<(br|p)>/\[$1\]/gi;
   $text =~ s/<img src="(.*)">/$1/gi;
   $text =~ s/<([^>]|\n)*>//g;
   return $text;
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           #===============================================================#

#======================================================================#
# check_user                                                           #
# Check and see if the user is logged on                               #
# If not, prompt the user for login information                        #
#======================================================================#
sub check_user {

   my ($r_in,$r_setup) = @_;
   my $r_local = {};

   my $session = get_cookie($cookie_name);
   if ($session and -e "$sessiondir/$session.session") {
      $r_local = get_userdata("$sessiondir/$session.session");
   }
   elsif ($session) {
      send_cookie($cookie_name,'','Thur, 31-Dec-98 12:00:00 GMT','/');
      $session = '';
   }

   # If no $session and forum_type if Private or Protected,
   # well, then you need to have them logon

   unless ($session) {
      unless ($r_setup->{'forum_type'}->{$forum} eq 'Public') {
         print_header();
         require "$cgilib/auth_login.pl";
         $r_local = auth_login($r_in,$r_setup);
      }
      else {
         if ($r_in->{'az'} =~ /^admin/) {
            print_header();
            require "$cgilib/auth_login.pl";
            $r_local = auth_login($r_in,$r_setup);
         }
      }
   }

   return $r_local;

}


1;