# dcforumlib.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#                                                                      #
#======================================================================#

#======================================================================#
# create_button                                                        #
# creates navigation menu button                                       #
#======================================================================#

sub create_button {

   my ($type,$r_in,$r_setup) = @_;
   my $menu_buttons;
   my $l_buttons;
   my @l_buttons;
   my $separator = '|';

   my $bgcolor = $bg_color_5;
   my $f_color = $font_color_5;
   my $f_face = $font_face_5;
   my $f_size = $font_size_5;

   my %b;

   if ($r_setup->{'use_icons'} eq "on") {

      $b{'back'} = "<a href=\"$ENV{'HTTP_REFERER'}\"><img
            src=\"$imgurl/goback.gif\" alt=\"Click here to goback to the previous page\" border=\"0\"></a><br>";
      $b{'lobby'} = "<a href=\"$boardurl?az=lobby\"><img
            src=\"$imgurl/lobby.gif\" alt=\"Click here to goto the Lobby\" border=\"0\"></a><br>";
      $b{'topics'} = " <a href=\"$boardurl?az=list&forum=$forum\"><img
            src=\"$imgurl/home.gif\" alt=\"Click here to goto the forum listing\" border=\"0\"></a><br>";
      $b{'login'} = "<a href=\"$boardurl?az=login\"><img 
            src=\"$imgurl/login.gif\" alt=\"Click here to Login\" border=\"0\"></a><br>";
      $b{'post'} = "<a href=\"$boardurl?az=post&forum=$forum\"><img 
            src=\"$imgurl/post.gif\" alt=\"Click here to post new thread\" border=\"0\"></a><br>";
      $b{'mark'} = "<a href=\"$boardurl?az=mark&forum=$forum\"><img 
            src=\"$imgurl/mark.gif\" alt=\"Click here to Mark This Forum as Read\" border=\"0\"></a><br>";
      $b{'help'} = "<a href=\"$boardurl?az=help\"><img 
            src=\"$imgurl/help.gif\" alt=\"Click here to see help\" border=\"0\"></a><br>";
      $b{'search'} = "<a href=\"$boardurl?az=search_form\"><img 
            src=\"$imgurl/search.gif\" alt=\"Click here to Search the Forum\" border=\"0\"></a><br>";
      $b{'admin'} = "<a href=\"$adminurl\"><img 
            src=\"$imgurl/admin.gif\" alt=\"Click here to goto administration page\" border=\"0\"></a><br>";
      $b{'user'} = "<a href=\"$boardurl?az=user\"><img 
            src=\"$imgurl/profile.gif\" alt=\"Click here to goto user utility\" border=\"0\"></a><br>";

      if ($r_in->{'userdata'}->{'Username'}) {
         $b{'login'} = "<a href=\"$boardurl?az=login\"><img 
               src=\"$imgurl/logout.gif\" alt=\"Click here to Logout\" border=\"0\"></a><br>";
      }
   }
   

   if ($r_in->{'userdata'}->{'Username'}) {
      $b{'login'} .= qq~ <a href="$boardurl?az=login"><font 
               size="$f_size" face="$f_face" color="$f_color">Logout</font></a> ~;
   }
   else {
      $b{'login'} .= qq~ <a href="$boardurl?az=login"><font 
               size="$f_size" face="$f_face" color="$f_color">Login</font></a> ~;
   }

   $b{'back'} .= qq~ <a href="$ENV{'HTTP_REFERER'}"><font 
               size="$f_size" face="$f_face" color="$f_color">Go back</font></a> ~;
   $b{'post'} .= qq~ <a href="$boardurl?az=post&forum=$forum"><font 
               size="$f_size" face="$f_face" color="$f_color">Post</font></a> ~;
   $b{'mark'} .= qq~ <a href="$boardurl?az=mark&forum=$forum&conf=$r_in->{'conf'}"><font 
               size="$f_size" face="$f_face" color="$f_color">Mark</font></a> ~;
   $b{'help'} .= qq~ <a href="$boardurl?az=help"><font 
               size="$f_size" face="$f_face" color="$f_color">Help</font></a> ~;
   $b{'search'} .= qq~ <a href="$boardurl?az=search_form"><font 
               size="$f_size" face="$f_face" color="$f_color">Search</font></a> ~;
   $b{'lobby'} .= qq~ <a href="$boardurl?az=lobby"><font 
               size="$f_size" face="$f_face" color="$f_color">Lobby</font></a> ~;
   $b{'topics'} .= qq~ <a href="$boardurl?az=list&forum=$forum"><font 
               size="$f_size" face="$f_face" color="$f_color">Topics</font></a> ~;
   $b{'admin'} .= qq~ <a href="$adminurl"><font 
               size="$f_size" face="$f_face" color="$f_color">Admin</font></a> ~;
   $b{'user'} .= qq~ <a href="$boardurl?az=user"><font 
               size="$f_size" face="$f_face" color="$f_color">User</font></a> ~;

   $b{'next'} = qq~ <a 
   href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=next_topic&archive=$r_in->{'archive'}"><font 
               size="$f_size" face="$f_face" color="$f_color">Next Topic</font></a> ~;
   $b{'previous'} = qq~ <a 
   href="$boardurl?forum=$forum&mark=$r_in->{'om'}&az=previous_topic&archive=$r_in->{'archive'}"><font 
               size="$f_size" face="$f_face" color="$f_color">Previous Topic</font></a> ~;

   if ($type eq 'list') {

      push(@l_buttons,$b{'login'},$b{'help'},$b{'search'},$b{'post'});
      if ($session) {
         push(@l_buttons,$b{'mark'},$b{'user'});
      }     

      if ($r_in->{'userdata'}->{'Group'} eq "admin" or 
         $r_in->{'userdata'}->{'Group'} eq "moderator") {
         push(@l_buttons,$b{'admin'});
      }

   }
   elsif ($type eq 'admin') {
         push(@l_buttons,$b{'login'},$b{'admin'});
   }
   elsif ($type eq 'user_menu') {

      push(@l_buttons,$b{'login'},$b{'help'},$b{'search'},$b{'lobby'});
      if ($session) {
         push(@l_buttons,$b{'user'});
      }
      
      if ($r_in->{'userdata'}->{'Group'} eq "admin" or 
         $r_in->{'userdata'}->{'Group'} eq "moderator") {
         push(@l_buttons,$b{'admin'});
      }

   }
   elsif ($type eq 'message') {
      push(@l_buttons,$b{'help'},$b{'search'});

      if ($r_setup->{'use_icons'} eq "on") {    
         $l_buttons = join("",@l_buttons);
      }
      else {
         $l_buttons = join("$separator",@l_buttons);
      }
      return ($l_buttons);

   }
   elsif ($type eq 'help') {
      push(@l_buttons,$b{'search'},$b{'back'},$b{'lobby'});
   }
   elsif ($type eq 'register') {
      push(@l_buttons,$b{'back'},$b{'lobby'});
   }
   elsif ($type eq 'search') {
      push(@l_buttons,$b{'help'},$b{'back'},$b{'lobby'});
   }
   elsif ($type eq 'new_message') {

      my $user;

      push(@l_buttons,$b{'login'},$b{'help'},$b{'search'});

      if ($r_in->{'userdata'}->{'Username'}) {
         $user = $r_in->{'userdata'}->{'Username'};
      }

      $b{'mark'} = '';

      if ($r_setup->{'use_icons'} eq "on") {
         $b{'mark'} = "<a href=\"$boardurl?az=mark&forum=all\"><img 
              src=\"$imgurl/mark.gif\" alt=\"Click here to Mark 
                 This Forum as Read\" border=\"0\"></a><br>";
      }

      $b{'mark'} .= qq~ <a href=\"$boardurl?az=mark&forum=all\"><font 
               size="$f_size" face="$f_face" color="$f_color">Mark All</font></a> ~;

      if ($user) {
         push(@l_buttons, $b{'mark'});
      }

      push(@l_buttons, $b{'back'});

      if ($r_in->{'userdata'}->{'Group'} eq "admin" or 
         $r_in->{'userdata'}->{'Group'} eq "moderator") {
         push(@l_buttons, $b{'admin'});
      }

   }
   elsif ($type eq 'announcement') {

      push(@l_buttons,$b{'help'},$b{'search'},$b{'back'},$b{'lobby'});

  }
   elsif ($type eq 'lobby') {

      my $user;

      push(@l_buttons,$b{'login'},$b{'help'},$b{'search'});

      if ($session) {
         $user = $r_in->{'userdata'}->{'Username'};
      }

      if ($user) {
         push(@l_buttons, $b{'user'});
      }

      if ($r_in->{'userdata'}->{'Group'} eq "admin" or 
         $r_in->{'userdata'}->{'Group'} eq "moderator") {
         push(@l_buttons, $b{'admin'});
      }

  }

   if ($r_setup->{'use_icons'} eq "on") {

      $menu_buttons = qq~
         <TABLE BORDER="0" cellspacing="0" cellpadding="0">
         <TR>~;
      foreach ( (@l_buttons,@r_buttons) ) {
         $menu_buttons .= qq~
         <td align="center" width="50" BGCOLOR="$bgcolor">
             $_
         </td>~;
      }
      
      $menu_buttons .= qq~
         </TR></TABLE>
      ~;

   }
   else {

      $l_buttons = join("$separator",@l_buttons);
      $menu_buttons = qq~  
         <TABLE BORDER="0" cellspacing="0" cellpadding="4" width="100%">
         <TR><TD ALIGN="center" BGCOLOR="$bgcolor"><font 
         size="$f_size" face="$f_face" color="$f_color">
            $l_buttons</font></TD>
         </TR></TABLE>
      ~;
   }

  $menu_buttons;
}

#======================================================================#
# get_table_heading                                                    #
# Generates table heading for the lobby and mian listing               #
#======================================================================#

sub get_table_heading {

   my $flag = shift;
   my $table_heading;
   
   if ($flag) {
      $table_heading .= qq~
      <TR BGCOLOR="$bg_color_0">
         <TD ALIGN="LEFT" COLSPAN="2">
            <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Discussion Topic</font></TD>
         <TD ALIGN="LEFT" COLSPAN="3">
            <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Discussion&nbsp;Information</font></TD></TR>~;
   }
   else {
      $table_heading .= qq~
      <TR BGCOLOR="$bg_color_0">
         <TD ALIGN="CENTER" COLSPAN="2"><a 
            href="$boardurl?az=set_sort_index&field=$subject_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Discussion Topic</font></a></TD>
         <TD ALIGN="CENTER"><a 
            href="$boardurl?az=set_sort_index&field=$author_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Author</font></a></TD>
         <TD ALIGN="CENTER" WIDTH="150"><a 
            href="$boardurl?az=set_sort_index&field=$date_index"><font 
            <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
               Date/Time</font></a></TD>~;

      $table_heading .= qq~
         <TD ALIGN="CENTER"><a 
            href="$boardurl?az=set_sort_index&field=$replies_index"><font 
            <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
               Replies</font></a></TD>~;

      if ($r_setup->{'read_count'} eq 'on') {
         $table_heading .= qq~
         <TD ALIGN="CENTER"><a 
            href="$boardurl?az=set_sort_index&field=$view_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
               Views</font></a></TD>~;
      }


      if ($r_setup->{'user_rating'} eq 'on') {
         $table_heading .= qq~
         <TD ALIGN="CENTER"><a 
            href="$boardurl?az=set_sort_index&field=$rating_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
               Rating</font></a></TD>~;
      }

      $table_heading .= "</TR>\n";

   }

   return $table_heading;

}

#======================================================================#
# get_setup_variables                                                  #
# Read in forum setup variables and assign to output hash              #
#======================================================================#

sub get_setup_variables {
  my $datafile = shift;
  my $r_local = {};
  my $r_rows = readdata("$datafile");   
  foreach (@$r_rows) {
    chomp($_);
    ($key,$value) = split(/$split_delim/,$_);
    $r_local->{$key} = $value;
  }
  return $r_local;
}

#======================================================================#
# forum_links                                                          #
# Generats HTML text for the forum links drop down menu                #
#======================================================================#

sub forum_links {

   my ($r_in,$r_setup) = @_;

   my $r_conf = readdata("$password_file_dir/$conf_file");

   foreach (@{$r_setup->{'forums'}}) {
      if ($r_setup->{'forum_status'}->{$_} eq "on" && 
         check_forum_access($r_in,$r_setup,$_) ) {
         $r_conf_forums->{$r_setup->{'forum_conf'}->{$_}} = undef;
         $r_conf_count->{$r_setup->{'forum_conf'}->{$_}} = undef;
      }
   }

   foreach (@{$r_setup->{'forums'}}) {
      if ($r_setup->{'forum_status'}->{$_} eq "on" && 
         check_forum_access($r_in,$r_setup,$_) ) {
         push( @{ $r_conf_forums->{$r_setup->{'forum_conf'}->{$_}} } , $_);
         $r_conf_count->{$r_setup->{'forum_conf'}->{$_}}++;
      }
   }

   # Some javascript stuff for drop and jump effect

   my $html_forum_links .= qq~
<script language="javascript">
function MakeArray() {
   this.length = MakeArray.arguments.length
   for (var i = 0; i < this.length; i++)
   this[i+1] = MakeArray.arguments[i]
}

var url = new MakeArray("","$boardurl",\n~;

   foreach (@{$r_conf}) {
      chomp;
      my ($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;
      if ($r_conf_count->{$conf_id}) {
         $html_forum_links .= "\"$boardurl?conf=$conf_id\",\n";
         foreach (@{ $r_conf_forums->{$conf_id} }) {
               $html_forum_links .= "\"$boardurl?az=list&forum=$_\",\n";
         }
      }
   }

   chomp($html_forum_links);
   chop($html_forum_links);

   $html_forum_links .= qq~
   )
</script>


<TABLE BORDER="0" WIDTH="$table_width" CELLPADDING="3" cellspacing="1">
    <TR BGCOLOR="$bg_color_0">
      <TD ALIGN="RIGHT" VALIGN="TOP">
         <FORM ACTION="$boardurl" METHOD="POST">
         <input type="hidden" name="az" value="list">
         <FONT SIZE="1" COLOR="$font_color_0" FACE="$font_face_0">
         <select name="forum" onChange="jumpPage(this.form)">
         <option value="">Select another forum
         <option value="LOBBY">Lobby
         ~;

   foreach (@{$r_conf}) {
      chomp;
      my ($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;
      if ($r_conf_count->{$conf_id} and $r_setup->{'conf_status'}->{$conf_id} eq 'on') {
         $html_forum_links .= "<option value=\"$boardurl\">$conf_name (Conference)";
         foreach (@{ $r_conf_forums->{$conf_id} }) {
            $html_forum_links .= qq~
            <option value="$_">&nbsp;&nbsp;\|--$r_setup->{'forum_name'}->{$_} ($r_setup->{'forum_type'}->{$_})
            ~;
         }
      }
   }

   $html_forum_links .= qq~
      </select>
      <input type="submit" value="GO!"></form>
      </TD>
    </TR>
  </TABLE>
    ~;
      
   $html_forum_links;
}

#======================================================================#
# get_user_mark                                                        #
# Gets user time mark data from $logdir/username.log file              #
#======================================================================#

sub get_user_mark {
   my ($r_in, $r_setup) = @_;
   my $r_user_mark = {};
   if ($r_in->{'userdata'}->{'Username'}) {
      my $user_file = "$logdir/$r_in->{'userdata'}->{'Username'}.log";
      if (-e $user_file) {
         my $r_rows = readdata($user_file);
         foreach (@{$r_rows}) {
            chomp;
            my ($forum_name,$lastread) = split /=/;
            $r_user_mark->{$forum_name} = $lastread;
         }#End of foreach
         return $r_user_mark;
      }
      return 0;
   }#End of if ($username)...
   else {
      return 0;
   }

}

#======================================================================#
# access_error                                                         #
# Generates error reporting for various access_error conditions        #
#======================================================================#

sub access_error {

   my ($error,$r_in,$r_setup) = @_;
   my ($heading,$sub_heading,$html_output);
   
   if ($error eq 'forum off') {
      $heading = "ERROR ACCESSING FORUM";
      $sub_heading = qq~
         <p><b>"$r_setup->{'forum_name'}->{$forum}"
         forum is currently off-line<br>
         Please contact your webmaster for more information</b><p>
      ~;
      $html_output = "";
   }
   elsif ($error eq 'forum private') {
      $heading = "ERROR ACCESSING PRIVATE FORUM!";
      $sub_heading .= qq~
      <p><font size="4"><b>"$r_setup->{'forum_name'}->{$forum}" is a Private Forum<br>
      You do not have access rights to this forum.
      If you'd like to participate, please contact the forum administrator.</b>
      <p>Thank you!</font><p>~;
      $html_output = "";

   }
   elsif ($error eq 'remote posting') {

       $heading = "DCForum User Manager";
       $sub_heading = "ERROR: User Management Disabled";
       $html_output .= qq~
       <h4 align="center">
       The webmaster of this site has disabled User Management Console.
       To change your password or profile, please email the webmaster</h4>
       ~;

   }
   
   return ($heading,$sub_heading,$html_output);
}

#======================================================================#
# check_forum_access                                                   #
# Checks to see if the user has access to the forum                    #
#======================================================================#

sub check_forum_access {

   my ($r_in,$r_setup,$forum) = @_; 
   my $access = "1";
   if ($r_setup->{'forum_type'}->{$forum} eq 'Private') {
      if ($r_setup->{'hide_private'} ne "on" && $r_in->{'az'} eq 'lobby') {
         $access = 1;
      }
      else {
         unless ($r_in->{'userdata'}->{'Group'} eq "admin" or
            $r_in->{'userdata'}->{'Username'} eq $r_setup->{'forum_owner'}->{$forum} or
               $r_in->{'userdata'}->{'Forums'} =~ /$forum/) {
            $access = "0";
         }
      }
   }

   return $access;

}

#======================================================================#
# initialize                                                           #
# Read in forum setup parameters                                       #
# Also reads in forum and conf information                             #
#======================================================================#

sub initialize {

   my $r_setup = {};
   $r_setup = get_setup_variables("$password_file_dir/$board_setup_file");
   get_conf_info("$password_file_dir/$conf_file",$r_setup);
   get_forum_info("$password_file_dir/$forum_file",$r_setup);
   return $r_setup;
}

#======================================================================#
# get_conf_info                                                        #
# Gets conference information from conf_info.txt and assigns it to     #
# $r_setup->{}-{confs} hash tree                                       #
#======================================================================#

sub get_conf_info {

   my($conf_file,$r_setup) = @_;
   my $r_lines = readdata($conf_file);
   foreach (@$r_lines) {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
      chomp;
      my @temp = split /$split_delim/;
      push(@{$r_setup->{'conf'}},$temp[0]);
      $r_setup->{'conf_name'}->{$temp[0]} = $temp[1];
      $r_setup->{'conf_desc'}->{$temp[0]} = $temp[2];
      $r_setup->{'conf_status'}->{$temp[0]} = $temp[3];
   }
}

#======================================================================#
# save_conf_info                                                       #
# Save conference info to conf_info.txt file                           #
#======================================================================#

sub save_conf_info {

   my ($conf_file,$r_setup) = @_;
   my @new_row;

   foreach (@{$r_setup->{'conf'}}) {
      my $temp = join("$join_delim",
      $_,
      $r_setup->{'conf_name'}->{$_},
      $r_setup->{'conf_desc'}->{$_},
      $r_setup->{'conf_status'}->{$_} );
      push(@new_row,"$temp\n");
   }

   writedata($conf_file,\@new_row);

}


#======================================================================#
# get_forum_info                                                       #
# Gets forum information from forum_info.txt and assigns to            #
# $r_setup->{}-{forum} hash tree                                       #
#======================================================================#

sub get_forum_info {

   my($forum_file,$r_setup) = @_;
   my $r_lines = readdata($forum_file);
   foreach (@{$r_lines}) {
      chomp;
      my @temp = split /$split_delim/;
      push(@{$r_setup->{'forums'}},$temp[0]);
      $r_setup->{'forum_conf'}->{$temp[0]} = $temp[1];
      $r_setup->{'forum_name'}->{$temp[0]} = $temp[2];
      $r_setup->{'forum_desc'}->{$temp[0]} = $temp[3];
      $r_setup->{'forum_owner'}->{$temp[0]} = $temp[4];
      $r_setup->{'forum_owner_email'}->{$temp[0]} = $temp[5];
      $r_setup->{'forum_type'}->{$temp[0]} = $temp[6];
      $r_setup->{'forum_status'}->{$temp[0]} = $temp[7];
      $r_setup->{'forum_last'}->{$temp[0]} = $temp[8];
      $r_setup->{'forum_queue'}->{$temp[0]} = $temp[9];
      $r_setup->{'forum_threads'}->{$temp[0]} = $temp[10];
      $r_setup->{'forum_posts'}->{$temp[0]} = $temp[11];
      $r_setup->{'forum_archive'}->{$temp[0]} = $temp[12];
   }
}  

#======================================================================#
# save_forum_info                                                      #
# Save the forum information to forum_info.txt                         #
#======================================================================#

sub save_forum_info {

   my ($forum_file,$r_setup) = @_;
   my @new_row;

   foreach (@{$r_setup->{'forums'}}) {
         my $temp = join("$join_delim",
         $_,
         $r_setup->{'forum_conf'}->{$_},
         $r_setup->{'forum_name'}->{$_},
         $r_setup->{'forum_desc'}->{$_},
         $r_setup->{'forum_owner'}->{$_},
         $r_setup->{'forum_owner_email'}->{$_},
         $r_setup->{'forum_type'}->{$_},
         $r_setup->{'forum_status'}->{$_},
         $r_setup->{'forum_last'}->{$_},
         $r_setup->{'forum_queue'}->{$_},
         $r_setup->{'forum_threads'}->{$_},
         $r_setup->{'forum_posts'}->{$_},
         $r_setup->{'forum_archive'}->{$_} );
      push(@new_row,"$temp\n");
   }

   writedata($forum_file,\@new_row);

}

#======================================================================#
# get_team_members                                                     #
# Gets list of team members                                            #
#======================================================================#

sub get_team_members {

   my ($team_file) = shift;
   my $r_team = [];
   my $team;
   if (-e "$team_file") {
      $r_team = readdata("$team_file");
   }
   $team = join(" ",@{$r_team});
   return $team;
}

#======================================================================#
# get_session                                                          #
# If session cookie exists, then it returns a hash reference           #
# to the user data.                                                    #
#======================================================================#

sub get_session {

   my $r_temp = {};
   $session = get_cookie($cookie_name);
   if ($session) {
      if (-e "$sessiondir/$session.session") {
         $r_temp = get_userdata("$sessiondir/$session.session");
      }
      else {
         send_cookie($cookie_name,'','Thur, 31-Dec-98 12:00:00 GMT','');
         $session = '';
      }
   }

   return $r_temp;
}

#======================================================================#
# check_new                                                            #
# Checks to see if the input messages is a new message                 #
# $ltime & $date is the message date.  User date is in $user_mark      #
#======================================================================#

sub check_new {

    my ($ltime,$date,$user_mark) = @_;
    my ($hh,$minute) = split(/\:/, $ltime);
    my $second = 0;
    my ($mmonth,$dd,$yy) = split(/\//, $date);
    my $last_mesg = compute_time($yy, $mmonth, $dd, $hh, $minute, $second);
    if ($last_mesg > $user_mark) {
       return 1;
    }
    else {
       return 0;
    }

}

#======================================================================#
# check_team                                                           #
# Compares the input string $name to the list of team members          #
# in $team string.  If a memeber, it appends $team_name -              #
# which is a global variable defined in dcforum.setup                  #
#======================================================================#

sub check_team {

   my $name = shift;
   my $team = shift;

   my $temp_name = "\Q$name";
   if ($team =~ /\b$temp_name\b/) {
      $name .= $team_name;
   }
   return $name;
}

#======================================================================#
# navigation_menu                                                      #
# Depending on the input action az, this function                      #
# generates the navigation menu                                        #
#======================================================================#

sub navigation_menu {

   my ($r_in,$r_setup) = @_;
   my $output;

   my $dir = qq~<img src="$imgurl/dir.gif">~;

   if ($r_in->{'az'} eq 'list' or
         $r_in->{'az'} eq 'caption_list' or
         $r_in->{'az'} eq 'fully_threaded_list') {

      $output .= qq~
      <TR><TH COLSPAN="$r_in->{'colspan'}" ALIGN="LEFT" VALIGN="BOTTOM" BGCOLOR="$bg_color_2">
         <a href="$homeurl"><font 
            size="$font_size_2" face="$font_face_2" color="$font_color_2">Home</font></a>
            $dir <a href="$boardurl"><font face="$font_face_2"
         color="$font_color_2" size="$font_size_2">Conferences</font></a>~;

      if ($r_setup->{'conf_listing'} eq 'on') {
         $output .= qq~
         $dir <a href="$boardurl?conf=$r_setup->{'forum_conf'}->{$forum}"><font face="$font_face_2"
       color="$font_color_2" size="$font_size_2">$r_setup->{
            'conf_name'}->{ $r_setup->{'forum_conf'}->{$forum} }</font></a> ~;
      }
      
      $output .= qq~
         $dir <font face="$font_face_2"
         color="$font_color_2" size="$font_size_2">$r_setup->{'forum_name'}->{$forum}
          ($r_setup->{'forum_type'}->{$forum})</FONT>
         </TH></TR>~;
   }
   elsif ($r_in->{'az'} eq 'lobby') {

      if ($r_in->{'conf'} ne '') {
         $output .= qq~
            <TR><TH COLSPAN="$r_in->{'colspan'}"
            ALIGN="LEFT" VALIGN="BOTTOM" BGCOLOR="$bg_color_2">
            <a href="$homeurl"><font 
            size="$font_size_2" face="$font_face_2" color="$font_color_2">Home</font></a>
            $dir <a href="$boardurl"><font 
            face="$font_face_2" color="$font_color_2" size="$font_size_2">
            Conferences</font></a><font 
            face="$font_face_2" color="$font_color_2" size="$font_size_2"> $dir $r_setup->{'conf_name'}->{ $r_in->{'conf'} }</FONT>
            </TH></TR>~;
      }
      else {

         $output .= qq~
            <TR><TH COLSPAN="$r_in->{'colspan'}"
               ALIGN="LEFT" VALIGN="BOTTOM" BGCOLOR="$bg_color_2">
            <a href="$homeurl"><font 
            size="$font_size_2" face="$font_face_2" color="$font_color_2">Home</font></a>
            $dir <font 
            size="$font_size_2" face="$font_face_2" color="$font_color_2">Conferences</font>
            </TH></TR>~;   

      }
   }
   else {

      $output .= qq~
      <TR><TH COLSPAN="$r_in->{'colspan'}" ALIGN="LEFT" VALIGN="BOTTOM" BGCOLOR="$bg_color_2">
      <a href="$homeurl"><font 
            size="$font_size_2" face="$font_face_2" color="$font_color_2">Home</font></a>
            $dir <a href="$boardurl"><font 
         face="$font_face_2" color="$font_color_2" size="$font_size_2">Conferences</font></a>
         $dir ~;
      if ($r_setup->{'conf_listing'} eq 'on') {
         $output .= qq~
         <a href="$boardurl?conf=$r_setup->{'forum_conf'}->{$forum}"><font 
         face="$font_face_2" color="$font_color_2" size="$font_size_2">$r_setup->{
            'conf_name'}->{ $r_setup->{'forum_conf'}->{$forum} }</font></a> $dir ~;
      }

      $output .= qq~
      <a href="$boardurl?az=list&forum=$forum&archive=$r_in->{'archive'}"><font 
         face="$font_face_2" color="$font_color_2" size="$font_size_2">$r_setup->{'forum_name'}->{$forum}</FONT></a> <font 
         face="$font_face_2" color="$font_color_2" size="$font_size_2">($r_setup->{'forum_type'}->{$forum})</font>~;
      
      $output .= qq~
         </TH></TR>~;   
   }
   
   return $output;
}

#======================================================================#
# trim_text                                                            #
# takes input $text string and chops it off                            #
# the output is the first $text_length of $text                        #
#======================================================================#

sub trim_text {
   my ($text,$text_length) = @_;
   if (length($text) > $text_length) {
      $text = substr($text,0,$text_length);
      $text .= "...";
   }
   return $text;
}

#======================================================================#
# write_to_log                                                         #
# write user activity to the log file                                  #
#======================================================================#

sub write_to_log {
   my ($user,$action,$r_in) = @_;
   my $string;
   $string = join("$join_delim",$user,
      $action,$r_in->{'date'},$r_in->{'localtime'},$ENV{'REMOTE_ADDR'});
   appenddata("$password_file_dir/$logfile",$string);
}


#======================================================================#
# display_output                                                       #
# merge template and script data and print                             #
#======================================================================#

sub display_output {

   my ($templatefile,$r_namespace) = @_;
   my ($template);

   $| = 1;

  # Open template and read in
  
  open(TEMPLATE,"$templatefile") or 
  my_die ("Error in dcforumlib::display_output - Can't open $template_file", $!);
  {
    local($/) = undef;
    $template = <TEMPLATE>;
  }

  close(TEMPLATE);
  
  $template =~ s/\$([A-Z]+)/$r_namespace->{$1}/g;

  print $template;

}

#======================================================================#
# return_output                                                        #
# merge template and data and return to the function                   #
#======================================================================#

sub return_output {

   my ($templatefile,$r_namespace) = @_;
   my ($template);

   # Open template and read in
  
   open(TEMPLATE,"$templatefile") or 
      my_die ("Error in dcforumlib::display_output - Can't open $template_file", $!);
   {
      local($/) = undef;
      $template = <TEMPLATE>;
   }
   close(TEMPLATE);
  
   $template =~ s/\$([A-Z]+)/$r_namespace->{$1}/g;
   return $template;

}

#======================================================================#
# check_datafile                                                       #
# checks to see if data file exists                                    #
#======================================================================#

sub check_datafile {

   my($datafile,$r_variables) = @_;

   unless (-e $datafile) {
      open(FILE,">$datafile") or
         my_die("Error in subroutine check_datafile in dclib.pl: Can't open $datafile",$!);
      foreach (@{$r_variables}) {
         print FILE "$_\n";
      }
      close(FILE);
      chmod(0666,$datafile);
   }
}

#======================================================================#
# check_dir                                                            #
# checks a directory and creates it if it is empty                     #
#======================================================================#

sub check_dir {

   my($folder) = shift;
   unless (-e $folder) {
      mkdir($folder,0777);
      chmod(0777,$folder);
   }
}

#======================================================================#
# readdata                                                             #
#======================================================================#

sub readdata {

   my $datafile = shift;
   my $r_data = [];

   # Pull off datafile name and path

   if (open(DATA,"$datafile")) {
      flock(DATA,2);
      @$r_data = <DATA>;
      flock(DATA,8);
      close(DATA);
   }
   else {
      my_die("Error in subroutine readdata: Can't open $datafile",$!);
   }

   $r_data;

}

#======================================================================#
# writedata                                                            #
#======================================================================#

sub writedata {

   my($datafile,$r_rows) = @_;

   if (open(DATA,">$datafile")) {
      flock(DATA,2);
      print DATA @$r_rows;
      flock(DATA,8);
      close(DATA);
      chmod(0666,$datafile);
   }
   else {
      my_die("Error in subroutine writedata: Can't open $datafile",$!);
   }

}

#======================================================================#
# appenddata                                                           #
#======================================================================#

sub appenddata {

   my($datafile,$row) = @_;

   if (open(DATA,">>$datafile")) {
      flock(DATA,2);
      print DATA "$row\n";
      flock(DATA,8);
      close(DATA);
   }
   else {
      my_die("Error in subroutine appenddata: Can't open $datafile",$!);
   }
}

#======================================================================#
# remove_dir                                                           #
#======================================================================#

sub remove_dir {

   my($dir) = shift;  
  
   opendir(F,"$dir") or
      my_die("Error in subroutine remove_dir: Can't open directory $dir",$!);

      while ($item = readdir(F)) {
         unlink("$dir/$item");
      }
   closedir(F);

   rmdir("$dir");
   
}


#======================================================================#
# my_crypt                                                             #
# if crypt causes error, use my_crypt                                  #
#======================================================================#

sub my_crypt {

   my ($arg1, $arg2) = @_;

   if ($platform eq "FREEBSD") {
      $arg1 = crypt($arg1,substr($arg1,0,2));
   }
   elsif ($platform eq "UNIX") {
      $arg1 = crypt($arg1,substr($arg2,0,2));
   }

   $arg1;
}

#======================================================================#
# subroutine send_mail
# REVISION
# 29 Dec 1998
#   Added Blatmail for NT servers
# 17 Mar 1998 - Version 1.0
#   First release
#
# NOTE:
#   Following variables are global
#   $smtp_server
#
#======================================================================#

sub send_mail {

   my ($dir,$mailprog,$from,$to,$subject,$message) = @_;

   # Remove REMOVE_THIS if it exists

   $from = remove_antispam($from);
   $to = remove_antispam($to);

   unless ($platform eq 'NT') {  
      open(MAIL,"|$mailprog -t") or
         my_die("Error in subroutine send_mail: Can't open $mailprog",$!);
      print MAIL "To: $to\n";
     print MAIL "From: $from\n";
      print MAIL "Subject: $subject\n\n";
      print MAIL "$message\n";
      close (MAIL);
   }
   else {
      #prepare mail message to send
      #Following lines uses blatmail
#     my (@output,$status);
#     my $temp_name = get_session_id();
#     my $temp_file = "$dir/$temp_name.emn";
#     $output[0] = $message;
#     writedata($temp_file,\@output);
#     $status = `$mailprog $temp_file -s \"$subject\" -f $from -t $to -server $smtp_server`;
#     unlink($temp_file);

# prepare mail message to send
# Hack for Win NT and UNIX that opens a smtp socket
# Hack submitted by 
        ($x,$x,$x,$x, $here) = gethostbyname($null);
        ($x,$x,$x,$x, $there) = gethostbyname($smtp_server);
        $thisserver = pack('S n a4 x8',2,0,$here);
        $remoteserver = pack('S n a4 x8',2,25,$there);
        (!(socket(S,2,1,6))) && (my_die("Sending Email: Connect error! socket",$!));
        (!(bind(S,$thisserver))) && (my_die("Sending Email: Connect error! bind",$!));
        (!(connect(S,$remoteserver))) && (my_die("Sending Email: Connection to $smtp_server has failed ",$!));

        select(S);
        $| = 1;
        select(STDOUT);

        $DATA_IN = <S>;
        ($DATA_IN !~ /^220/) && (my_die("Sending Email: data in Connect error - 220",$!)); 

        print S "HELO $smtp_server\r\n";
        $DATA_IN = <S>;
        ($DATA_IN !~ /^250/) && (my_die("Sending Email: data in Connect error - 250",$!)); 

        print S "MAIL FROM:<$from>\r\n";
        $DATA_IN = <S>;
        ($DATA_IN !~ /^250/) && (my_die("Sending Email: 'From' address not valid",$!)); 

        print S "RCPT TO:<$to>\r\n";
        $DATA_IN = <S>;
        ($DATA_IN !~ /^250/) && (my_die("Sending Email: 'Recipient' address not valid",$!)); 

        print S "DATA\n";
        $DATA_IN = <S>;
        ($DATA_IN !~ /^354/) && (my_die("Sending Email: Message send failed - 354",$!)); 

        print S "From: $from\n";
        print S "To: $to\n";
        print S "Subject: $subject\n\n";
        print S "$message\n";

        print S <<MESSAGES;
.
MESSAGES

        $DATA_IN = <S>;
        ($DATA_IN !~ /^250/) && (my_die("Sending Email: Message send failed - try again - 250",$!)); 
        print S "QUIT\n";

   }

}


#======================================================================#
# subroutine sendCookie
# Sends HTTP-COOKIE to the client
#======================================================================#

sub send_cookie {

  my ($key,$value,$expires,$domain) = @_;

  if ($expires ne "") {
      print "Set-Cookie: $key=$value; expires=$expires; path=/; \n";
   }
   else {
      print "Set-Cookie: $key=$value; path=/; \n";
   }


}

#======================================================================#
# subroutine get_cookie
# Get cookie from the client
# Cookie's name is $cookie
#======================================================================#

sub get_cookie {

  my ($cookie) = shift;
  my (@key_value_pairs, $key, $value);
  @key_value_pairs = split (/;\s/, $ENV{'HTTP_COOKIE'});

  foreach (@key_value_pairs) {
    ($key,$value) = split (/=/, $_);
    if ($key eq $cookie) {
      return $value;
    }
  }
  return 0;
}

#======================================================================#
# subroutine add_adtispam
#
# Inserts 'REMOVE_THIS' string after @ sign
#======================================================================#

sub add_antispam {
   my $email = shift;
   if ($anti_spam eq 'on') {
      unless ($email =~ /REMOVE_THIS/) {
         $email =~ s/(.*)\@(.*)/$1\@REMOVE_THIS$2/;
      }
   }
   return $email;
}

#======================================================================#
# subroutine remove_adtispam
#
# Removes 'REMOVE_THIS' string after @ sign
#======================================================================#

sub remove_antispam {
   my $email = shift;
   $email =~ s/REMOVE_THIS//g;
   return $email;
}

#======================================================================#
# subroutine compute_time
# returns time marker for keeping
# track of messages read
#======================================================================#

sub compute_time {
   my ($year, $month, $day, $hour, $minute, $second) = @_;
   $year += 1900 if ($year < 1000);

   my $mesg_mark = (($year - 1997) * 372 * 86400) +
            ($month * 31 * 86400) + ($day * 86400) +
            ($hour * 3600) + ($minute * 60) + $second;

   return $mesg_mark;
}

#======================================================================#
# subroutine get_date
# modified to work with dcboard
#======================================================================#

sub get_date {

   my ($r_in) = @_;
   my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime(time+3600*$time_offset);
   # Format to look nice
   $sec = sprintf("%02d",$sec);
   $min = sprintf("%02d",$min);
   $hour = sprintf("%02d",$hour);
   $mon = sprintf("%02d",$mon+1);
   $mday = sprintf("%02d",$mday);
   $year += 1900;
   my $last_read = (($year - 1997) * 372 * 86400) +
      ($mon * 31 * 86400) + (($mday - $r_in->{'days'}) * 86400)
       + ($hour * 3600) + ($min * 60) + $sec;

   my $time_now = (($year - 1997) * 372 * 86400) +
      ($mon * 31 * 86400) + ($mday * 86400)
       + ($hour * 3600) + ($min * 60) + $sec;

   my $month = $months[$mon];

   $r_in->{'localtime'} = "$hour\:$min\:$sec";
   $r_in->{'date'} = "$mon/$mday/$year";
   $r_in->{'last_read'} = $last_read;
   $r_in->{'time_now'} = $time_now;

}

#======================================================================#
# subroutine my_die
#======================================================================#

sub my_die {

   my($my_mesg, $sys_mesg) = @_;
   print_header();
   print_header_end();

   print qq~
   <html>
   <head>
   <title>$my_mesg</title>
   </head>
   <body bgcolor="#FFFFFF">
   <font face="verdana" size="5"><b>SCRIPT ERROR!!!</b></font>
   <hr>
   <font face="verdana" size="3">
   <b>
   There was an error in processing your request.<br>
   Following is the error message:
   <ul>
   <li>Script Message: $my_mesg
   <li>System Message: $sys_mesg
   </ul>
   <hr>
   Please notify the administrator of this site.
   <p>
   Thank you.
   </b>
   </font>

   </body>
   </html>
   ~;
   exit;       
}

#======================================================================#
# Subroutine get_session_id
# Generates session ID for a User.
# This portion of code from Selena and Gunther's
# auth-extra-lib.pl
#======================================================================#

sub get_session_id {

   my ($session, $session_file);

   # Seed the random generator

   srand($$|time);
   $session = int(rand(60000));

   # pack the time, process id, and random $session into a
   # hex number which will make up the session id.

   $session = unpack("H*", pack("Nnn", time, $$, $session));

} # End of get_session_id

#======================================================================#
# function time_format
#======================================================================#

sub time_format {
   my ($string) = shift;
   my ($hr,$min,$sec) = split(/\:/,$string);
   ($hr,$am_pm) = am_pm($hr);
   $string = join(":",$hr,$min);
   $string .= "&nbsp;" . $am_pm;
   return $string;
}

#======================================================================#
# function date_format
#======================================================================#

sub date_format {
   my ($string) = shift;
   my @months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
   my ($mon,$day,$year) = split(/\//,$string);
   if ($year > 100) {
      $year = substr($year,2,2);
   }
   if ($date_format eq "mmm-dd-yy") {
      $string = join("-",$months[$mon-1],$day,$year);
   }
   elsif ($date_format eq "dd-mmm-yy") {
      $string = join("-",$day,$months[$mon-1],$year);
   }
   elsif ($date_format eq "dd-mm-yy") {
      $string = join("-",$day,$mon,$year);
   }
   elsif ($date_format eq "mm-dd-yy") {
      $string = join("-",$mon,$day,$year);
   }

   return $string;
}

#======================================================================#
# function am_pm
# given hour, print am or pm
#======================================================================#

sub am_pm {
   my ($hour) = shift;
   my $am_pm = 'AM';
   
   if ($hour > 12) {
      $hour -= 12;
      $am_pm = 'PM';
   }
   elsif ($hour == 12) {
      $am_pm = 'PM';
   }

   $hour = sprintf("%02d",$hour);
   return ($hour,$am_pm);
}

#======================================================================#
# function toggle_color
# for switching back and forth...
#======================================================================#

sub toggle_color {

   my $reset = shift;

   unless ($reset) {
      if ($bgcolor eq $bg_color_1) {
         $bgcolor = $bg_color_2;
         $font_color = $font_color_2;
         $font_face = $font_face_2;
         $font_size = $font_size_2;
      }
      else {
         $bgcolor = $bg_color_1;
         $font_color = $font_color_1;
         $font_face = $font_face_1;
         $font_size = $font_size_1;
      }
   }
   else {
      $bgcolor = $bg_color_1;
      $font_color = $font_color_1;
      $font_face = $font_face_1;
      $font_size = $font_size_1;
   }
}

#======================================================================#
# function trim
# trim words that are certain size in length
#======================================================================#

sub trim {

   my $string = shift;
   my @sentence = split(/\s+/,$string);
   my $j = 0;
   foreach $word (@sentence) {
      my $s_length = length($word);
      if ($s_length > $word_length_max) {
         $sentence[$j] = substr($word,0,$word_length_max-1) . "- " . substr($word,$word_length_max,$s_length)
      }
      $j++;
   }
   $string = join(" ",@sentence);
   return $string;
}

#======================================================================#
# function print_header
# print HTTP header if not printed yet
#======================================================================#

sub print_header {

   unless ($print_header) {
      print "Content-type: text/html\n";
      $print_header = 1;
   }
   return 0;
}

#======================================================================#
# function print_header_end
# print end of HTTP header if not printed yet
#======================================================================#

sub print_header_end {
   unless ($print_header_end) {
      print "\n";
      $print_header_end = 1;
   }
}

#======================================================================#
# function dc_decode
# decode encoded string
#======================================================================#

sub dc_decode {
    my $todecode = shift;
    return undef unless defined($todecode);
    $todecode =~ tr/+/ /;       # pluses become spaces
    $todecode =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
    $todecode =~ s/\r\n/\n/g;;
    return $todecode;
}

#======================================================================#
# function dc_encode
# encode string
#======================================================================#

sub dc_encode {
    my $toencode = shift;
    return undef unless defined($toencode);
    $toencode =~ s/([^a-zA-Z0-9_. -])/uc sprintf("%%%02x",ord($1))/eg;
    return $toencode;
}

#======================================================================#
# function print_status
# print current status
#======================================================================#

sub print_status {

   my $string = shift;  
   my $output = qq~
      <center>
      <font size="3" face="$font_face_2" color="$font_color_2">
      <b>Administration Status</b><p>
      <b>$string</b>
      </font>
      </center>
   ~;
   $output;

}

#===============================================================#
# function form_to_text                                         #
# translates form data to text database format                  #
#===============================================================#

sub form_to_text {
   my $text = shift;
   $text =~ s/"/\&quot\;/g;
   $text =~ s/>/\&gt\;/g;
   $text =~ s/</\&lt\;/g;
   $text =~ s/\n\n/\[P\]/g;
   $text =~ s/\r\n/\[BR\]/g;
   $text =~ s/\n/\[BR\]/g;
   $text =~ s/\cM//g;
   return $text;
}

#===============================================================#
# function text_to_form                                         #
# translates text data to form data format                      #
#===============================================================#

sub text_to_form {
   my $text = shift;
   $text =~ s/\&quot\;/"/g;
   $text =~ s/\[P\]/\n\n/gi;
   $text =~ s/\[BR\]/\n/gi;
   return $text;
}

#======================================================================#
# get_userdata                                                         #
# Gets user data from the session file                                 #
#======================================================================#

sub get_userdata {

   my ($session_file) = @_;
   my $r_data = readdata($session_file);
   my $r_local = {};
   
   foreach (@{$r_data}) {
      chomp;
      ($key,$value) = split(/::/,$_);
      $r_local->{$key} = $value;
   }

   return $r_local;

}

#===============================================================#
# sub get_user_email
# given username, it retrieve the user email
#===============================================================#


sub get_user_email {

   my $user = shift;
   my $r_userdata = readdata("$password_file_dir/$password_file");

   foreach (@{$r_userdata}) {
      chomp;
      my @fields = split /$split_delim/;
      if ($user eq $fields[1]) {
         return $fields[5];
      }
   }

   return 0;

}

#===============================================================#
# sub sort_topics
#===============================================================#

sub sort_topics {

   my ($r_data,$sort_field) = @_;
   my @sorted;

   if ($sort_field == $replies_index or
      $sort_field == $rating_index or
      $sort_field == $view_index or
      $sort_field == $id_index) {

		$sort_field--;
      @sorted = map { $_->[0] }
             reverse sort { $a->[1] <=> $b->[1] }
             map { [$_,(split /$split_delim/)[$sort_field] ] } @{$r_data};

   }
   else {

		$sort_field--;
      @sorted = map { $_->[0] }
             sort {uc($a->[1]) cmp uc($b->[1]) }
             map { [$_,(split /$split_delim/)[$sort_field] ] } @{$r_data};

   }

   return \@sorted;

}


#-----------------------------------------------------------------
# contents of cgi-lib.pl
# Perl Routines to Manipulate CGI input
# S.E.Brenner@bioc.cam.ac.uk
# $Id: cgi-lib.pl,v 2.8 1996/03/30 01:36:33 brenner Rel $
#
# Copyright (c) 1996 Steven E. Brenner  
# Unpublished work.
# Permission granted to use and modify this library so long as the
# copyright above is maintained, modifications are documented, and
# credit is given for any use of the library.

($cgi_lib'version = '$Revision: 2.8 $') =~ s/[^.\d]//g;

$cgi_lib'maxdata    = 131072;    # maximum bytes to accept via POST - 2^17
$cgi_lib'writefiles =      0;    # directory to which to write files, or
                                 # 0 if files should not be written
$cgi_lib'filepre    = "cgi-lib"; # Prefix of file names, in directory above

# Do not change the following parameters unless you have special reasons
$cgi_lib'bufsize  =  8192;    # default buffer size when reading multipart
$cgi_lib'maxbound =   100;    # maximum boundary length to be encounterd
$cgi_lib'headerout =    0;    # indicates whether the header has been printed

sub ReadParse {
  local (*in) = shift if @_;    # CGI input
  local (*incfn,                # Client's filename (may not be provided)
    *inct,                 # Client's content-type (may not be provided)
    *insfn) = @_;          # Server's filename (for spooled files)
  local ($len, $type, $meth, $errflag, $cmdflag, $perlwarn);
   
  # Disable warnings as this code deliberately uses local and environment
  # variables which are preset to undef (i.e., not explicitly initialized)
  $perlwarn = $^W;
  $^W = 0;
   
  # Get several useful env variables
  
  $type = $ENV{'CONTENT_TYPE'};
  $len  = $ENV{'CONTENT_LENGTH'};
  $meth = $ENV{'REQUEST_METHOD'};
  
  if ($len > $cgi_lib'maxdata) { #'
      my_die("cgi-lib.pl: Request to receive too much data: $len bytes\n",$!);
  }
  
  if (!defined $meth || $meth eq '' || $meth eq 'GET' || 
      $type eq 'application/x-www-form-urlencoded') {
    local ($key, $val, $i);
   
    # Read in text
    if (!defined $meth || $meth eq '') {
      $in = $ENV{'QUERY_STRING'};
      $cmdflag = 1;  # also use command-line options
    } elsif($meth eq 'GET' || $meth eq 'HEAD') {
      $in = $ENV{'QUERY_STRING'};
    } elsif ($meth eq 'POST') {
        $errflag = (read(STDIN, $in, $len) != $len);
    } else {
      my_die("cgi-lib.pl: Unknown request method: $meth\n",$!);
    }

    @in = split(/[&;]/,$in); 
    push(@in, @ARGV) if $cmdflag; # add command-line parameters

    foreach $i (0 .. $#in) {

      # Convert plus to space
      $in[$i] =~ s/\+/ /g;

      # Split into key and value.  
      ($key, $val) = split(/=/,$in[$i],2); # splits on the first =.

      # Convert %XX from hex numbers to alphanumeric
      $key =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;
      $val =~ s/%([A-Fa-f0-9]{2})/pack("c",hex($1))/ge;

      # Associate key and value
      $in{$key} .= "\0" if (defined($in{$key})); # \0 is the multiple separator
      $in{$key} .= $val;
    }

  } elsif ($ENV{'CONTENT_TYPE'} =~ m#^multipart/form-data#) {
    # for efficiency, compile multipart code only if needed
   $errflag = !(eval <<'END_MULTIPART');

    local ($buf, $boundary, $head, @heads, $cd, $ct, $fname, $ctype, $blen);
    local ($bpos, $lpos, $left, $amt, $fn, $ser);
    local ($bufsize, $maxbound, $writefiles) = 
      ($cgi_lib'bufsize, $cgi_lib'maxbound, $cgi_lib'writefiles);


    # The following lines exist solely to eliminate spurious warning messages
    $buf = ''; 

    ($boundary) = $type =~ /boundary="([^"]+)"/; #";   # find boundary
    ($boundary) = $type =~ /boundary=(\S+)/ unless $boundary;
    my_die("Boundary not provided",$!) unless $boundary;
    $boundary =  "--" . $boundary;
    $blen = length ($boundary);

    if ($ENV{'REQUEST_METHOD'} ne 'POST') {
      my_die("Invalid request method for  multipart/form-data: $meth\n",$!);
    }

    if ($writefiles) {
      local($me);
      stat ($writefiles);
      $writefiles = "/tmp" unless  -d _ && -r _ && -w _;
      # ($me) = $0 =~ m#([^/]*)$#;
      $writefiles .= "/$cgi_lib'filepre"; 
    }

    # read in the data and split into parts:
    # put headers in @in and data in %in
    # General algorithm:
    #   There are two dividers: the border and the '\r\n\r\n' between
    # header and body.  Iterate between searching for these
    #   Retain a buffer of size(bufsize+maxbound); the latter part is
    # to ensure that dividers don't get lost by wrapping between two bufs
    #   Look for a divider in the current batch.  If not found, then
    # save all of bufsize, move the maxbound extra buffer to the front of
    # the buffer, and read in a new bufsize bytes.  If a divider is found,
    # save everything up to the divider.  Then empty the buffer of everything
    # up to the end of the divider.  Refill buffer to bufsize+maxbound
    #   Note slightly odd organization.  Code before BODY: really goes with
    # code following HEAD:, but is put first to 'pre-fill' buffers.  BODY:
    # is placed before HEAD: because we first need to discard any 'preface,'
    # which would be analagous to a body without a preceeding head.

    $left = $len;
   PART: # find each part of the multi-part while reading data
    while (1) {
      last PART if $errflag;

      $amt = ($left > $bufsize+$maxbound-length($buf) 
         ?  $bufsize+$maxbound-length($buf): $left);
      $errflag = (read(STDIN, $buf, $amt, length($buf)) != $amt);
      $left -= $amt;

      $in{$name} .= "\0" if defined $in{$name}; 
      $in{$name} .= $fn if $fn;

      $name=~/([-\w]+)/;  # This allows $insfn{$name} to be untainted
      if (defined $1) {
        $insfn{$1} .= "\0" if defined $insfn{$1}; 
        $insfn{$1} .= $fn if $fn;
      }
 
     BODY: 
      while (($bpos = index($buf, $boundary)) == -1) {
        if ($name) {  # if no $name, then it's the prologue -- discard
          if ($fn) { print FILE substr($buf, 0, $bufsize); }
          else     { $in{$name} .= substr($buf, 0, $bufsize); }
        }
        $buf = substr($buf, $bufsize);
        $amt = ($left > $bufsize ? $bufsize : $left); #$maxbound==length($buf);
        $errflag = (read(STDIN, $buf, $amt, $maxbound) != $amt);  
        $left -= $amt;
      }
      if (defined $name) {  # if no $name, then it's the prologue -- discard
        if ($fn) { print FILE substr($buf, 0, $bpos-2); }
        else     { $in {$name} .= substr($buf, 0, $bpos-2); } # kill last \r\n
      }
      close (FILE);
      last PART if substr($buf, $bpos + $blen, 4) eq "--\r\n";
      substr($buf, 0, $bpos+$blen+2) = '';
      $amt = ($left > $bufsize+$maxbound-length($buf) 
         ? $bufsize+$maxbound-length($buf) : $left);
      $errflag = (read(STDIN, $buf, $amt, length($buf)) != $amt);
      $left -= $amt;


      undef $head;  undef $fn;
     HEAD:
      while (($lpos = index($buf, "\r\n\r\n")) == -1) { 
        $head .= substr($buf, 0, $bufsize);
        $buf = substr($buf, $bufsize);
        $amt = ($left > $bufsize ? $bufsize : $left); #$maxbound==length($buf);
        $errflag = (read(STDIN, $buf, $amt, $maxbound) != $amt);  
        $left -= $amt;
      }
      $head .= substr($buf, 0, $lpos+2);
      push (@in, $head);
      @heads = split("\r\n", $head);
      ($cd) = grep (/^\s*Content-Disposition:/i, @heads);
      ($ct) = grep (/^\s*Content-Type:/i, @heads);

      ($name) = $cd =~ /\bname="([^"]+)"/i; #"; 
      ($name) = $cd =~ /\bname=([^\s:;]+)/i unless defined $name;  

      ($fname) = $cd =~ /\bfilename="([^"]*)"/i; #"; # filename can be null-str
      ($fname) = $cd =~ /\bfilename=([^\s:;]+)/i unless defined $fname;
      $incfn{$name} .= (defined $in{$name} ? "\0" : "") . $fname;

      ($ctype) = $ct =~ /^\s*Content-type:\s*"([^"]+)"/i;  #";
      ($ctype) = $ct =~ /^\s*Content-Type:\s*([^\s:;]+)/i unless defined $ctype;
      $inct{$name} .= (defined $in{$name} ? "\0" : "") . $ctype;

      if ($writefiles && defined $fname) {
        $ser++;
   $fn = $writefiles . ".$$.$ser";
   open (FILE, ">$fn") || my_die("Couldn't open $fn\n",$!);
      }
      substr($buf, 0, $lpos+4) = '';
      undef $fname;
      undef $ctype;
    }

1;
END_MULTIPART
  my_die($@,$!) if $errflag;
  } else {
    my_die("cgi-lib.pl: Unknown Content-type: $ENV{'CONTENT_TYPE'}\n",$!);
  }


  $^W = $perlwarn;

  return ($errflag ? undef :  scalar(@in)); 
}


# The following lines exist only to avoid warning messages
$cgi_lib'writefiles =  $cgi_lib'writefiles;
$cgi_lib'bufsize    =  $cgi_lib'bufsize ;
$cgi_lib'maxbound   =  $cgi_lib'maxbound;
$cgi_lib'version    =  $cgi_lib'version;


1;
