# caption_list.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

sub caption_list {
  
   my ($r_in,$r_setup) = @_;

   # Current time marker
   my $time_mark = $r_in->{'time_now'};

   # Temporary variables used in this function
   my $temp_output, $other;
   
   # column span for listing topics
   my $colspan = 5;
   
   # Reference colspan  
   $r_in->{'colspan'} = $colspan;

   # read in user's time marks
   my $r_user_mark = get_user_mark($r_in,$r_setup);

   # forum database
   my $datafile  = "$maindir/$forum/$database";

   # Read in forum data
   my $r_rowdata = readdata($datafile);
   
   my $sort_by_field = get_cookie($sort_by_field_cookie);

   if ($sort_by_field ne '') {
      $r_rowdata = sort_topics($r_rowdata,$sort_by_field); 
   }
   
   # total number of messages
   my $num_messages = @{$r_rowdata};

   # stuff for next and previous pages
   my $num_next = int(($num_messages - 1)/$mesg_max) + 1;
   my $start = $r_in->{'mm'} + 1;
   my $stop = $r_in->{'mm'} + $mesg_max;
   
   $stop = $num_messages if ($stop > $num_messages);

   # End of HTTP Header
   print_header();
   print_header_end();

   # Create menu buttons
   my $menu_button = create_button('list',$r_in,$r_setup);
   my $heading = $forum_title;

   # Oppps, forum is offline
   if ($r_setup->{'forum_status'}->{ $forum } ne "on") {
      ($heading,$sub_heading,$html_output) = 
         access_error('forum off',$r_in,$r_setup);
      return ($heading, $sub_heading, $html_output,$menu_button);
   }
   # Oppps, access is not allowed
   elsif ( ! check_forum_access($r_in,$r_setup,$forum) ) {
      ($heading,$sub_heading,$html_output) = 
         access_error('forum private',$r_in,$r_setup);
      return ($heading, $sub_heading, $html_output,$menu_button);
   }
   # Construct links to additional topics
   $stop--;
   $start--;

   my @temp_out;

   if ($num_next > 1) {
      for ($j=1;$j<=$num_next;$j++) {
         my $mesg_marker = ($j-1)*$mesg_max;
         my $j_start = ($j-1)*$mesg_max + 1;
         my $j_stop = $j*$mesg_max;
         $j_stop=$num_messages if ($j_stop > $num_messages);
         if ($mesg_marker == $start) {
            push(@temp_out,$j);
         }
         else {
            push(@temp_out, "<a href=\"$boardurl?az=list&forum=$forum&mm=$mesg_marker&archive=$r_in->{'archive'}\">$j</A>");
         }
      }
      $temp_output = join(" \| ",@temp_out);
      $other = " \| ";
   }

   if ($r_in->{'archive'}) {
      $other .= " <a href=\"$boardurl?forum=$forum&az=list\">Current</a>
      ($r_setup->{'forum_threads'}->{$forum})\n";
   }
   elsif ($r_setup->{'forum_archive'}->{$forum}) {
      $other .= " <a href=\"$boardurl?forum=$forum&az=list&archive=yes\">Archive</a>
      ($r_setup->{'forum_archive'}->{$forum})\n";
   }

   # Finished creating topic links

   my $colspan_2 = $colspan - 2;

   # start of the output
   $html_output .= qq~
      <TABLE BORDER="0" WIDTH="$table_width" cellspacing="1" cellpadding="3">
      <TR><TD ALIGN="LEFT" VALIGN="BOTTOM" colspan="2" BGCOLOR="$bg_color_4">
      <font face="$font_face_4" color="$font_color_4" size="1">~;

   if ($session and $r_setup->{'subscription'} eq 'on') {
      $html_output .= qq~
         <img src="$imgurl/subscribe.gif" align="bottom" border="0"><a 
            href="$boardurl?az=user&command=forum_subscription"><font 
               face="$font_face_4" color="$font_color_4" size="1">Subscribe 
                  To Forums</font></a><br>~;
   }

   if ($r_setup->{'allow_expand'} eq 'on') {
      $html_output .= qq~
         <img src="$imgurl/expand_threads.gif" align="bottom" border="0"><a 
            href="$boardurl?az=expand_threads"><font 
               face="$font_face_4" color="$font_color_4" size="1">Expand Threads</font></a>~;
   }


   $html_output .= qq~
      </font></td>
      <TD COLSPAN="$colspan_2" ALIGN="RIGHT" VALIGN="BOTTOM" BGCOLOR="$bg_color_4">
      <font face="$font_face_4" color="$font_color_4" size="$font_size_4">~;


   if ($r_setup->{'forum_queue'}->{$forum} eq 'on') {
      $html_output .=  "<b><font color=\"$font_color_special\">Moderated Forum</font></b><br>";
   }


   $html_output .= qq~
      $temp_output $other</FONT></TD></TR>~;

   $html_output .= navigation_menu($r_in,$r_setup);      
   $html_output .= qq~
   <a name="TOP">&nbsp;</a>
   ~;
      $html_output .= qq~
      <TR BGCOLOR="$bg_color_0"><TD ALIGN="LEFT" colspan="2"><font 
         SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
         Sort Topics by..... <a 
            href="$boardurl?az=set_sort_index&field=$id_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  ID</font></a> |
            <a 
            href="$boardurl?az=set_sort_index&field=$subject_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Topic</font></a> |
            <a 
            href="$boardurl?az=set_sort_index&field=$author_index"><font 
            SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Author</font></a> |
            <a 
            href="$boardurl?az=set_sort_index&field=$date_index"><font 
            <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
               Date</font></a> ~;
               
            if ($r_setup->{'read_count'} eq 'on') {
               $html_output .= qq~
                | <a 
                  href="$boardurl?az=set_sort_index&field=$view_index"><font 
                  SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                     Views</font></a> ~;
            }
      
      
            if ($r_setup->{'user_rating'} eq 'on') {
               $html_output .= qq~
               | <a 
                  href="$boardurl?az=set_sort_index&field=$rating_index"><font 
                  SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                     Rating</font></a> ~;
            }  

                     
            $html_output .= qq~
                     </font></TD>
            <TD ALIGN="LEFT" COLSPAN="3">
            <font SIZE="$font_size_0" FACE="$font_face_0" color="$font_color_0">
                  Discussion&nbsp;Information</font>
               </TD></TR>~;

   my @row = @$r_rowdata[$start..$stop];
  
   toggle_color('reset');

   foreach (@row) {

      my $thisimg = "file.gif";
      my $marker = '';
      my ($num,$date,$ltime,$name,$subject,$caption,
         $lock,$read,$user_rating,$replies) = split /$split_delim/;

      my $rating = 0;

      if ($r_setup->{'user_rating'} eq 'on') {

         $user_rating =~ s/^\s+//g;
         my @votes = split(/\,/,$user_rating);
         my $num_vote = @votes;
         if ($num_vote > 0) {
            foreach (@votes) {
               $rating += $_;
            }
            $rating = sprintf("%.1f",$rating / $num_vote);
            $rating = "<b>$rating</b> rating<br>";
         }
         else {
            $rating = '';
         }

      }

      $subject = dc_decode($subject);
      $caption = dc_decode($caption);
      $caption = form_to_text($caption);
      $caption =~ s/\[P\]/ /gi;
      $caption =~ s/\[BR\]/ /gi;
      $caption = trim($caption);

      $name = check_team($name,$team);

      if ($r_user_mark->{$forum} ne "") {
         if (check_new($ltime,$date,$r_user_mark->{$forum})) {
                $marker = " <img src=\"$imgurl/newmark.gif\"> ";
         }
      }
      elsif ($r_in->{'userdata'}->{'Username'}) {
                $marker = " <img src=\"$imgurl/newmark.gif\"> ";
      }
      if ($lock or $r_in->{'archive'}) {
                $thisimg = "locked_file.gif";
      }

        $html_output .=qq~
           <TR><TD ALIGN="LEFT" VALIGN="TOP" BGCOLOR="$bg_color_2">
           <img src="$imgurl/$thisimg"></TD><TD ALIGN="LEFT" 
         WIDTH="100%" VALIGN="TOP" BGCOLOR="$bgcolor">~;

      # Active listing...not archive
      # this topic is not an archive
      if ($r_in->{'archive'} eq '') {

         # If the number of replies is greater than the maximum messages
         # allowed, kick into autosensing mode
         if ($replies > $r_setup->{'max_messages'}
            and $lock eq '') {

            # Read count option is on
            if ($r_setup->{'read_count'} eq 'on') {
               $html_output .=qq~
                  <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=read_count&om=$num&forum=$forum&omm=0&auto_sense=on"><b>$subject</b></a>
                     [<a href="$boardurl?az=read_count&om=$num&forum=$forum">View&nbsp;All</a>]<br>
                     $caption
                     ~;
            }
            # Read count option is not on
            else {
               $html_output .=qq~
               <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                  <a href="$boardurl?az=show_thread&om=$num&forum=$forum&omm=0"><b>$subject</b></a>
               ~;
               if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                  $html_output .=qq~
                  [<a href="$boardurl?az=show_thread&om=$num&forum=$forum">View&nbsp;All</a>]
                  ~;
               }
               else {
                  $html_output .=qq~
                  [<a href="$mainurl/$forum/$num\.$ext">View&nbsp;All</a>]
                  ~;
               }
               $html_output .= "<br>$caption";
            }
         }
         # The number of messages does not exceed max messages
         else {
   
            if ($r_setup->{'read_count'} eq 'on') {
               $html_output .=qq~
                     <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                     <a href="$boardurl?az=read_count&om=$num&forum=$forum"><b>$subject</b></a>
                     $marker
                     <br>$caption~;
            }
            else {
               if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                  $html_output .=qq~
                    <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                    <a href="$boardurl?az=show_thread&om=$num&forum=$forum"><b>$subject</b></a>  $marker
                   <br>$caption~;
               }
               else {
                  $html_output .=qq~
                    <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                    <a href="$mainurl/$forum/$num.$ext"><b>$subject</b></a>  $marker
                  <br>$caption~;
               }
            }
         }
   
      } # End of if ($replies...etc)
      # Ok, we're displaying the archives
      else {
            if ($r_setup->{'read_count'} eq 'on') {
               $html_output .=qq~
                     <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                     <a href="$boardurl?az=read_count&om=$num&forum=$forum&archive=$r_in->{'archive'}"><b>$subject</b></a>
                     $marker
                     <br>$caption~;
            }
            else {
               if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
                  $html_output .=qq~
                    <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                    <a href="$boardurl?az=show_thread&om=$num&forum=$forum&archive=$r_in->{'archive'}"><b>$subject</b></a>  $marker
                  <br>$caption~;
               }
               else {
                  $html_output .=qq~
                    <FONT SIZE="$font_size" COLOR="$font_color" FACE="$font_face">
                    <a href="$mainurl/$forum/$num.$ext"><b>$subject</b></a>  $marker
                  <br>$caption
                  ~;
               }
            }

      } # End of if $r_in->{'archive'}
   
      $html_output .= "</FONT></TD>\n";
   
      # Display other information
        $ltime = time_format($ltime);
        $date = date_format($date);

        $html_output .=qq~
         <TD ALIGN="Left" VALIGN="TOP" COLSPAN="3" BGCOLOR="$bg_color_2">
           <FONT SIZE="$font_size_2" COLOR="$font_color_2" FACE="$font_face_2">
           <b>$name</b><br>
           <b>$replies</b> messages<br>~;

        if ($r_setup->{'read_count'} eq 'on') {
           $html_output .=qq~
            <b>$read</b> views<br>~;         
        }            

        $html_output .=qq~
           $rating
           <font size="1">$date $ltime</font></FONT>
        </TD>
        </TR>
        ~;

      toggle_color();
         
         
  } #End of foreach row

   $html_output .=qq~
   <TR><TD COLSPAN="$colspan" BGCOLOR="$bg_color_0" ALIGN="CENTER">
      <font size="$font_size_0">&nbsp;</font></TD></TR>
   <TR><TD COLSPAN="$colspan" ALIGN="RIGHT" VALIGN="BOTTOM" BGCOLOR="$bg_color_4">
   <font face="$font_face_4" color="$font_color_4" size="$font_size_4">
   $temp_output $other
   </FONT>
   </TD></TR></TABLE>~;

   return ($heading, $sub_heading, $html_output,$menu_button);

}

1;