# auth_login.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
#======================================================================#
# function auth_login                                                  #
# login authentication library                                         #
#======================================================================#

sub auth_login {

   my ($r_in,$r_setup) = @_;
   my ($heading,$sub_heading,$html_output,$menu_button);
   my $r_local = {};
   my $r_login_fields = \@login_fields;
   my $r_form_type = \%field_form_type;
   my $error;  

   # auth_lib.pl is required to initialize some variables
   require "$cgilib/auth_lib.pl";
   $r_local = auth_init($r_in,$r_login_fields,$r_form_type);

   if ($r_in->{'cmd'}eq 'login') {

      $error = check_password($r_in,$r_local);

      unless ($error) {
         my $session = get_session_id();
         # If Rembering of password is allowed, then
         # add '%%' to the session id so that
         # remove_session_files won't remove them
         if ($r_in->{'remember'}) {
            $session = '%%' . $session;
            send_cookie($cookie_name,$session,
                  $expires,$domain);
         }
         else {
            send_cookie($cookie_name,$session,
            '',$domain);
         }
         my @temp_array;
         foreach (keys %{ $r_local->{'login_fields'} }) {
            unless ($_ eq "Password") {
               my $temp_string = join ("::",$_,$r_local->{'login_info'}->{$_});
               push(@temp_array,"$temp_string\n");
            }
         }

         my $access = "Forums::";

         foreach $forum (@{$r_setup->{'forums'}}) {
            if ($r_setup->{'forum_type'}->{$forum} eq 'Private') {
               if (-e "$password_file_dir/$forum.$priv_user_ext") {
                  $r_members = readdata("$password_file_dir/$forum.$priv_user_ext");
               }
               foreach (@{$r_members}) {
                  chomp;
                  if ($r_local->{'login_info'}->{'Username'} eq $_) {
                     $access .= "$forum,";
                     $r_local->{'login_info'}->{'Forums'} .= "$forum,";
                     last;
                  }
               }
            }
         } # End of $forum..etc

         chop($access) if ($access =~ /\,$/);
         push(@temp_array,"$access\n");
         
         # Create session file
         writedata("$sessiondir/$session.session",\@temp_array);

         # Write to log file
         # Keeps track of user actions
         write_to_log($r_in->{'Username'},"logon",$r_in);

         return $r_local->{'login_info'};

      }    
      else {
    
         print "\n";
         $heading = "DCForum Login Window";
         $sub_heading = "<b><font size=3>Login Problem: $error<br></font></b>\n";
         $html_output .= display_logon($r_in,$r_local);

      } #End of Unless

   }
   else {

      print_header_end();
   
      $heading = "DCForum Login Window";

      if ($r_setup->{'auth_allow_registration'} eq 'on') {
         $sub_heading = qq~
         <font size="2">
         <b>New User?</b> <a href="$boardurl?az=user_register">Click 
         here to register and create an account</a>.<p>~;
      }

      $sub_heading .= qq~
      <font size="2">
      <b>Don't remember your password?</b> <a 
      href="$boardurl?az=retrieve_password">Click here 
      to retrieve your password</a>.
      <p>
      <font size="3"><b>Please enter your username and password to login.</b></font>~;

#      <b>Guest User?</b>
#     <a href="$boardurl?az=lobby">Click here to for a limited access</a>.
#     </font>
#     <p>

      $html_output = display_logon($r_in,$r_local);

   }

   my %namespace = (
      HEADER => $heading,
      MENU => $menu_button,
      SUBHEADER => $sub_heading,
      HTMLOUTPUT => $html_output );

   display_output($templatefile,\%namespace); 
   exit(0);


}


1;
