# auth_lib_2.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#

#======================================================================#
# function output_form                                                 #
# display login and registration form                                  #
#======================================================================#

sub output_form {

   my ($r_in,$r_local,$r_setup) = @_;
   my $temp_html;

   my $html_output .= qq~
   <form method="post">
   ~;
  
   if ($r_in->{'sub_action'} eq 'modify') {
      $r_local->{'form_type'}->{'Group'} = join("$join_delim",
         "select",@group);
      $html_output .= qq~
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="sub_action" value="$r_in->{'sub_action'}">
      <input type="hidden" name="command" value="save">
      ~;
   }
   elsif ($r_in->{'az'} eq 'admin_create_new_account') {
      $r_local->{'form_type'}->{'Status'} = join("$join_delim",
         "radio","on","off");
      $r_local->{'form_type'}->{'Group'} = join("$join_delim",
         "select",@group);
      $html_output .= qq~
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="sub_action" value="$r_in->{'sub_action'}">
      <input type="hidden" name="command" value="save">
      ~;
   }
   else {
      $r_local->{'form_type'}->{'Status'} = "";
      $r_local->{'form_type'}->{'Group'} = "";
      $html_output .= qq~
      <input type="hidden" name="command" value="register">
      ~;

      #If there are fields that must be passed to this page
      #do so now...
      foreach (@{$r_in->{'in_param'}}) {
         if ($r_in->{$_}) {
            $html_output .= qq~
            <input type="hidden" name="$_" value="$r_in->{$_}">
            ~;
         }
      }

   }


   $html_output .= qq~ 
   <table border="0" align="center">
   ~;

   my %temp;

   foreach $field (@{$r_local->{'fields'}}) {

      my @fields = split(/$split_delim/,$r_local->{'form_type'}->{$field});
      my $required = pop(@fields);

      if ($required eq "required") {

         if (defined $temp{'required'}) {
            $temp{'required'} = join("\,",$temp{'required'},$field);
         } else {
            $temp{'required'} = $field;
         }
         $suffix = " <font color=\"#FF0000\"><b>*</b></font>:";
      }
      else {
         push(@fields,$required);
         $suffix = ":";
      }
    
      if ($fields[0] eq "text") {

         if ($field eq 'Username') {
            my $temp .= qq~
              <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
              $field$suffix</font></th>
              <td  bgcolor="$bg_color_3">
              <input type="$fields[0]" name="$field"
              size="$fields[1]" value="$r_in->{$field}">
              </td></tr>
            ~;
            $temp_html = $temp . $temp_html;
         }
         else {
            $temp_html .= qq~
               <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
               size="$font_size_3" color="$font_color_3" face="$font_face_3">
               $field$suffix</font></th>
               <td  bgcolor="$bg_color_2">
               <input type="$fields[0]" name="$field"
                  size="$fields[1]" value="$r_in->{$field}"></td></tr>~;
         }
      }
      elsif ($fields[0] eq "password") {

         $temp_html .= qq~
         <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
         $field$suffix</font></th>
         <td  bgcolor="$bg_color_3">
              <input type="$fields[0]" name="$field"
         size="$fields[1]" value="$r_in->{$field}"></td></tr>~;

         if ($r_in->{'sub_action'} eq 'modify') {
            $temp_html .= qq~
            <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
                           $field again$suffix</font></th>
               <td  bgcolor="$bg_color_3">
               <input type="$fields[0]" name="dup_$field" 
               size="$fields[1]" value="$r_in->{$field}">
              </td></tr>
            ~;
         }
         else {

            $temp_html .= qq~
            <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
              $field again$suffix</font></th>
            <td  bgcolor="$bg_color_3">
              <input type="$fields[0]" name="dup_$field"
               size="$fields[1]" value="$r_in->{"dup_" . $field}">
            </td></tr>
            ~;
         }

         if ($r_setup->{'auth_register_via_email'} eq "on" 
              and $r_in->{'sub_action'} ne 'modify' 
              and $r_in->{'sub_action'} ne 'new_user') {
            unless ($r_in->{'az'} eq 'admin_create_new_account') {
               $temp_html = '';
            }
         }

      }

      elsif ($fields[0] eq "hidden") {

         if ($field eq 'Password') {
            $temp_html .= qq~
               <tr><td>
            <input type="$fields[0]" name="$field" value="$fields[1]">
            <input type="$fields[0]" name="dup_$field" value="$fields[1]">
            </td></tr>
            ~;
         }
         else {
            $temp_html .= qq~
            <tr><td>
            <input type="$fields[0]" name="$field" value="$fields[1]">
            </td></tr>
            ~;
         }
      }
      
      elsif ($fields[0] eq "radio" || $fields[0] eq "checkbox") {
      
         $temp_html .= qq~
           <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">
            $field$suffix</font></th>
         <td bgcolor="$bg_color_3">
         ~;
         my $type = $fields[0];

         shift(@fields);

         foreach (@fields) {
            if ($_ eq $r_in->{$field}) {
               $temp_html .= qq~
               <input type="$type" name="$field" value="$_" checked>$_
               ~;
            }
            else {
               $temp_html .= qq~
               <input type="$type" name="$field" value="$_" >$_
               ~;
            }
         }

         $temp_html .= qq~
         </td></tr>~;
      }
    
      elsif ($fields[0] eq "select") {
      
         $temp_html .= qq~
         <th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_2" color="$font_color_3" face="$font_face_3">$field$suffix</font></th>
         <td align="left" bgcolor="$bg_color_3">
              <select name="$field">
         ~;
         shift(@fields);

         foreach (@fields) {
            if ($_ eq $r_in->{$field}) {
               $temp_html .= qq~
               <option value="$_" selected>$_
               ~;
            }
            else {
               $temp_html .= qq~
               <option value="$_">$_
               ~;        
            }
         }
         
         $temp_html .= qq~
         </select></td></tr>
         ~;
      }
    
      elsif ($fields[0] eq "textarea") {
      
         $temp_html .= qq~
         <tr><th align="right" valign="top" bgcolor="$bg_color_3"><font 
              size="$font_size_3" color="$font_color_3" face="$font_face_3">$field$suffix</font></th>
         <td bgcolor="$bg_color_3"><textarea name="$field" rows="$fields[1]" 
          cols="$fields[2]" wrap="physical">$r_in->{$field}</textarea>
          </td></tr>
         ~;
      }

   }

   $html_output .= qq~
   $temp_html
        <tr bgcolor="$bg_color_3"><th>&nbsp;
        <input type="hidden" name="required" value="$temp{'required'}"></th>
        <td><input type="submit" value="Submit Registration">
          <input type="reset" value="Reset">
        </td></tr>
   </table>
   </form>
   ~;

}

#======================================================================#
# function update_user                                                 #
# Update user info based on change request                             #
#======================================================================#

sub update_user {

   my ($r_in,$r_local) = @_;
   my ($error);
   my $r_data = readdata("$password_file_dir/$password_file");

   unless ($r_in->{'Password'} eq $r_in->{'dup_Password'}) {
      $error = "Two New Passwords are not same";
      return $error;
   }

   my @new_data;

   foreach (@$r_data) {

      chomp;
      my $r_entry = [ split /$split_delim/ ];

      if ($r_entry->[$r_local->{'login_fields'}->{'Username'}] 
         eq $r_in->{'Username'}) {

         foreach (@{$r_local->{'fields'}}) {
            if ($_ eq 'Password') {
               if ($r_in->{$_} ne $r_entry->[$r_local->{'login_fields'}->{$_}] ) {
                  srand(time|$$);
                  my $salt = "";
                  my $random = "abcdefghijklmnopqrstuvwxyz1234567890";
                  for (1..2) {
                    $salt .= substr($random,int(rand(36)),1);
                  }
                  unless ($r_in->{'no_crypt'}) {
                     $r_in->{$_} = my_crypt($r_in->{$_},$salt);
                  }

               }
            }
            elsif ($_ eq "EMail") {
               $r_in->{$_} =~ s/(REMOVE_THIS)+//;
               $r_in->{$_} = add_antispam($r_in->{$_});
            } #End of if

            push(@line,$r_in->{$_});

         } #End of Foreach

         $line = join("$join_delim",@line);
         $line .= "\n";

      }
      else {
         $line = "$_\n";
      }

      push(@new_data,$line);

   }

   writedata("$password_file_dir/$password_file",\@new_data);

   my @temp_array;

   foreach (keys %{ $r_local->{'login_fields'} }) {
      unless ($_ eq "Password") {
         my $temp_string = join ("::",$_,$r_in->{$_});
            push(@temp_array,"$temp_string\n");
      }
   }
         
   return $error;

}

#======================================================================#
# function register                                                    #
# complete registration process                                        #
#======================================================================#


sub register {

   my ($r_in,$r_local) = @_;
   my ($error);

   if ($r_in->{'Username'} =~ /$split_delim/) {
      my $error = "Your Username cannot contain 
         $split_delim.  Please try again.";
      return $error;
   }

   # Get record according to the Username

   unless ($r_in->{'Password'} eq $r_in->{'dup_Password'}) {
      my $error = "Passwords are not same";
      return $error;
   }
 
   if ($r_in->{'EMail'}) { 
       my ($temp1,$temp2) = split(/\@/,$r_in->{'EMail'});
       if ($r_setup->{'auth_bad_emails'} =~ /$temp2/i) {
       my $error .= qq~
          <b>Invalid Email Account</b><p>
          For security reason, anonymous email addresses are not allowed.<br>
          Please register with non-anonymous email address.<br>~;
          return $error;
       }
   }

   $error = check_dup_user($r_in->{'Username'},$r_local);

   if ($error) {
      return $error;
   }

   # OK, we can now register the user and update the database

   foreach (@{$r_local->{'fields'}}) {

      if ($_ eq "Password") {

      # Following code is from Selena Sol's authentication script
      # This is to keep file format intact

         srand(time|$$);
         my $salt = "";
         my $random = "abcdefghijklmnopqrstuvwxyz1234567890";
         for (1..2) {
            $salt .= substr($random,int(rand(36)),1);
         }

         $r_in->{$_} = my_crypt($r_in->{$_},$salt);

      }
      elsif ($_ eq "Group") {

         unless (-s "$password_file_dir/$password_file" > 0) {
            $r_in->{$_} = 'admin';
         }
         else {
            if ($r_in->{'az'} eq 'admin_create_new_account') {
               $r_in->{$_} = $r_in->{'Group'};
            }
            else {
               $r_in->{$_} = $r_setup->{'auth_default_group'};
            }
         } #End of unless

      }
      elsif ($_ eq "Status") {
         $r_in->{$_} = $r_setup->{'auth_activate_user_on_registration'};
      }
      elsif ($_ eq "EMail") {
         $r_in->{$_} = add_antispam($r_in->{$_});
      }     

      push(@line,$r_in->{$_});
   }

   $line = join("$join_delim",@line);
   appenddata("$password_file_dir/$password_file",$line);

   return 0;

}

#======================================================================#
# function check_dup_user                                              #
# check and make sure username doesn't match the user                  #
#======================================================================#

sub check_dup_user {

  my ($name, $r_local) = @_;
  my $r_data = readdata("$password_file_dir/$password_file");
  my $status;

  foreach (@$r_data) {
    chomp;
    my $r_entry = [ split /$split_delim/ ];
    if ($r_entry->[$r_local->{'login_fields'}->{'Username'}] 
            eq $name) {
        $status = "Duplicate Username: The username you selected
            is already taken.  Please choose another username.";
        return $status;
    }
  }

}

1;
