# auth_lib.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
#
# auth_init
# check_password
# get_login_data
# display_login
#
#======================================================================#
# auth_init                                                            #
# Initialized various authentication values                            #
#======================================================================#
    
sub auth_init {

   my ($r_in,$r_login_fields,$r_form_type) = @_;

   my $r_local = {};
   $r_local->{'fields'} = $r_login_fields;

   #Let's include Username,Password, and Group

   unshift(@$r_login_fields,"Password","Username","Group");
   push(@$r_login_fields,"Status");

   # Let's define form type
   # NOTE: Status is 'hidden' if this is a new user registration

   $r_form_type->{'Username'} = 'text|40|required';
   $r_form_type->{'Password'} = 'password|40|required';
   $r_form_type->{'Group'} = "hidden|$r_local->{'auth'}->{'Default Group'}|required";
   $r_form_type->{'Status'} = 'radio|on|off';

   $r_local->{'form_type'} = $r_form_type;
  
   # Mark off login field locations
   # Needed in subroutines everywhere...
   # $r_in->{$login_field} is a reference to a hash whose
   # keys are the fields and values are the array location
   # $r_local->{'login_info'} is a reference to a hash whose
   # keys are the fields and values are the data read in from
   # the User database
   # $r_in->{'login_data'} is a reference to a hash whose
   # keys are the fields and values are input form values
    
   foreach (@$r_login_fields) {
      $r_local->{'login_fields'}->{$_} = $j;
      $r_local->{'login_info'}->{$_} = '';
      $j++;
   }

   $r_local->{'user_list'} = [];

   # Define Cookie Name

   $r_local->{'cookie_name'} = $cookie_name;

   # Cookie will expire when the session is over
  
   $r_local->{'expires'} = "";
   $r_local->{'domain'} = "";

   return $r_local;

}

#======================================================================#
# check_password                                                       #
# Check user's password                                                #
#======================================================================#

sub check_password {

   my ($r_in,$r_local) = @_;
   my ($error);
   my ($orig_username, $orig_password, $test_password);

   # Get record according to the Username
   # This sets $r_local->{'login_info'}
  
   get_login_data("$password_file_dir/$password_file",$r_in->{'Username'},$r_local);

   $orig_username = $r_local->{'login_info'}->{'Username'};
   $orig_password = $r_local->{'login_info'}->{'Password'};

   $test_password = 
     my_crypt($r_in->{'Password'},$orig_password);

   if (!$orig_username) {
      $error = "Incorrect Username";
      return $error;
   }
   elsif ($orig_password ne $test_password) {
      $error = "Incorrect Password";
      return $error;
   }
   elsif ($r_local->{'login_info'}->{'Status'} ne "on") {
      $error = "Your account is not activated";
      return $error;
   }
   else {   
      foreach (@{$r_local->{'fields'}}) {
         $r_in->{$_} = 
         $r_local->{'login_info'}->{$_};
      }
   }
   return 0;
}

#======================================================================#
# get_login_data                                                       #
# Gets user's information from the user database                       #
#======================================================================#

sub get_login_data {

   my ($password_file,$username,$r_local) = @_;
   my $r_data = readdata($password_file);

   foreach (@$r_data) {
      chomp;
      my $r_entry = [ split /$split_delim/ ];
      if ($r_entry->[$r_local->{'login_fields'}->{'Username'}] 
            eq $username) {
         foreach (keys %{ $r_local->{'login_fields'} }) {
            $r_local->{'login_info'}->{$_} = 
            $r_entry->[$r_local->{'login_fields'}->{$_}];
         }
      }
   }

   $r_local->{'name'} = $username;

   return;

}

#======================================================================#
# display_logon                                                        #
# Display login window                                                 #
#======================================================================#

sub display_logon {

   my ($r_in,$r_local) = @_;

   # First print form tags
   my $html_output .= qq~
   <form method="post">
   <input type="hidden" name="cmd" value="login">
   ~;

   unless ($r_in->{'az'} eq 'user_register') {
      foreach (@{$r_in->{'in_param'}}) {
         if ($r_in->{$_}) {
            $html_output .= qq~
            <input type="hidden" name="$_" value="$r_in->{$_}">
            ~;
         }
      }
   }
   else {
      $html_output .= qq~
         <form method="post">
         <input type="hidden" name="az" value="login">
      ~;
   }

   $html_output .= qq~
   <table border="0" align="center"><tr bgcolor="$bg_color_3">
    <th align="right">
    <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
      Username:</font></th>
    <td><input type="text" name="Username" width="40"></td></tr>
    <tr bgcolor="$bg_color_3">
    <th align="right">
    <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
   Password:</font></th>
    <td><input type="password" name="Password" width="40"></td></tr>~;

  if ($r_setup->{'auth_allow_password_remembering'} eq 'on') {
     $html_output .= qq~
     <tr bgcolor="$bg_color_3"><td align="right">
         <input type="checkbox" name="remember" value="YES">
         </td><td align="left">
        <font size="1" color="$font_color_3" face="$font_face_3">
         Remember Your Password?</font>
         </td></tr>~;
  }
  $html_output .= qq~
  <tr bgcolor="$bg_color_3">
    <td>
    &nbsp;
    </td>
    <td align="left">
      <input type="submit" name="login" value="Login">
    </td></tr>
  </table>
  </form>
~;

}



1;
