# alert.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
#
# This library file contains following functions:
#    alert
#
# Required files:
#    dcforumlib2.pl
#======================================================================#

#======================================================================#
# function alert
# display form for alerting bad posts
#======================================================================#

sub alert {

   my ($r_in,$r_setup) = @_;
   require "$cgilib/dcforumlib2.pl";

   print_header();
   print_header_end();

   # Create menu buttons
   my $menu_button = create_button('help',$r_in,$r_setup);

   my $heading = "Alert forum moderator of a bad posting!!";
   my $sub_heading = qq~
   <B>Thank you for helping us maintain this forum</B><p>
   In order for you to report bad threads to one of our moderators, you must
   be a registered member.  If you have not registered, then please do
   so when the logon screen appear immediately after you submit this form.
   Again, thank you helping us maintain this forum.~;

   my ($omm,$level,$subject,$name,$email,$ltime,$date,$body) = 
         get_record("$maindir/$forum/$thread_dir/$r_in->{'om'}.$thread_ext",$r_in->{'omm'});

   $body = dc_decode($body);
   $body = text_to_form($body);
   $subject = dc_decode($subject);
   $subject = text_to_form($subject);

   my $bad_link;
   
   if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
        $bad_link = "$boardurl?az=show_thread&om=$r_in->{'om'}&forum=$forum";
   }
   else {
         $bad_link = "$mainurl/$forum/$r_in->{'om'}.$ext#$r_in->{'omm'}";
   }

   $html_output .= qq~
   <p>
   <center>
   <form method="post">
     <table border="0" width="$table_width">
      <tr><th align="left" bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
      You have selected following message to alert the administrator
      and the moderator of this forum.
      </font></th>
   </tr>
   <tr><td>
<textarea name="alert_message" rows="12" cols="60" readonly>URL: $bad_link

Message Information:
----------------------------------------------------
Forum: $r_setup->{'forum_name'}->{$forum}
Thread Number: $r_in->{'om'}
Reply Number: $omm (0 = original message)
Thread Subject: $subject
Posted by $name
Posted on $ltime, $date


Posted Message:
----------------------------------------------------
$body

</textarea></td>
   </tr>
   <tr><th align="left" bgcolor="$bg_color_3">
      <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
   Please describe the nature of this message and why you feel it should
   be removed from this forum:
      </font></th>
   </tr>
   <tr><td>
   <textarea name="reason" rows="4" cols="60" wrap="physical"></textarea>
   <input type="hidden" name="om" value="$om">
   <input type="hidden" name="omm" value="$omm">
   <input type="hidden" name="forum" value="$forum">
   <input type="hidden" name="az" value="send_alert">
   <p>
   <FONT SIZE="$font_size_3" FACE="$font_face_3" color="$font_color_3">
   Please do note that if you abuse this system, your account will be
   deactivated.  Click on Submit button below to send this alert.</font>
   <p>
   <input type="submit" value="Yes send alert">
   </td>
   </tr>
   </table>
</center>   </FORM>
   ~;

   return ($heading, $sub_heading, $html_output,$menu_button);

}  

1;