# admin_user_manager.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# admin_user_manager                                                   #
# script for managing user accounts                                    #
#======================================================================#

sub admin_user_manager {

   my ($r_in,$r_setup) = @_;
   my $r_local = {};
   my $az_type;
   my $html_output;

   require "$cgilib/auth_lib.pl";
   require "$cgilib/auth_lib_2.pl";
   $r_local = auth_init($r_in,\@login_fields,\%field_form_type);

   if ($r_in->{'command'} eq 'save') {

      print_header_end();

      my @required = split(/\,/,$r_in->{'required'});
      foreach (@required) {
         unless ($r_in->{$_}) {
            push(@ERROR,$_);
         }
      }
      # Check and see if all required fields are completed
      if (@ERROR) {
         $html_output .= qq~
         <table border="0" width="100%" cellpadding="2">
         <tr bgcolor="$bg_color_3"><td colspan="2">
            <font size="3" color="$font_color_3" face="$font_face_3">
            <b>User Account Management Console</b>
            </font></td></tr>
         <tr bgcolor="$bg_color_3"><td colspan="2">
            <font size="3" color="$font_color_3" face="$font_face_3">
            <b>ERROR: Incomplete Form</b>: <font size="2">You did not submit
            some of the required fields. Please try again.</font>
            </font></td></tr></table>
         ~;
         $html_output .= output_form($r_in,$r_local,$r_setup);
      }

      else {

         if ($r_in->{'sub_action'} eq 'modify') {

            $error = update_user($r_in,$r_local);
            # Now recreate listing of team members
            $r_in->{'Group_type'} = 'team';
            get_user_list($r_in,$r_local,'');
            my @this;

            foreach (@{$r_local->{'user_list'}}) {
               my @fields = @{$_};
               push(@this,"$fields[$r_local->{'login_fields'}->{'Username'}]\n");
            }

            writedata("$password_file_dir/$team_file_name",\@this);

            $status = "The user account has been modified.";

         }

         if ($error) {
            $sub_heading = "$error";
            $html_output = output_form($r_in,$r_local,$r_setup);
         }
         else {
            $html_output .= qq~
               <table border="0" width="100%" cellpadding="2">
               <tr bgcolor="$bg_color_3"><td colspan="2">
                  <font size="3" color="$font_color_3" face="$font_face_3">
                  <b>User Account Management Console</b>
                  </font></td></tr>
               <tr bgcolor="$bg_color_3"><td colspan="2">
                  <font size="3" color="$font_color_3" face="$font_face_3">
                  <b>Status</b>: <font size="2">$status</font>
                  </font></td></tr></table>
               ~;
         }
      } 

      return $html_output;
  
   } # end of if commend eq save

   
   elsif ($r_in->{'command'} eq "list") {
  
      if ($r_in->{'sub_action'} eq 'activate') {
         get_user_list($r_in,$r_local,'off');
         $input_type = "checkbox";
      }
      elsif ($r_in->{'sub_action'} eq 'deactivate') {
         get_user_list($r_in,$r_local,'on');      
         $input_type = "checkbox";
      }
      elsif ($r_in->{'sub_action'} eq 'remove') {
         get_user_list($r_in,$r_local,'');      
         $input_type = "checkbox";
      }
      else {
         get_user_list($r_in,$r_local,'');      
         $input_type = "radio";
      }
    
      $html_output .= qq~
      <form method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="sub_action" value="$r_in->{'sub_action'}">
      <input type="hidden" name="command" value="doit">
      <table border="0" width="100%" cellpadding="2">
      <tr bgcolor="$bg_color_3"><td colspan="6">
         <font size="3" color="$font_color_3" face="$font_face_3">
         <b>User Account Management Console</b>:<font size="$font_size_3">
         <br>Choose from following user accounts to $r_in->{'sub_action'} them.</font>
         </font></td></tr>
      <tr bgcolor="$bg_color_0"><th valign="top">
         <font size="$font_size_0" color="$font_color_0" face="$font_face_0">
      Select</font></th>
      ~;

      # Here, let's only display the first five fields...
      # Do not display password

      foreach (@{ $r_local->{'fields'} }[1..5]) {
         $html_output .= qq~
           <th valign="top" bgcolor="$bg_color_0"><font 
           size="$font_size_0" color="$font_color_0" face="$font_face_0">
           $_&nbsp;</font></th>
         ~;
      }
 
      $html_output .= "</tr>\n";
      my $users;

      toggle_color('reset');
      foreach (@{$r_local->{'user_list'}}) {
         toggle_color();
         $users = "yes";
         my @fields = @{$_};
         $html_output .= qq~
            <tr bgcolor="$bgcolor"><td valign="top"><font 
           size="$font_size" color="$font_color" face="$font_face">
            <input type="$input_type" name='user_selected'
               value="$fields[$r_local->{'login_fields'}->{'Username'}]">
               </font></td>
         ~;
      
         foreach $field (@{ $r_local->{'fields'} }[1..5]) {
         $html_output .= qq~
           <td valign="top"><font 
           size="$font_size" color="$font_color" face="$font_face">
           $fields[$r_local->{'login_fields'}->{$field}]
           &nbsp;</font>
           </td>
         ~;
         }

         $html_output .= "</tr>\n";
      }
    
      unless ($users) {
         $html_output .= qq~
         <tr bgcolor="$bgcolor">
           <th colspan="7" align="center"><font 
           size="$font_size" color="$font_color" face="$font_face">
           There are no usernames that match your criteria!!!
            </font>
           </th>
         </tr>
         ~;
      }

       $html_output .= qq~
      <tr bgcolor="$bg_color_3">
         <td colspan="6" align="center">
         <input type="submit" value="Submit">
         <input type="reset" value="Reset">
         </td>
       </tr>
       </table>
       </form>~;
    
   } # End of commend eq list - lists users

   elsif ($r_in->{'command'} eq "doit") {

      if ($r_in->{'sub_action'} eq 'modify') {

         get_login_data("$password_file_dir/$password_file",$r_in->{'user_selected'},$r_local);

         foreach (keys %{$r_local->{'login_info'}} ) {
            if ($_ eq "EMail") {
               $r_in->{$_} = remove_antispam($r_local->{'login_info'}->{$_});
            }
            else {
               $r_in->{$_} = $r_local->{'login_info'}->{$_};
            }
         }

         $html_output .= qq~
            <table border="0" width="100%" cellpadding="2">
            <tr bgcolor="$bg_color_3"><td colspan="2">
               <font size="3" color="$font_color_3" face="$font_face_3">
               <b>User Account Management Console</b>
               </font></td></tr>
            <tr bgcolor="$bg_color_3"><td colspan="2">
               <font size="3" color="$font_color_3" face="$font_face_3">
               <b>Modify User Account</b>: <font size="2">Modify user account
               using the form below.</font>
               </font></td></tr></table>
            ~;

         $html_output .= output_form($r_in,$r_local,$r_setup);
         return $html_output;
      }


      my @user_selected = split(/\0/,$r_in->{'user_selected'});
      $r_in->{'user'} = 'all';
      get_user_list($r_in,$r_local,'');

      my @rowdata;
    
      foreach (@{$r_local->{'user_list'}}) {

      my @fields = @{$_};
      my $hit = "";

      foreach (@user_selected) {

          if ($fields[$r_local->{'login_fields'}->{'Username'}] eq $_) {

            $hit = "yes";
            my $r_mesg = readdata("$password_file_dir/$account_action_file");
            my $mail_subject = shift(@{$r_mesg});
            my $mail_message = join("",@{$r_mesg});
            $mail_message =~ s/\r//g;
            my $account_action;

            if ($r_in->{'sub_action'} eq 'activate') {
               $az_type = "Activate User Account - The user accounts 
                  you selected have been activated.";
               $account_action = "You're account has been activated";
               $fields[-1] = 'on';
               my $temp = join("$join_delim",@fields);
               push(@rowdata,"$temp\n");  
             }
             elsif ($r_in->{'sub_action'} eq 'deactivate') {   
               $az_type = "Deactivate User Account - The user accounts 
                  you selected have been deactivated";
               $account_action = "You're account has been deactivated";
               $fields[-1] = 'off';
               my $temp = join("$join_delim",@fields);
               push(@rowdata,"$temp\n");
             }
             elsif ($r_in->{'sub_action'} eq 'remove') {

               $az_type = "Remove User Account - The user accounts you 
                  selected have been removed.";
               $account_action = "You're account has been deleted.";
               if (-e "$logdir/$_\.log") {
                  unlink("$logdir/$_\.log");
               }
             }

            $mail_message =~ s/ACCOUNT_CHANGE/$action/g;

             if ($r_setup->{'auth_notify_user_on_activation'} eq "on") {
                  send_mail($password_file_dir, $r_setup->{'auth_sendmail_path'},
                  $r_setup->{'auth_admin_email_address'},
                  $fields[$r_local->{'login_fields'}->{'EMail'}],
                  $mail_subject,$mail_message);
             }
         }
      }
      
      unless ($hit) {
        my $temp = join("$join_delim",@fields);
        push(@rowdata,"$temp\n");
      }

    }
    
    writedata("$password_file_dir/$password_file",\@rowdata);

   $html_output .= qq~
      <table border="0" width="100%" cellpadding="2">
      <tr bgcolor="$bg_color_3"><td colspan="2">
         <font size="3" color="$font_color_3" face="$font_face_3">
         <b>User Account Management Console</b>
         </font></td></tr>
      <tr bgcolor="$bg_color_3"><td colspan="2">
         <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
         <b>$az_type</b>
         </font></td></tr></table>
      ~;

  }

   else {

      $html_output .= qq~
      <form method="post">
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="list">
      <table border="0" width="100%" cellpadding="2">
      <tr bgcolor="$bg_color_3">
       <td colspan="2" >
      <font size="3" color="$font_color_3" face="$font_face_3">
        <b>Forum User Account Manager</b>
        <font size="$font_size_3">
        <br>Modify existing user accounts
        </font></font></td></tr>
    <tr bgcolor="$bg_color_3"><td colspan="2">
      <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
      <b>Manage Existing User Accounts</b>
      <font size="$font_size_3">
      <br>Managing user accounts is a two step process:
      <li>Step 1, reduce the user list by selecting the first letter
        of the username. To list entire user database, select 'All'.
      <li>Step 2. select function to perform.</font></font></td>
    </tr>
    <tr><th align="right" valign="top" bgcolor="$bg_color_3">
         <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
      Step&nbsp;1.</font></th>
      <td bgcolor="$bg_color_3">
      <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
      <b>Reduce account list</b> by selecting the first
      character of your Username begins with:
      <select name="user">
      <option value="all" selected>All
      <option value="a">a or A
      <option value="b">b or B
      <option value="c">c or C
      <option value="d">d or D
      <option value="e">e or E
      <option value="f">f or F
      <option value="g">g or G
      <option value="h">h or H
      <option value="i">i or I
      <option value="j">j or J
      <option value="k">k or K
      <option value="l">l or L
      <option value="m">m or M
      <option value="n">n or N
      <option value="o">o or O
      <option value="p">p or P
      <option value="q">q or Q
      <option value="r">r or R
      <option value="s">s or S
      <option value="t">t or T
      <option value="u">u or U
      <option value="v">v or V
      <option value="w">w or W
      <option value="x">x or X
      <option value="y">y or Y
      <option value="z">z or Z
      <option value="0">0
      <option value="1">1
      <option value="2">2
      <option value="3">3
      <option value="4">4
      <option value="5">5
      <option value="6">6
      <option value="7">7
      <option value="8">8
      <option value="9">9
      <option value="other">Other
      </select></font>
      </td>
    </tr>
    <tr><th align="right" valign="top" bgcolor="$bg_color_3">
      <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
      Step&nbsp;2.</font></th>
      <td bgcolor="$bg_color_3">
         <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
        <input type="radio" name="sub_action" value="activate">
        <b>Activate user accounts:</b> Selecting 'All' will list
        every user accounts that are currently deactivated
        <br>
        <input type="radio" name="sub_action" value="deactivate">
        <b>Deactivate user accounts:</b> Selecting 'All' will list
        every user accounts that are currently activated
        <br>
        <input type="radio" name="sub_action" value="remove">
        <b>Remove user accounts:</b> Narrow your search to list
        only a partial listing of user database (faster download).
        <br>
        <input type="radio" name="sub_action" value="modify" checked>
        <b>Modify user accounts:</b> Narrow your search to list
          only a partial listing of user database (faster download).
          </font>
      </td>
    </tr>
    <tr bgcolor="$bg_color_3">
      <td colspan="2" align="center">
      <input type="submit" value="Submit">
      <input type="reset" value="Reset">
      </td>
    </tr>
    </table>
    </form>~;
    
  }

  return $html_output;
}


###
### subroutine get_user_list
### Read in all the username and password
### Used for user management
###

sub get_user_list {

   my ($r_in,$r_local,$status) = @_;

   my $r_data = readdata("$password_file_dir/$password_file");

   # If Group_type is specified, then pull of all the
   # users with this group type

   if ($r_in->{'Group_type'} eq 'team') {
      foreach (@$r_data) {
         chomp;
         my $r_entry = [ split(/$split_delim/,$_) ];
         unless ($r_entry->[$r_local->{'login_fields'}->{'Group'}]
            eq 'normal' or $r_entry->[$r_local->{'login_fields'}->{'Group'}] eq 'member') {
               push( @{$r_local->{'user_list'} }, $r_entry);
         }
   
      }#End of foreach  
   }
   elsif ($r_in->{'Group_type'}) {

      foreach (@$r_data) {
         chomp;
         my $r_entry = [ split /$split_delim/ ];
         if ($r_entry->[$r_local->{'login_fields'}->{'Group'}]
            eq $r_in->{'Group_type'}) {
               push( @{$r_local->{'user_list'} }, $r_entry);
         }
   
      }#End of foreach  
   }
   else {

      foreach (@$r_data) {
         chomp;
         my $r_entry = [ split /$split_delim/ ];
       
         if ($status ne "" &&
            $r_entry->[$r_local->{'login_fields'}->{'Status'}] eq $status) {
   
            if ($r_in->{'user'} eq 'all') {
               push( @{$r_local->{'user_list'} }, $r_entry);
            }
            else {
               if ($r_entry->[$r_local->{'login_fields'}->{'Username'}]
               =~ /^$r_in->{'user'}/i) {
                  push( @{$r_local->{'user_list'} }, $r_entry);
               }
            }
         }
         elsif ($status eq "") {
   
            if ($r_in->{'user'} eq 'all') {
               push( @{$r_local->{'user_list'} }, $r_entry);
            }
            else {
               if ($r_entry->[$r_local->{'login_fields'}->{'Username'}]
                  =~ /^$r_in->{'user'}/i) {
                  push( @{$r_local->{'user_list'} }, $r_entry);
               }
            }
   
         }#End of if ($status...
   
      }#End of foreach

   }
}


1;
