# admin_update_threads.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# admin_update_threads                                                 #
# script for updating threads                                          #
#======================================================================#
sub admin_update_threads {

   my ($r_in,$r_setup) = @_;

   print_header();
   print_header_end();

   print qq~
   <html><head>
   <META HTTP-EQUIV="Refresh" CONTENT="5; URL=$adminurl">
   </head><body>
   $header
   $menu
   $sub_header
            <font size="3" face="$font_face_4" color="$font_color_4">
            <b>Updating all threads...please wait.</b>
            </font>
            <hr>
            <font size="$font_size_4" face="$font_face_4" color="$font_color_4">
   ~;


   foreach (@{$r_setup->{'forums'}}) {

      print qq~
      <font size="2">Processing threads in $r_setup->{'forum_name'}->{$_} forum.....
      <br>
      ~;

      my $datadir = $maindir;
      my $r_data = [];

      $forum = $_;
      if ($r_setup->{'forum_type'}->{$_} eq "Private") {
         $datadir = $privatedir;
      }

      my $datafile = "$datadir/$forum";

      $r_data = readdata("$datafile/$database");

      foreach (@{$r_data}) {
         $r_in->{'lock'} = '';
         chomp;
         my ($num,$date,$localtime,$name,$subject,$caption,$lock,$read,
            $user_rating,$replies) = split /$split_delim/;
         if (-e "$datadir/$forum/$thread_dir/$num\.$thread_ext") {
            if ($lock eq "on") {
               $r_in->{'lock'} = "on";
            }
            $r_in->{'om'} = $num;
            create_message($r_in,$r_setup);
         }   
      }

      $r_data = [];

      $r_data = readdata("$datafile/arc_$database");
      $r_in->{'archive'} = 'yes';
      foreach (@{$r_data}) {
         chomp;
         my ($num,$date,$localtime,$name,$subject,$caption,$lock,$read,
            $user_rating,$replies) = split /$split_delim/;
         if (-e "$datadir/$forum/$thread_dir/$num\.$thread_ext") {
            $r_in->{'om'} = $num;
            create_message($r_in,$r_setup);
         }   
      }
      delete ($r_in->{'archive'});

      print qq~
      .....Finished updating threads in $r_setup->{'forum_name'}->{$_} forum.</font><br>
      ~;

   }


   print qq~
   <hr>
   <font size="3"><b>Updating threads completed.  
      Taking you to the admin utility now...</b></font>
   ~;

   print "</font></body></html>";

   exit(0);
}

1;


