# admin_send_subscription.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_send_subscription                                              #
# admin utility for sending subscription                               #
#=====================================================================#

sub admin_send_subscription {

   my ($r_in,$r_setup) = @_;
   my $html_output;
   my $r_data = {};
   my $r_local = {};
   my %output;
   my %user_list;
   my %email_list;

   print_header();
   print_header_end();

   # read in user and their forum subscriptions
   $r_data = readdata("$password_file_dir/$subscription_list");

   
   foreach $line (@{$r_data}) {
      chomp ($line);
      my ($user,$forums) = split (/$split_delim/,$line);
      my @forums = split(/,/,$forums);
      if (@forums) {
         foreach (@forums) {
            push(@{$user_list{$user}},$_);
         }
      }  
   }

# Debug routine
#  foreach (keys %user_list) {
#     print "$_: @{$user_list{$_}}<BR>";
#  }
#  exit; 

   # read in user's email addresses
   $r_data = readdata("$password_file_dir/$password_file");
   foreach $line (@{$r_data}) {
      chomp ($line);
      my @fields = split (/$split_delim/,$line);
      $fields[5] = remove_antispam($fields[5]);
      $email_list{$fields[1]}=$fields[5];
   }

# Debugging routine...  
#  foreach (keys %email_list) {
#     print "$_: $email_list{$_}<BR>";
#  }
#  exit;

   # prepare all messages for output
   $r_data = readdata("$password_file_dir/$subscription");

   foreach (@{$r_data}) {
      chomp;
      my ($forum_id,$om,$omm,$ldate,$ltime,$name,$email,
            $subject,$body) = split /$split_delim/;
      $subject = dc_decode($subject);
#     $body = dc_decode($body);
#     $body = text_to_form($body);
      my $temp = "\"$subject\"\n";
      $temp .= "     Posted by $name on $ldate $ltime\n";
      $temp .= "     $mainurl/$forum_id/$om.$ext#$omm\n\n";
#     $temp .= "$body\n";
#     $temp .= ".............................................................\n";
      $output{$forum_id} .= $temp;
   }

   my %user_message;

   # For each user, create user message
   # by appending subscription message
   # sorted by forums
   foreach $user (keys %user_list) {
      foreach (@{$user_list{$user}}) {
         if ($output{$_}) {
            $user_message{$user} .= "Messages posted in $r_setup->{'forum_name'}->{$_}\n";
            $user_message{$user} .= "===========================================================\n";
            $user_message{$user} .= $output{$_};
         }
      }
   }  

   my $r_mesg = readdata("$password_file_dir/$subscription_message_file");
   my $mail_subject = shift(@{$r_mesg});
   my $mail_message = join("",@{$r_mesg});
   $mail_message =~ s/\r//g;

   # Send subscription to each user
   foreach (keys %user_list) {
      if ($email_list{$_} and $user_message{$_}) {
         my $message = $mail_message . "\n";
         $message .= ,$user_message{$_};
         send_mail($password_file_dir, 
            $r_setup->{'auth_sendmail_path'},
            $r_setup->{'auth_admin_email_address'},$email_list{$_},
            $mail_subject, $message);
      }
   }


   # Delete subscription file
   unlink("$password_file_dir/$subscription") or
      my_die("Can't delete $password_file_dir/$subscription",$!);

   $html_output = print_status("Subscription has successfully been sent!");   
   
}

1;