# admin_remove_session_files.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_remove_session_files                                           #
# admin utilty for removing session files                              #
#======================================================================#

sub admin_remove_session_files {

   my ($r_in,$r_setup) = @_;
   my @temp =();
   my $output;

   opendir(D,"$sessiondir") or
      my_die("In dcadmin.cgi:: remove_session files, Couldn't open $sessiondir",$!);
      while ($file = readdir(D)) {
      if ($file =~ /.session/) {
         unless ($r_in->{'what'}) {
            unless ($file =~ /^\%\%/) {
               unlink("$sessiondir/$file") if (-M "$sessiondir/$file" > 1);
            }
         }
         else {
            unlink("$sessiondir/$file") if (-M "$sessiondir/$file" > 1);
         }
      }
   }

   closedir(D);
   
   $output = print_status("Session files were cleaned up...");
   return $output;

}

1;