# admin_remove_messages.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_remove_messages                                                #
# admin utility for removing messages                                  #
#======================================================================#
sub admin_remove_messages {

   my($datafile,$r_in,$r_setup) = @_;
   my $html_output = "";

   my $r_rowdata = readdata("$datafile");

   my @num_selected = split(/\0/,$r_in->{'selected'});
   my $num_selected = @num_selected;

   foreach $num (@num_selected) {
      foreach ($j = 0;$j < @$r_rowdata;$j++) {
         if ($r_rowdata->[$j] =~ /^$num$split_delim/) {
             splice(@{$r_rowdata}, $j, 1);
             $j--;
         }
      }
   }

   writedata($datafile,$r_rowdata);

   $r_in->{'om'} = $r_in->{'thread_select'};
   create_message($r_in,$r_setup);

   $r_rowdata = readdata("$maindir/$forum/$database");
   foreach ($j=0;$j<@$r_rowdata;$j++) {
      if ($r_rowdata->[$j] =~ /^$thread_select$split_delim/) {
          $row = $r_rowdata->[$j];
          chomp($row); 
          my ($num,$date,$ltime,$name,$subject,$caption,$lock,$read,
            $user_rating,$replies) = split(/$split_delim/, $row);
          my $new_num = $replies - $num_selected;
          $r_rowdata->[$j] = join("$join_delim",$num,$date,$ltime,$name,$subject,
            $caption,$lock,$read,$user_rating,$new_num);
          $r_rowdata->[$j] .= "\n";
         next;
      }
   }

   # Update database.txt
   writedata("$maindir/$forum/$database",$r_rowdata);

   # Update number of messages
   unless ($r_in->{'archive'}) {
      $r_setup->{'forum_posts'}->{$forum} = $r_setup->{'forum_posts'}->{$forum} - $num_selected;
      save_forum_info("$password_file_dir/$forum_file",$r_setup);
   }
   
   my $num_list = join("\, ",@num_selected);
   $html_output .= qq~
   <table border="0" cellpadding="3" width="100%">
      <tr>
        <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
         <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Selected File</font>
         </th>
        <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
         <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Removed Messages</font>
         </th>
      </tr>
      <tr>
        <Td ALIGN="CENTER" BGCOLOR="$bg_color_2">
         <font size="$font_size_2" face="list_font_face" color="$font_color_2">
         $thread_select</font>
         </td>
        <Td ALIGN="CENTER" BGCOLOR="$bg_color_2">
         <font size="$font_size_2" face="$font_face_2_face" color="$font_color_2">
         $num_list</font>
         </td>
      </tr>
      <tr>
        <Td ALIGN="CENTER" BGCOLOR="$bg_color_0" colspan="2">
         &nbsp;
         </td>
      </tr>
   </table>
  <hr size="1">
  </CENTER>
   ~;

   if ($ENV{'HTTP_REFERER'} =~ /$boardurl/i or
       $ENV{'HTTP_REFERER'} =~ /$mainurl/i) {
      print "Location: $boardurl?az=list&forum=$forum\n\n";
   }
   else {
      print_header();
   }

   $html_output;

}

1;