# admin_recover.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_recover                                                        #
# admin utility for recovering from forum backup files                 #
#======================================================================#

sub admin_recover {

   my ($r_in,$r_setup) = @_;
   my $html_output;
   print_header();
   print_header_end();

   my %files = (
      conf_file => $conf_file,
      forum_file => $forum_file,
      board_setup_file => $board_setup_file,
      password_file => $password_file,
      ip_file => $ipfile,
      bad_ip_file => $bad_ip_list,
      subscription_list => $subscription_list,
      forum_log_file => $logfile
   );
   
   if ($r_in->{'command'}) {

      my $process_forum_file = '';
      my $output = "Following files have been recovered from backup.<p>";
      $output .= "<font size=2>";

      my @recover_files = split(/\0/,$r_in->{'recover_file'});

      foreach (@recover_files) {
         if ($_ eq 'forum_file') {
            $process_forum_file = 'yes';
         }
         if (-e "$password_file_dir/$files{$_}") {
            my $r_data = readdata("$password_file_dir/$files{$_}.bck");
            writedata("$password_file_dir/$files{$_}",$r_data);
            $output .= "<dd>$files{$_}";
         }
         else {
            $output .= "<dd>$files{$_} could not be recovered...can't find the backup.";
         }
      }

      if ($process_forum_file) {
         $output .= "<hr>In addition, forum_info.txt was rebuilt from the database files.";
         $r_setup->{'forums'} = [];
         # For forum_info.txt, recover active threads and messages
         get_forum_info("$password_file_dir/$forum_file",$r_setup);
         
         foreach (@{$r_setup->{'forums'}}) {
            my $thread_count = 0;
            my $message_count = 0;
            my $arc_count = 0;
            my $r_data = [];
            my $thisdir = $maindir;
            if ($r_setup->{'forum_type'}->{$_} eq 'Private') {
               $thisdir = $privatedir;
            }
            $r_data = readdata("$thisdir/$_/$database");
            foreach (@{$r_data}) {
               chomp;
               my @fields = split /$split_delim/;
               if (@fields) {
                  $thread_count++;
                  $message_count = $fields[9] + 1 + $message_count;
               }
            }
            $r_setup->{'forum_threads'}->{$_} = $thread_count;
            $r_setup->{'forum_posts'}->{$_} = $message_count;
      
            $r_data = [];
            $r_data = readdata("$thisdir/$_/arc_$database");
            $r_setup->{'forum_archive'}->{$_} = @{$r_data};
         }
         save_forum_info("$password_file_dir/$forum_file",$r_setup);
      }

   
      $output .= "</font>";
      $html_output = print_status($output);

   }
   else {


      $html_output .= qq~
      <FORM ACTION="$adminurl" METHOD=POST>
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="recover">
      <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
         <TR>
            <TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Select
            </font>
            </TH>
            <TD BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Files to recover from backup
            </font>
            </TD>
         </TR>~;
         
      foreach (keys %files) {
         $html_output .= qq~
         <TR>
               <TD BGCOLOR="$bg_color_2" ALIGN="LEFT" VALIGN="TOP">
               <font size="$font_size_2" face="$font_face_2" color="$font_color_2">
               <input type="checkbox" name="recover_file" value="$_">
               </font></TD>
               <TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="TOP" width="100%">
               <font size="$font_size_1" face="$font_face_1" color="$font_color_1">
               $files{$_}
               </font>
               </TD>
            </TR>
         ~;
      }


      $html_output .= qq~
               <TR>
            <TD BGCOLOR="$bg_color_2" ALIGN="LEFT" VALIGN="TOP" colspan="3">
            <font size="$font_size_2" face="$font_face_2" color="$font_color_2">
            <input type="submit" value="Select">
            <input type="reset" value="Reset">
            </font></TD>
         </TR></table></Form>
      ~;

   }
   return $html_output;
}

1;