# admin_rebuild_database.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_rebuild_database                                               #
# admin utility for rebuilding database                                #
#======================================================================#

sub admin_rebuild_database {

   my ($r_in,$r_setup) = @_;
   my $r_arc = [];
   my $r_data = {};
   my $r_records = {};
   my $r_orig_records = {};
   my $r_lock = {};
   my $r_user_rating = {};
   my $r_num_read = {};
   my $r_nums = {};
   my $f_dir;
   my @A;

   print_header();
   print_header_end();

   my $forum = $r_in->{'forum'};

   # Determine if the forum is a private forum
   if ($r_setup->{'forum_type'}->{ $forum } eq 'Private') {
      $f_dir = $privatedir;
   }
   else {
      $f_dir = $maindir;
   }

   #first read in all the lines of data
   opendir(D,"$f_dir/$forum/Data") or my_die("Can't open $f_dir/$forum/Data", $!);

   # So long as there is a file in this directory...
   while ($file = readdir(D)) {

      # If the file ends in .txt
      if ($file =~ /(.*)\.txt/) {

         my $file_num = $1;         
         my $r_lines = readdata("$f_dir/$forum/Data/$file");
         my $num_lines = @{$r_lines};
         my $first_line, $num, $user_rating, $num_read;
         $first_line = shift( @{$r_lines} );
         chomp($first_line);

         # following unless statement is needed for
         # backward compatibility
         unless ($first_line =~ /\|/) {
            $num = $first_line;
            $user_rating = '';
            $lock = '';
            $num_read = 0;
         }
         else {
            ($num,$lock,$user_rating,$num_read) = split( /$split_delim/,$first_line);
         }
         
         my $j = -1;
         my $last_num = 0;
         foreach (@{$r_lines}) {
            $j++;
            chomp;
            $row{$j} = $_;
            @temp = split /$split_delim/;
            $last_num = $j if ($temp[0] > $last_num);
         }

         $r_records->{$file_num} = $row{$last_num};
         $r_orig_records->{$file_num} = $row{0};
         $r_user_rating->{$file_num} = $user_rating;
         $r_num_read->{$file_num} = $num_read;
         $r_lock->{$file_num} = $lock;
         $r_nums->{$file_num} = $num_lines-2;
      }
   }

   closedir(D);
   
   # Read-in data from the archive
   # Use this data to distinguish current topic
   # from the archive topic
   $r_arc = readdata("$f_dir/$forum/arc_database.txt");
   foreach $key (keys %{$r_records}) {

      my $arc = '';

      foreach $line (@{$r_arc}) {
         if ($line =~ /^$key$split_delim/) {
            $arc = 'yes';
         }
      }

      unless ($arc) {
         my $line = $r_records->{$key};
         my @temp = split(/$split_delim/,$r_records->{$key});
         my ($h,$m,$s) = split(/:/,$temp[5]);
         my ($mo,$da,$ye) = split(/\//,$temp[6]);
         my $int = 24*3600*($ye*370 + $mo*31 + $da) + $h*3600 + $m*60 + $s;
         my @temp2 = split(/$split_delim/,$r_orig_records->{$key});
         my $caption = substr($temp2[7],0,150);
         $caption =~ s/<([^>]|\n)*>//g;
         $r_data->{$int} = join("$join_delim",
            $key,$temp[6],$temp[5],$temp2[3],$temp2[2],$caption,$r_lock->{$key},
               $r_num_read->{$key},$r_user_rating->{$key},$r_nums->{$key} );
      }
   }

   foreach (reverse sort keys %{$r_data}) {
      push(@A,"$r_data->{$_}\n");
   }

   # Write it back to database file
   writedata("$f_dir/$forum/$database",\@A);
   $html_output = print_status("$f_dir/$forum/$database has been recreated!");

}

1;