# admin_queue.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_queue                                                          #
# admin utility for managing queued messages                           #
#======================================================================#

sub admin_queue {

   require "$cgilib/add_message.pl";
   require "$cgilib/update_thread.pl";
   require "$cgilib/update_database.pl";
   require "$cgilib/email_notification.pl";

   
   my ($r_in,$r_setup) = @_;
   my $r_data = readdata("$password_file_dir/$queue");
   my $html_output;
   my @unqueue_list = split(/\0/,$r_in->{'unqueue'});
   my @delete_list = split(/\0/,$r_in->{'delete'});
   my @DELETED, @UNQUEUE;
   print_header();
   print_header_end();

   if ($r_in->{'subcommand'} eq 'doit') {

      for ($j=0;$j<@{$r_data};$j++) {
         my $row = $r_data->[$j];
         chomp($row);
         my ($forumid,$om,$omm,$ldate,$ltime,$name,$subject,$body) = split (/$split_delim/, $row);
         if ($r_in->{'forum'} eq $forumid) {
            foreach (@delete_list) {
               my ($dom,$domm,$ddate,$dtime) = split /$split_delim/;
               if ($dom == $om and 
                   $domm == $omm and
                   $ddate eq $ldate and 
                   $dtime eq $ltime) {
                  push(@DELETED,$row);
                  splice(@{$r_data},$j,1);
                  $j--;
               }
            }#End of foreach

            foreach (@unqueue_list) {
               my ($dom,$domm,$ddate,$dtime) = split /$split_delim/;
               if ($dom == $om and 
                   $domm == $omm and 
                   $ddate eq $ldate and 
                   $dtime eq $ltime) {
                  push(@UNQUEUE,$row);
                  splice(@{$r_data},$j,1);
                  $j--;
               }
            }#End of foreach
         }
      }

      # Update message queue list      
      writedata("$password_file_dir/$queue",$r_data);

      # For each messages unqueued, update threads and create messages
      foreach (@UNQUEUE) {
         my ($forumid,$om,$omm,$ldate,$ltime,$name,$email,$subject,$body) = split /$split_delim/;
         $r_in->{'forum'} = $forumid;
         $r_in->{'om'} = $om;
         $r_in->{'omm'} = $omm;
         $r_in->{'subject'} = $subject;
         $r_in->{'name'} = $name;
         $r_in->{'email'} = $email;
         $r_in->{'ltime'} = $ltime;
         $r_in->{'date'} = $ldate;
         $r_in->{'body'} = $body;
         $r_in->{'body'} =~ s/&pip;/$split_delim/g;
         $r_in->{'subject'} =~ s/&pip;/$split_delim/g;         
         if ($r_in->{'omm'} < 0) {
            $r_in->{'omm'} = 0;
            add_message("$maindir/$r_in->{'forum'}/$database",$r_in,$r_setup);
            create_thread($r_in,$r_setup);
         }
         else {
            update_database("$maindir/$r_in->{'forum'}/$database",$r_in);
            update_thread($r_in,$r_setup);
         }

         create_message($r_in,$r_setup);

      } #For each

      $html_output = print_status("Messages in queue have 
         been sucessfullly unqueued or deleted");

   }
   else {
      $html_output .= qq~
      <FORM METHOD=POST>
      <INPUT TYPE="HIDDEN" NAME="az" VALUE="$r_in->{'az'}">
      <INPUT TYPE="HIDDEN" NAME="command" VALUE="$r_in->{'command'}">
      <INPUT TYPE="HIDDEN" NAME="subcommand" VALUE="doit">
      <INPUT TYPE="HIDDEN" NAME="forum" VALUE="$r_in->{'forum'}">
      <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
         <TR><TD COLSPAN="5" ALIGN="left" bgcolor="$bg_color_3">
            <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
            <font size="3"><b>Unqueue messages in $r_in->{'forum'} forum</font></b><br>
            Select messages to unqueue
            </font></TD></TR></table>
      <TABLE BORDER="0" CELLPADDING="1" WIDTH="100%">
         <TR><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" width="80">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Unqueue</font></TH>
            <TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" width="80">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Delete</font></TH><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" width="90">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Author</font>
            </TH><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" WIDTH="100%">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Subject and Body</font></TH></TR>~;
   
      toggle_color('reset');
      foreach (@$r_data) {
         chomp;
         my ($forumid,$om,$omm,$ldate,$ltime,$name,$email,$subject,$body) = split /$split_delim/;
         $body = text_to_html($body);
         if ($r_in->{'forum'} eq $forumid) {
            my $num = join("$join_delim",$om,$omm,$ldate,$ltime);
            $html_output .=qq~
            <TR><TD VALIGN="TOP" ALIGN="RIGHT" BGCOLOR="$bg_color_2">
            <INPUT TYPE="checkbox" NAME="unqueue" VALUE="$num"></TD>
            <TD VALIGN="TOP" ALIGN="RIGHT" BGCOLOR="$bg_color_2">
            <INPUT TYPE="checkbox" NAME="delete" VALUE="$num"></TD>
                  <TD  ALIGN="CENTER" BGCOLOR="$bg_color_2"  VALIGN="TOP">
            <font size="$font_size_2" face="$font_face_2" color="$font_color_2">
            $name</FONT></TD>      
            <TD BGCOLOR="$bgcolor" VALIGN="TOP" ALIGN="LEFT"><font 
            size="$font_size" face="$font_face" color="$font_color">
            <b>"$subject"</b>
            <blockquote>
            $body
            </blockquote>
            </FONT></TD></TR>~;
         }
         toggle_color();
      }
   
      $html_output .=qq~
      <TR><TD ALIGN="left" colspan="4" VALIGN="TOP" bgcolor="$bg_color_3">
      <INPUT TYPE="SUBMIT" VALUE="Submit"> 
      <INPUT TYPE="RESET" VALUE="Reset Form">
      </TD></TR>
      </TABLE>
      </FORM>
       ~;
   }

   $html_output;
}

1;