# admin_private_forum_users.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#================================================================
# admin_private_forum_users.pl
# User manager for private forums
# This function is used by the moderators to add/remove users
# to their forums
#================================================================

sub admin_private_forum_users {

   my ($r_in,$r_setup) = @_;

   my $html_output = '';
                        
   if ($r_in->{'b_add'}) {
      $r_in->{'command'} = 'list';
   }
   elsif ($r_in->{'b_addall'}) {
      $r_in->{'command'} = 'update';
      $r_in->{'users'} = 'all';
   }

   if ($r_in->{'command'} eq 'update') {
      
      unless ($r_in->{'users'} eq 'all') {

         # put users selected into an array
         my @users = split(/\0/,$r_in->{'users'});

         # need to the following to add a line return to
         # every element
         # soley needed to use writedata
      
         for ($j=0;$j<@users;$j++) {
            chomp($users[$j]);
            $users[$j] .= "\n";
         }

         writedata("$password_file_dir/$r_in->{'forum'}.$priv_user_ext",\@users);

         $html_output = "";
         $html_output .= qq~
         <font size="3" face="$font_face_3" color="$font_color_3">
         <b>Forum user list has been updated!</b></font>
         ~;

      }
      else {

         get_members($r_in);
         my @users;
         foreach (@{$r_in->{'user_list'}}) {
           push(@users,"$_\n");
         }

         if (-e "$password_file_dir/$forum.$priv_user_ext") {
            $r_members = readdata("$password_file_dir/$r_in->{'forum'}.$priv_user_ext");
         }
         else {
            check_datafile("$password_file_dir/$r_in->{'forum'}.$priv_user_ext");
         }
         writedata("$password_file_dir/$r_in->{'forum'}.$priv_user_ext",\@users);

         $html_output = "";
         $html_output .= qq~
         <center>
         <font size="3" face="$font_face_2" color="$font_color_2">
         <b>Forum user list has been updated!</b></font>
         <p>~;

      }

   }
   elsif ($r_in->{'command'} eq 'list') {

   #  unless ($r_in->{'forum'}) {
   #     print_header_end();
   #     ("You forget to select a forum.<br>Please go back and try again.");
   #     exit;
   #  }

      get_members($r_in);

      my @user_list;
      foreach (@{$r_in->{'user_list'}}) {
           push(@user_list,"$_");
      }
      
      if (-e "$password_file_dir/$forum.$priv_user_ext") {
         $r_members = readdata("$password_file_dir/$r_in->{'forum'}.$priv_user_ext");
      }
      else {
         check_datafile("$password_file_dir/$r_in->{'forum'}.$priv_user_ext");
      }

      $html_output .=qq~
      <FORM METHOD=POST>
      <input type="hidden" name="az" value="$r_in->{'az'}">
      <input type="hidden" name="command" value="update">
      <input type="hidden" name="forum" value="$r_in->{'forum'}">
      <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
      <TR><TH BGCOLOR="$bg_color_0" ALIGN="RIGHT" VALIGN="TOP">
         <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         <b>Available User List</b></FONT>
      </TH>
      <TH BGCOLOR="$bg_color_0" ALIGN="left" VALIGN="TOP">
         <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Current Access Status (Checked = On)
       </FONT>
      </TH>
      </TR>~;

      foreach $user (sort @user_list) {
         &toggle_color();
         $html_output .= qq~
         <tr><Th BGCOLOR="$bgcolor" ALIGN="right">
         <font size="$font_size" face="$font_face" color="$font_color">
         $user</font></Th>~;
         
         my $access;

         foreach (@$r_members) {
            chomp;
            if ($_ eq $user) {
               $access = 'on';
               last;
            }
         }
   
         if ($access eq 'on') {
            $html_output .= qq~
            <TD BGCOLOR="$bgcolor" ALIGN="LEFT" VALIGN="center">
         <font size="$font_size" face="$font_face" color="$font_color">
            <input type="checkbox" name="users" value="$user" checked> </font></Td>~;
         }
         else {
            $html_output .= qq~
            <TD BGCOLOR="$bgcolor" ALIGN="LEFT" VALIGN="center">
         <font size="$font_size" face="$font_face" color="$font_color">
            <input type="checkbox" name="users" value="$user"></font></Td>~;
         }  
         $html_output .= "</tr>\n";
      }

         $html_output .= qq~
       <TR><TH BGCOLOR="$bg_color_0" ALIGN="RIGHT" VALIGN="TOP">&nbsp;</TH>
           <TH BGCOLOR="$bg_color_0" ALIGN="left" VALIGN="TOP">
           <INPUT TYPE="SUBMIT" VALUE="Update User List">
           <INPUT TYPE="Reset" VALUE="Reset">
           </TH></TR></table></form>~;
   }
   else {

      $html_output .= qq~
         <FORM METHOD="POST" ACTION="$adminurl">
         <TABLE BORDER="0" CELLPADDING="3" WIDTH="100%">
         <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_3">
            <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
            <font size="3"><B>Private Forum User Manager</B></font><br>
            Select from following private forums to add/remove users
            </font>
            </TD></TR>
         <TR><Th ALIGN="left" bgcolor="$bg_color_0">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Select</font></Th><Th ALIGN="left" bgcolor="$bg_color_0">
            <font size="$font_size_0" face="$font_face_0" color="$font_color_0">
            Forum Name and Description</font></Th>
         </TR>~;

         toggle_color('reset');
         foreach (@{ $r_setup->{'forums'} }) {

            my $access = "no";
         
            if ($r_setup->{'forum_type'}->{$_} eq 'Private') {
               if ($r_in->{'userdata'}->{'Group'} eq "admin" or
                     $r_setup->{'forum_owner'}->{$_} eq
                        $r_in->{'userdata'}->{'Username'}) {
                  $access = "yes";
               }
            }

            if ($access eq 'yes') {    
               $html_output .= qq~
                  <TR><TD ALIGN="right" VALIGN="TOP" bgcolor="$bgcolor">
                        <INPUT TYPE="RADIO" NAME="forum" VALUE="$_">
                      </TD>
                  <TD ALIGN="LEFT" VALIGN="TOP" bgcolor="$bgcolor">
                     <font size="$font_size" face="$font_face" color="$font_color">
                        <img src="$imgurl/folder.gif">
                        <a href="$boardurl?az=list&forum=$_">$r_setup->{'forum_name'}->{$_}</a>
                        (Moderator: <b>$r_setup->{'forum_owner'}->{$_}</b>)
                        </TD>
                     </TR>
                  ~;
            }
            toggle_color();
         }

         $html_output .= qq~
         <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_2">
            <INPUT TYPE="HIDDEN" NAME="az" VALUE="$r_in->{'az'}">
            <INPUT TYPE="SUBMIT" name="b_add" VALUE="Add/Remove Users">
            <INPUT TYPE="SUBMIT" name="b_addall" VALUE="Allow All Members">
            <INPUT TYPE="RESET" VALUE="Reset Form">
            </FORM></TD></TR></table>~;
   }  
}

1;