# admin_lock_threads.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# admin_lock_threads
# admin utility for locking threads
#===================================================================

sub admin_lock_threads {

	my ($datafile,$r_in,$r_setup) = @_;

	my $html_output = "";
	my $r_rowdata = readdata($datafile);
	my @new_row;
	my @file_selected = split(/\0/,$r_in->{'selected'});

	foreach $row (@$r_rowdata) {
		chomp($row);
		my $new_record = $row;
	   my ($num,$date,$ltime,$name,$subject,$caption,$lock,$read,
		$user_rating,$replies) = split(/$split_delim/,$row);
		foreach (@file_selected) {
			if ($num == $_) {
				$new_record = join("$join_delim",$num,$date,$ltime,
					$name,$subject,$caption,"on",$read,$user_rating,$replies);
				last;
			}
		}
		push(@new_row,"$new_record\n");
	}


	writedata("$maindir/$r_in->{'forum'}/$database",\@new_row);

	foreach (@file_selected) {
		chomp;

		# First update thread.txt file of the lock status
		my $r_data = readdata("$maindir/$r_in->{'forum'}/$thread_dir/$_\.$thread_ext");
		my $first_line = shift(@{$r_data});
		chomp($first_line);
		my $num_next,$rating,$lock,$num_read;
		unless ($first_line =~ /\|/) {
		   $num_next = $first_line;
			$rating = '';
			$lock = 'on';
			$num_read = 0;
		}
		else {
			($num_next,$lock,$rating,$num_read) = split( /$split_delim/,$first_line);
			$lock = 'on';
		}
		$first_line = join("$join_delim",$num_next,$lock,$rating,$num_read);
		unshift(@{$r_data},"$first_line\n");
		writedata("$maindir/$r_in->{'forum'}/$thread_dir/$_\.$thread_ext",$r_data);

		# Next create new thread
		$r_in->{'om'} = $_;
		$r_in->{'lock'} = "on";
	   create_message($r_in,$r_setup);
		push(@FILE_REMOVED,$_);
	}

	my $file_selected = join("\, ",@file_selected);
   my $file_removed = join("\, ",@FILE_REMOVED);
   my $not_removed = join("\, ",@NOT_REMOVED);
   my $no_file = join("\, ",@NO_FILE);

	$html_output .= qq~
	<table border="0" cellpadding="3" width="100%">
		<tr><Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Selected Files</font>
			</th>
		  <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Locked Files</font>
			</th>
		  <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Not Archived</font>
			</th>
		  <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				File Not Found</font>
			</th>
		</tr>
		<tr>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$file_selected</font>
			</td>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$file_removed</font>
			</td>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$not_removed</font>
			</td>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$no_file</font>
			</td>
		</tr>
		<tr>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_0" colspan="4">
			&nbsp;
			</td>
		</tr>
	</table>
	</CENTER>
   ~;

	if ($ENV{'HTTP_REFERER'} =~ /$boardurl/i or
       $ENV{'HTTP_REFERER'} =~ /$mainurl/i) {
		print "Location: $boardurl?az=list&forum=$forum\n\n";
	}
	else {
	   print_header();
	}

	$html_output;
}

1;