# admin_list_threads.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_list_threads                                                   #
# admin utility - lists threads                                        #
#======================================================================#

sub admin_list_threads {

	my ($datafile,$r_in,$r_setup) = @_;

	my $mesg_max = $r_setup->{'mesg_max'};
	my $subject_length_max = $r_setup->{'subject_length_max'};
	my $this_forum_type = $r_setup->{'forum_type'}->{$forum};
	my $r_data = &readdata($datafile);
	my $num_messages = @{$r_data};
	my %type = (
		'admin_unlock_threads' => 'Unlock threads',
		'admin_lock_threads' => 'Lock threads',
		'admin_archive_threads' => 'Archive threads',
		'admin_move_threads' => 'Move threads from one forum to another',
		'admin_remove_threads' => 'Remove threads',
		'admin_list_messages' => 'Remove messages from a thread'
	);


	my $html_output .= qq~
   <CENTER>
   <FORM METHOD=POST>
	<INPUT TYPE="HIDDEN" NAME="az" VALUE="$r_in->{'az'}">
  	<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
  		<TR><TD COLSPAN="5" ALIGN="left" bgcolor="$bg_color_3">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<font size="3"><b>Manage Your Board: $type{$r_in->{'command'}}</font></b><br>
	   	Select threads
			</font></TD></TR></table>~;

	if ($r_in->{"remove_type"} eq "admin_move_threads") {

		$html_output .=qq~

  	<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
  		<TR><TD COLSPAN="5" ALIGN="left" bgcolor="$bg_color_3">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<b>Move to Which Forum?</b>
			<select name="forum_to">
		~;

		if ($this_forum_type eq "Private") {
		  	foreach (@{ $r_setup->{'forums'} }) {
		  	  	if ($_ ne $r_in->{'forum'} && $r_setup->{'forum_type'}->{$_} eq "Private") {
				  	$html_output .=qq~
					<option value="$_">$r_setup->{'forum_name'}->{$_}
					~;
				}
			}
		}
		else {
		  	foreach (@{ $r_setup->{'forums'} }) {
  			  	if ($_ ne $r_in->{'forum'} && $r_setup->{'forum_type'}->{$_} ne "Private") {
				  	$html_output .=qq~
					<option value="$_">$r_setup->{'forum_name'}->{$_}
					~;
				}
			}
		}

		$html_output .=qq~
		</select>
		</font></TD></TR></table>
		~;
	}		

	$html_output .= qq~
	<p>
   <TABLE BORDER="0" CELLPADDING="1" WIDTH="100%">
   <TR><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VLIGN="TOP" WIDTH="100">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Select</font></TH>
      <TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VLIGN="TOP" WIDTH="100">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Subject</font></TH>
      <TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VLIGN="TOP" WIDTH="100">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Posted By</font></TH>
      <TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VLIGN="TOP" WIDTH="100">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Last&nbsp;Modified&nbsp;On</font>
      </TH><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VLIGN="TOP" WIDTH="100">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Replies</font>
      </TH>
   </TR>~;

	if ($r_in->{'archive'}) {
         $html_output .= qq~
		<INPUT TYPE="HIDDEN" NAME="archive" value="yes">
		~;
	}

	toggle_color('reset');
	foreach (@$r_data) {
		chomp;
		my ($num,$date,$localtime,$name,$subject,$caption,$lock,$read,
			$user_rating,$replies) = split /$split_delim/;
		$subject = dc_decode($subject);
		$html_output .=qq~
	    <TR><TD VALIGN="TOP" ALIGN="RIGHT" BGCOLOR="$bgcolor">~;

      if ($r_in->{"remove_type"} eq "admin_remove_threads") {	  
   	   $html_output .= qq~
	         <INPUT TYPE="checkbox" NAME="selected" VALUE="$num">~;
		}
      elsif ($r_in->{"remove_type"} eq "admin_unlock_threads") {
				if ($lock) {
   	         $html_output .= qq~
	          <INPUT TYPE="checkbox" NAME="selected" VALUE="$num">~;
				}
				else {
   	         $html_output .= "&nbsp";
				}
		}
      elsif ($r_in->{"remove_type"} eq "admin_lock_threads") {
			unless ($lock) {
   	         $html_output .= qq~
	          <INPUT TYPE="checkbox" NAME="selected" VALUE="$num">~;
			}
			else {
   	         $html_output .= "&nbsp";
			}
		}
		elsif ($r_in->{'remove_type'} eq 'admin_archive_threads') {
   	         $html_output .= qq~
	          <INPUT TYPE="checkbox" NAME="selected" VALUE="$num">~;
		}
		elsif ($r_in->{'remove_type'} eq 'admin_move_threads') {
   	         $html_output .= qq~
	          <INPUT TYPE="checkbox" NAME="selected" VALUE="$num">~;
		}
		else {
   	         $html_output .=qq~
	          <INPUT TYPE="RADIO" NAME="thread_select" VALUE="$num">~;
		}
		
		$html_output .=qq~
		</TD>
		<TH BGCOLOR="$bgcolor"  VALIGN="TOP" ALIGN="LEFT">
		<img src="$imgurl/folder.gif">~;

		if ($r_setup->{'forum_type'}->{$forum} eq "Private") {
			$html_output .=qq~
				<a href="$boardurl?az=show_thread&om=$num&forum=$forum"><font 
				size="$font_size" face="$font_face" color="$font_color">
      		$subject</FONT></a></TH>
				~;
		}
		else {
			$html_output .=qq~
      	<a href="$mainurl/$forum/$num\.$r_in->{'ext'}"><font 
			size="$font_size" face="$font_face" color="$font_color">
			$subject</FONT></a></TH>
			~;
		}

		$html_output .=qq~
			<TD  ALIGN="CENTER" BGCOLOR="$bgcolor"  VALIGN="TOP">
		  	<font size="$font_size" face="$font_face" color="$font_color">
			$name</FONT>
		  	</TD>      
			<TD  ALIGN="CENTER" BGCOLOR="$bgcolor"  VALIGN="TOP">
		  	<font size="$font_size" face="$font_face" color="$font_color">
			$localtime $date</FONT>
		  	</TD>
			<TD  ALIGN="CENTER" BGCOLOR="$bgcolor"  VALIGN="TOP">
		  	<font size="$font_size" face="$font_face" color="$font_color">
			$replies</FONT>
		  	</TD>
	    	</TR>~;
		 
	toggle_color();
	
   }

   $html_output .=qq~
  	<TR><TD ALIGN="left" colspan="5" VALIGN="TOP" bgcolor="$bg_color_3">
	<INPUT TYPE="HIDDEN" NAME="command" value="$r_in->{'remove_type'}">
	<INPUT TYPE="HIDDEN" NAME="forum" VALUE="$forum">
   <INPUT TYPE="SUBMIT" VALUE="Submit"> <INPUT TYPE="RESET" VALUE="Reset Form">
	</TD></TR>
   </TABLE>
   </FORM>
   </CENTER>
	 ~;

	$html_output;
}

1;