# admin_list_forums.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_list_forums                                                    #
# admin utility for listing forums                                     #
#======================================================================#

sub admin_list_forums {

	my ($r_in,$r_setup) = @_;

	my %type = (
		'admin_rebuild_database' => 'Rebuild database from topic files',
		'admin_queue' => 'Manage Messages in Queue',
		'admin_unlock_threads' => 'Unlock threads',
		'admin_lock_threads' => 'Lock threads',
		'admin_archive_threads' => 'Archive threads',
		'admin_move_threads' => 'Move threads from one forum to another',
		'admin_remove_threads' => 'Remove threads',
		'admin_list_messages' => 'Remove messages from a thread'
	);

	$html_output .= qq~
	<FORM METHOD=POST>
	<input type="hidden" name="az" value="$r_in->{'az'}">
   <INPUT TYPE="HIDDEN" NAME="remove_type" VALUE="$r_in->{'remove_type'}">
  	<TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
  		<TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_3">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<font size="3"><b>Manage Your Board: $type{$r_in->{'remove_type'}}</font></b></td></tr>
			~;
	unless ($r_in->{'remove_type'} eq 'admin_queue' or 
				$r_in->{'remove_type'} eq 'admin_rebuild_database') {
		$html_output .= qq~
   	  <TR><TD COLSPAN="2" ALIGN="left" bgcolor="$bg_color_3">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<input type="checkbox" name="archive" value="yes">
				Work with archives instead of current threads?<br>
	   	<b>Select a forum</b>
			</font></TD></TR></table>~;
	}
	else {
		my $r_data = readdata("$password_file_dir/$queue");
		foreach (@$r_data) {
			chomp;
			my ($forumid,$om,$omm,$ldate,$ltime,
				$name,$subject,$body) = split /$split_delim/;
			$r_in->{'count'}->{$forumid}++;
		}

		$html_output .= qq~
			</table>~;
	}

	$html_output .= qq~
   <TABLE BORDER="0" CELLPADDING="1" WIDTH="100%">
   	<TR><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" width="80">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Select</font></TH>
      	<TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" width="100%">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Forum Name</font>
			</TH><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Type</font></TH><TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Owner</font></TH>~;

	unless ($r_in->{'remove_type'} eq 'admin_queue') {
		$html_output .= qq~
		<TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" WIDTH="100%" colspan="2">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Status</font></TH></TR>~;
	}
	else {
		$html_output .= qq~
		<TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" WIDTH="100%">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         Status</font></TH>		<TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP" WIDTH="100%">
			<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
         In Queue</font></TH></TR>~;	
	}

	my $owners;
		
   foreach $forumid (@{ $r_setup->{'forums'} }) {

		$owners = $r_setup->{'forum_owner'}->{$forumid};
		$owners =~ s/\,/<br>/g;
		
		$r_in->{'count'}->{$forumid} = 0 if ($r_in->{'count'}->{$forumid} eq '');
	   if ($r_in->{'userdata'}->{'Group'} eq "admin") {

			unless ($r_in->{'remove_type'} eq 'admin_queue' 
				and $r_setup->{'forum_queue'}->{$forumid} eq 'off') {

		      	$html_output .= qq~
	      		<TR><TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
				      <INPUT TYPE="RADIO" NAME="forum" VALUE="$forumid"></TD>
	            	<TD ALIGN="LEFT" VALIGN="TOP" bgcolor="$bg_color_3">
	             	<img src="$imgurl/folder.gif">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	              	<a href="$boardurl?az=list&forum=$forumid">$r_setup->{'forum_name'}->{$forumid}</a>
						</td><TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$r_setup->{'forum_type'}->{$forumid}
						</font></td>
						<TD ALIGN="center" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$owners</font></td>
						<TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$r_setup->{'forum_status'}->{$forumid}</font></td>
						<TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$r_in->{'count'}->{$forumid}</font></td>
						</TR>~;
			} #End of unless
	   }
		# OK, the user is not an admin user
	   elsif ($r_setup->{'forum_owner'}->{$forumid} eq
						$r_in->{'userdata'}->{'Username'} and
	            	$r_setup->{'forum_status'}->{$forumid} eq "on") {
	
			unless ($r_in->{'remove_type'} eq 'admin_queue' 
				and $r_setup->{'forum_queue'}->{$forumid} eq 'off') {

	      	$html_output .= qq~
	      		<TR><TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
				      <INPUT TYPE="RADIO" NAME="forum" VALUE="$forumid"></TD>
	            	<TD ALIGN="LEFT" VALIGN="TOP" bgcolor="$bg_color_3">
	             	<img src="$imgurl/folder.gif">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	              	<a href="$boardurl?az=list&forum=$forumid">$r_setup->{'forum_name'}->{$forumid}</a>
						</td><TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$r_setup->{'forum_type'}->{$forumid}
						</font></td>
						<TD ALIGN="center" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$owners</font></td>
						<TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$r_setup->{'forum_status'}->{$forumid}</font></td>
						<TD ALIGN="right" VALIGN="TOP" bgcolor="$bg_color_3">
						<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
						$r_in->{'count'}->{$forumid}</font></td>
						</TR>
				~;

	      }	
		}
	}#End of foreach
	
   $html_output .= qq~
  	<TR><TD ALIGN="left" colspan="6" VALIGN="TOP" bgcolor="$bg_color_3">
	~;
	if ($r_in->{'remove_type'} eq 'admin_queue') {
		$html_output .= qq~
   	<INPUT TYPE="HIDDEN" NAME="command" VALUE="admin_queue">~;   
	}
	elsif ($r_in->{'remove_type'} eq 'admin_rebuild_database') {
		$html_output .= qq~
   	<INPUT TYPE="HIDDEN" NAME="command" VALUE="admin_rebuild_database">~;   
	}
	else {
		$html_output .= qq~
   	<INPUT TYPE="HIDDEN" NAME="command" VALUE="admin_list_threads">~;
	}	
		$html_output .= qq~
   <INPUT TYPE="SUBMIT" VALUE="Submit Form">
   <INPUT TYPE="RESET" VALUE="Reset Form">
	</TD></TR>
   </TABLE>
   </FORM>~;

   $html_output;

}

1;