# admin_forum_manager.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#
#======================================================================#
# admin_forum_manager                                                  #
# admin utility for managing forums                                    #
#======================================================================#

sub admin_forum_manager {

	my($r_in,$r_setup) = @_;
	
	if ($r_in->{"command"} eq "reorder_forum_form") {
	   $r_in->{'command'} = "reorder_forum";
		$form_title = "Reorder Forums";
		$form_desc = "Reassign numerical order to the forums below.";
	   $html_output = reorder_forum_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "reorder_forum") {
		my $thisfile = "$password_file_dir/$forum_file";
	   $html_output = reorder_forum($thisfile,$r_in);
	}
	elsif ($r_in->{"command"} eq "c_forum_form") {
	   $r_in->{'command'} = "c_forum";
		$form_title = "Create New Forum";
		$form_desc = "Complete the form below to create a new forum.";
	   $html_output = &forum_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "c_forum") {
	   $html_output = &c_forum($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "m_forum_select") {
	   $r_in->{'command'} = "m_forum_form";
		$form_title = "Modify Forum";
		$form_desc = "Select the forum you wish to modify.";
	   $html_output = &r_forum_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "m_forum_form") {
	   $r_in->{'command'} = "m_forum";
		$form_title = "Modify Forum";
		$form_desc = "Modify the following form to update forum information.";
	   $html_output = forum_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "m_forum") {
	   $html_output = c_forum($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "r_forum_form") {
	   $r_in->{'command'} = "r_forum";
		$form_title = "Remove Forum";
		$form_desc = "Select the forum you wish to remove.<br><b>NOTE: Once you remove a forum, you can't undo it!!!</b>";
	   $html_output = r_forum_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "r_forum") {
		my $thisfile =
			"$password_file_dir/$forum_file";
	
		if ($r_in->{"forum"}) {
	   	$html_output = r_forum($thisfile,$r_in);
		}
		else {
	   	$html_output = qq~
			You didn't choose a forum to remove...Go back and select a forum
			~;
		}
	}


}

###
# subroutine c_forum
# Creates new forum
# Creates directories and files
###

sub c_forum {

	my($r_in,$r_setup) = @_;
	my $output;
	my $type = $r_in->{'c_forum_type'};

	# Convert control characters to HTML equivalents	
	$r_in->{'c_forum_desc'} =~ s/\n\n/<p>/g;
	$r_in->{'c_forum_desc'} =~ s/\r\n/<br>/g;
	$r_in->{'c_forum_desc'} =~ s/\n/<br>/g;

	# list owners using comma as deliter
	$r_in->{'c_forum_owner'} =~ s/\0/,/g;

	my $forum = $r_in->{'c_forum_folder'};
   unless ($forum) {
	   $forum = get_id("$password_file_dir/$forum_id");
	   $forum = $forum_root . $forum;
	}

   unless ($r_in->{'c_forum_last'}) {
		$r_in->{'c_forum_last'} = $r_in->{'localtime'} . " " . $r_in->{'date'};
	}
	
	chomp($r_setup->{'forum_conf'}->{$forum});

	$r_setup->{'forum_name'}->{$forum} = $r_in->{'c_forum_name'};
	$r_setup->{'forum_conf'}->{$forum} = $r_in->{'c_forum_conf'};
	$r_setup->{'forum_desc'}->{$forum} = $r_in->{'c_forum_desc'};
	$r_setup->{'forum_owner'}->{$forum} = $r_in->{'c_forum_owner'};
#	$r_setup->{'forum_owner_email'}->{$forum} = $r_in->{'c_forum_owner_email'};
	$r_setup->{'forum_status'}->{$forum} = $r_in->{'c_forum_status'};
	$r_setup->{'forum_last'}->{$forum} = $r_in->{'c_forum_last'};
	$r_setup->{'forum_queue'}->{$forum} = $r_in->{'c_forum_queue'};
	$r_setup->{'forum_type'}->{$forum} = $r_in->{'c_forum_type'};
	$r_setup->{'forum_threads'}->{$forum} = $r_in->{'c_forum_threads'};
	$r_setup->{'forum_posts'}->{$forum} = $r_in->{'c_forum_posts'};
	$r_setup->{'forum_archive'}->{$forum} = $r_in->{'c_forum_archive'};

   my @owner_emails;
	my @owners = split( /\,/,$r_in->{'c_forum_owner'} );

   foreach (@owners) {
      my $email = get_user_email($_);
      push(@owner_emails,$email);      
   }

	$r_setup->{'forum_owner_email'}->{$forum} = join("\,",@owner_emails);


	if ($r_in->{'command'} eq "m_forum") {
		save_forum_info("$password_file_dir/$forum_file",$r_setup);
      $output = print_status("Forum 
			\"$r_setup->{'forum_name'}->{$forum}\" modified successfully!");
	}
	else {
		push(@{$r_setup->{'forums'}},$forum);
		save_forum_info("$password_file_dir/$forum_file",$r_setup);
		if ($type eq "Private") {
			check_dir("$privatedir/$forum");
			check_dir("$privatedir/$forum/$thread_dir");
			check_dir("$privatedir/$forum/$email_dir");
			check_datafile("$privatedir/$forum/arc_$database");
			check_datafile("$privatedir/$forum/$database");
			check_datafile("$privatedir/$forum/$datafile");
		}
		else {
			check_dir("$maindir/$forum");
			check_dir("$maindir/$forum/$thread_dir");
			check_dir("$maindir/$forum/$email_dir");
			check_datafile("$maindir/$forum/arc_$database");
			check_datafile("$maindir/$forum/$database");
			check_datafile("$maindir/$forum/$datafile");
		}
        $output = print_status("New Forum 
			\"$r_setup->{'forum_name'}->{$forum}\" created successfully!");		
	}
	$output;

}


###
### subroutine forum_form
### displays the form for creating a new forum
###

sub forum_form {

  my ($r_in,$r_setup) = @_;
  my $html_output = '';

   if ($r_in->{'command'} eq "m_forum") {
			my $forum = $r_in->{'forum'};
			$r_in->{'c_forum_folder'} = $forum;
			$r_in->{'c_forum_conf'} = $r_setup->{'forum_conf'}->{$forum};
			$r_in->{'c_forum_name'} = $r_setup->{'forum_name'}->{$forum};
			$r_in->{'c_forum_desc'} = $r_setup->{'forum_desc'}->{$forum};
			$r_in->{'c_forum_owner'} = $r_setup->{'forum_owner'}->{$forum};
			$r_in->{'c_forum_owner_email'} = $r_setup->{'forum_owner_email'}->{$forum};
			$r_in->{'c_forum_type'} = $r_setup->{'forum_type'}->{$forum};
			$r_in->{'c_forum_status'} = $r_setup->{'forum_status'}->{$forum};
			$r_in->{'c_forum_last'} = $r_setup->{'forum_last'}->{$forum};
			$r_in->{'c_forum_queue'} = $r_setup->{'forum_queue'}->{$forum};
			$r_in->{'c_forum_threads'} = $r_setup->{'forum_threads'}->{$forum};
			$r_in->{'c_forum_posts'} = $r_setup->{'forum_posts'}->{$forum};
			$r_in->{'c_forum_archive'} = $r_setup->{'forum_archive'}->{$forum};

   }

	get_date($r_in);
   my $last_date = "$r_in->{'localtime'} $r_in->{'date'}";

	$html_output .=qq~
       <FORM METHOD="POST">
       <input type="hidden" name="az" value="$r_in->{'az'}">
       <input type="hidden" name="command" value="$r_in->{'command'}">
       <TABLE BORDER="0" CELLPADDING="4" WIDTH="100%" ALIGN="CENTER">
   	<TR>
      <TD BGCOLOR="$bg_color_3" colspan="2" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
      <font size="3"><b>$form_title</b></font><br>$form_desc</font></TD></tr>
	~;
			
   if ($r_in->{'command'} eq "m_forum") {
  	   $html_output .=qq~
         <input type="hidden" name="c_forum_folder" value="$r_in->{'c_forum_folder'}">
         <input type="hidden" name="c_forum_last" value="$r_in->{'c_forum_last'}">
     ~;
	}

   $html_output .=qq~
   <TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
           Forum Conference</font></TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		  <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  <select name="c_forum_conf">
	~;

	$r_conf = readdata("$password_file_dir/$conf_file");

	foreach (@$r_conf) {
		chomp;
		my ($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;
		if ($conf_id eq "$r_in->{'c_forum_conf'}") {
			$html_output .= qq~
			<option value="$conf_id" selected>$conf_name~;
		}
		else {
			$html_output .= qq~
			<option value="$conf_id">$conf_name~;
		}
	}

		$html_output .= qq~
		</select>
		</font>
      </TD>
   </TR>
   <TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
           Forum Name:
	</font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		  <input type="text" name="c_forum_name" size="30" value="$r_in->{'c_forum_name'}">
      </TD>
   </TR>
   <TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		  <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  Forum Description
		  </font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
	  	<textarea name="c_forum_desc" rows="7" cols="30" wrap="physical">$r_in->{'c_forum_desc'}</textarea>
     </TD>
   </TR>
	<TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			Forum Moderator
			</font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		  <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			~;
		my $r_lines = readdata("$password_file_dir/$password_file");
		foreach (@$r_lines) {
			chomp;
			my @temp = split /$split_delim/;
			if ($temp[2] eq 'admin' || $temp[2] eq 'moderator') {
				if (is_moderator($temp[1],$r_in->{'c_forum_owner'})) {
					$html_output .= qq~
						<input type="checkbox" name="c_forum_owner" value="$temp[1]" checked>$temp[1] ($temp[2])<br>
					~;
				}
				else {
					$html_output .= qq~
						<input type="checkbox" name="c_forum_owner" value="$temp[1]">$temp[1] ($temp[2])<br>
					~;
				}
			}
		}

	$html_output .=qq~
			</font>
      </TD>
   </TR>
   <TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  Moderator EMail
			</font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		  <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  This field is no longer used.
			</font>
     </TD>
   </TR>
   <TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  Forum Type
			</font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		  <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	~;

		if ($r_in->{'c_forum_type'} eq "Protected") {
			$html_output .= qq~
		  	<input type="radio" name="c_forum_type" value="Public">Public
		  	<input type="radio" name="c_forum_type" value="Protected" checked>Protected~;
		}
		elsif ($r_in->{'c_forum_type'} eq "Private") {
			$html_output .= qq~
		  	<input type="radio" name="c_forum_type" value="Private" checked>Private~;
		}
		elsif ($r_in->{'c_forum_type'} eq "Public") {
			$html_output .= qq~
		  	<input type="radio" name="c_forum_type" value="Public" checked>Public
		  	<input type="radio" name="c_forum_type" value="Protected" >Protected~;
		}
		else {
			$html_output .= qq~
		  	<input type="radio" name="c_forum_type" value="Public" checked>Public
		  	<input type="radio" name="c_forum_type" value="Protected">Protected
		  	<input type="radio" name="c_forum_type" value="Private">Private~;
		}

	$html_output .= qq~
			</font>
      </TD>
   </TR>
	<TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  Forum Mode
			</font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	~;

	if ($r_in->{'c_forum_queue'} eq "on") {
		$html_output .= qq~
	  	<input type="radio" name="c_forum_queue" value="on" checked>Moderated
	  	<input type="radio" name="c_forum_queue" value="off">Not Moderated
		~;
	}
	else {
		$html_output .= qq~
	  	<input type="radio" name="c_forum_queue" value="on">Moderated
	  	<input type="radio" name="c_forum_queue" value="off" checked>Not Moderated
		~;
	}

	$html_output .= qq~
			</font></TD></TR>
	<TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		  Forum Status
			</font>
      </TH>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	~;

	if ($r_in->{'c_forum_status'} eq "on") {
		$html_output .= qq~
	  	<input type="radio" name="c_forum_status" value="on" checked>Active
	  	<input type="radio" name="c_forum_status" value="off">Inactive
		~;
	}
	else {
		$html_output .= qq~
	  	<input type="radio" name="c_forum_status" value="on">Active
	  	<input type="radio" name="c_forum_status" value="off" checked>Inactive
		~;
	}

	$html_output .= qq~
			</font></TD></TR>~;

	if ($r_in->{'c_forum_threads'}) {
		$html_output .= qq~
		<TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			No. of Threads</font></TH>
      	<TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<input type="text" name="c_forum_threads" size="20" value="$r_in->{'c_forum_threads'}">
			</font></TD></TR>
		<TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			No. of Posts</font></TH>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" 
			face="$font_face_3" color="$font_color_3"><input type="text" 
			name="c_forum_posts" size="20" 
			value="$r_in->{'c_forum_posts'}"></font></TD></TR>
		<TR>
      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			No. of Archived Threads</font></TH>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP"><font size="$fon_size_3" 
			face="$font_face_3" color="$font_color_3"><input type="text" 
			name="c_forum_archive" size="20" 
			value="$r_in->{'c_forum_archive'}"></font></TD></TR>
			~;
	}
	else {
		$html_output .= qq~
		<input type="hidden" name="c_forum_threads" value="0">
		<input type="hidden" name="c_forum_archive" value="0">
		<input type="hidden" name="c_forum_posts" value="0">~;
	}


	$html_output .= qq~
   <TR>
      <TD BGCOLOR="$bg_color_3" colspan="2" ALIGN="Center" VALIGN="TOP">
	   <INPUT type="submit" value="Submit This Form">
   		<INPUT type="reset" value="Reset">
      </TD>
   </TR>
   </TABLE>
   </FORM>
   ~;

	$html_output;
}


###
### subroutine r_forum_form
### displays the form for removing forums
###

sub reorder_forum_form {

	my ($r_in,$r_setup) = @_;
	my $html_output = "";

	$html_output .=qq~
	<FORM METHOD=POST>
	<input type="hidden" name="az" value="$r_in->{'az'}">
       <input type="hidden" name="command" value="$r_in->{'command'}">
   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
   <TR>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="CENTER" COLSPAN="3">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		<B><font size="3">$form_title</font></b><br>
		$form_desc
		</font></TD></TR>

   <TR>
      <Th BGCOLOR="$bg_color_0" ALIGN="RIGHT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Order Number
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Name
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Description
		</font>
      </Th>
   </TR>
	~;

	my $j = 0;
	foreach (@{$r_setup->{'forums'}}) {

		$j++;

		$html_output .=qq~
	   <TR>
	      <TD BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				<input type="text" name="order_$_" value="$j" size="5">
	      </font></TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_name'}->{$_}</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_desc'}->{$_}</font>
	      </TD>
	   </TR>
		~;

	}	
	$html_output .=qq~
   <TR>
      <TD BGCOLOR="$bg_color_3"  colspan="3" ALIGN="Center" VALIGN="CENTER">
	   <INPUT type="submit" value="Submit">
   		<INPUT type="reset" value="Reset">
      </TD>
   </TR>
   </TABLE>
   </FORM>
   ~;

   $html_output;
}


###
### subroutine reorder_forum
### reorder forum listing
###

sub reorder_forum {

	my($forum_file,$r_in) = @_;
	my $html_output;

	my $r_data = readdata("$forum_file");	

	foreach (@$r_data) {
		chomp;
		my @temp = split(/$split_delim/,$_);
		my $forum_name = $temp[0];
		$order{ $r_in->{"order_$forum_name"} } = $_;
	}

	my @newrow;

	foreach (sort {$a <=> $b} keys %order) {
		push(@newrow,"$order{$_}\n");
	}
	
	writedata($forum_file,\@newrow);

   $html_output = print_status("Forums have been reordered successfully!");		

	$html_output;
}


###
### subroutine r_forum
### remove existing forum
###

sub r_forum {

	my($forum_file,$r_in) = @_;
	my $output;

	my $r_data = &readdata("$forum_file");	
	
	my @newrow;
	foreach (@$r_data) {
		unless ($_ =~ /^$forum$split_delim/) {
			push(@newrow,$_);
		}
	}

	writedata($forum_file,\@newrow);

	if (-e "$maindir/$forum/$thread_dir") {
		remove_dir("$maindir/$forum/$thread_dir");
	}

	if (-e "$maindir/$forum/$email_dir") {
		remove_dir("$maindir/$forum/$email_dir");
	}

	if (-e "$maindir/$forum") {
		remove_dir("$maindir/$forum");
	}

	$output = print_status("Forum named \"$forum\" 
		has been removed successfully");

	$output;
}


###
### subroutine r_forum_form
### displays the form for removing forums
###


sub r_forum_form {

	my ($r_in,$r_setup) = @_;

	my $html_output .=qq~
	<FORM METHOD=POST>
	<input type="hidden" name="az" value="$r_in->{'az'}">
       <input type="hidden" name="command" value="$r_in->{'command'}">
   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
   <TR>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="CENTER" COLSPAN="7">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		<B><font size="3">$form_title</font></b><br>
		$form_desc
		</font></TD></TR>
   <TR>
      <Th BGCOLOR="$bg_color_0" ALIGN="RIGHT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Select
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Name
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Conference
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Description
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Moderator
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Type
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Forum Status
		</font>
      </Th>
   </TR>
	~;

	foreach (@{$r_setup->{'forums'}}) {

		$html_output .=qq~
	   <TR>
	      <TD BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
				<input type="radio" name="forum" value="$_">
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_name'}->{$_}
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'conf_name'}->{$r_setup->{'forum_conf'}->{$_}}
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_desc'}->{$_}
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_owner'}->{$_}
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_type'}->{$_}
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$r_setup->{'forum_status'}->{$_}
			</font>
	      </TD>
	   </TR>
		~;

	}	
	$html_output .=qq~
   <TR>
      <TD BGCOLOR="$bg_color_3"  colspan="7" ALIGN="left" VALIGN="CENTER">
	   <INPUT type="submit" value="Submit">
   		<INPUT type="reset" value="Reset">
      </TD>
   </TR>
   </TABLE>
   </FORM>
   ~;

   $html_output;
}

#======================================================================#
# is_moderator                                                         #
# Returns 1 if $user is a moderator                                    #
# Returns 0 otherwise                                                  #
#======================================================================#

sub is_moderator {
	my ($user, $owners) = @_;
	my @owners = split(",",$owners);
	my $flag = 0;
	foreach (@owners) {
		if ($user eq $_) {
			$flag=1;
			last;
		}
	}
	return $flag;
}

1;