# admin_forum_attributes.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# admin_forum_attributes
# utility for managing forum attributes
#===================================================================

sub admin_forum_attributes {

   my ($r_in,$r_setup) = @_;
	my %vars;
	
	%desc = (
	   bg_color_0 => "Background Color 0",
	   font_color_0 => "Font Color 0",
	   font_face_0 => "Font Face 0",
	   font_size_0 => "Font Size 0",
	   bg_color_1 => "Background Color 1",
	   font_color_1 => "Font Color 1",
	   font_face_1 => "Font Face 1",
	   font_size_1 => "Font Size 1",
	   bg_color_2 => "Background Color 2",
	   font_color_2 => "Font Color 2",
	   font_face_2 => "Font Face 2",
	   font_size_2 => "Font Size 2",
	   bg_color_3 => "Background Color 3",
	   font_color_3 => "Font Color 3",
	   font_face_3 => "Font Face 3",
	   font_size_3 => "Font Size 3",
	   bg_color_4 => "Background Color 4",
	   font_color_4 => "Font Color 4",
	   font_face_4 => "Font Face 4",
	   font_size_4 => "Font Size 4",
	   bg_color_5 => "Top Menu Background Color",
	   font_color_5 => "Top Menu Font Color",
	   font_face_5 => "Top Menu Font Face",
	   font_size_5 => "Top Menu Font Size",
	   font_color_6 => "Special Font Color",
		forum_title => "Forum Title",
	   time_offset => "Time offset from GMT in Hours",
	   time_zone => "Time Zone",
		date_format => "Date Format",
	   mesg_max => "Number of threads to display per page",
	   level_max => "Number of thread levels",
	   level_spacing => "Spacing between icons at each level",
	   subject_length_max => "Maximum subject length displayed",
	   word_length_max => "Maximum word length allowed",
	   max_messages => "Autosensing starts at how many messages?",
	   max_threads_allowed => "Maximum threads to keep per board",
	   auto_archive => "Automatically archive threads instead of deleting them?",
	   table_width => "Table width (if in percent, include %)",
	   use_icons => "Use icons in navigation menus?",
	   use_icons_toc => "Use icons in table of contents?",
	   display_caption => "Display caption below subjects?",
	   caption_length => "Caption length in characters",
	   allow_expand => "Allow users to expand threads in the main listing?",
	   hide_private => "Hide Private Forums From Forum Listing?",
	   show_orig_mesg => "Show Original Message in Posting Form?",
	   edit_allowed => "Editing of Messages Allowed?",
	   edit_time_out => "If editing is allowed, specify time limit in minutes",
	   html_allowed => "Use of HTML Tags Allowed?",
	   image_allowed => "Image Links Allowed?",
	   conf_listing => "Display only conferences in the Lobby?",
	   threaded_discussion => "Threaded Discussion?",
	   reverse_thread => "Reverse Threading?",
	   message_indent => "Indent threaded message?",
	   email_to_admin => "Notify Admin if New Thread is Posted?",
	   email_to_mod => "Notify Moderator if New Thread is Posted?",
	   display_ip_address => "Allow users to view IP address?",
	   ip_blocking => "Turn on IP blocking?",
	   read_count => "Keep track of number of times a topic has been read?",
	   user_rating => "Turn on user rating?",
	   file_upload => "Allow Users to upload files?",
	   file_upload_size => "If uploading files is enabled, what is the maximum size allowed in KBytes?",
	   email_notification => "Enable Email Notification?",
	   subscription => "Enable Subscription?",
	  	auth_admin_email_address => 'Admin EMail Address',
	  	auth_sendmail_path => 'Sendmail Path',
	  	auth_smtp_server => 'SMTP Server - NT only',
	  	auth_register_via_email => 'Register Via EMail',
	  	auth_allow_registration => 'Allow Users to Register',
	  	auth_default_group => 'Default Group',
	  	auth_activate_user_on_registration => 'Activate User on Register',
	  	auth_allow_password_remembering => 'Allow Remembering of Password',
	  	auth_notify_admin_on_registration => 'Notify Admin on Register',
	  	auth_notify_user_on_activation => 'Notify User on Act/Deactivation',
	  	auth_allow_account_mod => 'Allow Users to Modify Account Infomation',
	  	auth_allow_password_mod => 'Allow Users to Change Password',
	  	auth_bad_emails => 'Bad EMail List',
	   auth_bad_word_list => "List bad words you want to block"
	);
	
	my @sec_vars = qw(
	  	auth_admin_email_address
	  	auth_sendmail_path
	  	auth_smtp_server
	  	auth_register_via_email
	  	auth_allow_registration
	  	auth_default_group
	  	auth_activate_user_on_registration
	  	auth_allow_password_remembering
	  	auth_notify_admin_on_registration
	  	auth_notify_user_on_activation
	  	auth_allow_account_mod
	  	auth_allow_password_mod
	  	auth_bad_emails
	   auth_bad_word_list
	);
	
	my @color_vars = qw(
	   bg_color_0
	   font_color_0
	   font_face_0
	   font_size_0
	   bg_color_1
	   font_color_1
	   font_face_1
	   font_size_1
	   bg_color_2
	   font_color_2
	   font_face_2
	   font_size_2
	   bg_color_3
	   font_color_3
	   font_face_3
	   font_size_3
	   bg_color_4
	   font_color_4
	   font_face_4
	   font_size_4
	   bg_color_5
	   font_color_5
	   font_face_5
	   font_size_5
	   font_color_6
	);

	my @text_time_vars = qw(
		forum_title
		time_offset
		time_zone
		date_format
	);	
	my @setup_vars = qw(
	   mesg_max
	   level_max
	   level_spacing
	   subject_length_max
	   word_length_max
	   max_messages
	   max_threads_allowed
	   auto_archive
	   table_width
	   use_icons
	   use_icons_toc
	   display_caption
	   caption_length
	   allow_expand
	   hide_private
	   show_orig_mesg
	   edit_allowed
	   edit_time_out
	   html_allowed
	   image_allowed
	   conf_listing
	   threaded_discussion
	   reverse_thread
	   message_indent
	   email_to_admin
	   email_to_mod
	   email_notification
	   subscription
	   display_ip_address
	   ip_blocking
	   read_count
	   user_rating
	   file_upload
	   file_upload_size
	);
	

   my $html_output = "";
	my $datafile = "$password_file_dir/$board_setup_file";
   my $r_data = readdata($datafile);

	if ($r_in->{'command'} eq 'save') {
		my @newdata;
	   foreach (@$r_data) {
	      chomp;
	      my ($key,$value) = split /$split_delim/;
	      $temp = join("$join_delim",$key,$r_in->{"form_$key"});
	      push(@newdata,"$temp\n");
	   }	
	   writedata($datafile,\@newdata);

		$html_output = print_status("Forum settings are updated");
	
	}
	else {
	
	   $html_output .=qq~
	   <FORM METHOD=POST>
	   <input type="hidden" name="az" value="$r_in->{'az'}">
	   <input type="hidden" name="command" value="save">
	   <TABLE BORDER="0" CELLPADDING="4" WIDTH="100%" ALIGN="CENTER">
	   <TR><TD BGCOLOR="$bg_color_3" ALIGN="LEFT" colspan="2">
			  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	         <font size="3"><B>Set Forum Attributes and Settings</B></font>
	         <br>
	         To modify any settings, enter new values and
				and submit this form.<br>
				<a href="http://www.dcscripts.com/Images/style.gif" 
				target="blank">See this page for color definitions</a></font>
	      </TD>
	   </TR>
	   ~;

			
	   foreach (@$r_data) {
	      chomp;
	      my ($key,$value) = split /$split_delim/;
			$vars{$key} = $value;
		}
	
	   $html_output .=qq~
	   <TR><TD BGCOLOR="$bg_color_0" ALIGN="RIGHT" colspan="2">
			  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
	         <font size="3"><B>Forum Title and Time Settings</B></font></font>
	      </TD>
	   </TR>
		~;

	   foreach (@text_time_vars) {
	      chomp;
			$html_output .= table_text ($vars{$_},$_,$r_setup);
		}

	   $html_output .=qq~
	   <TR><TD BGCOLOR="$bg_color_0" ALIGN="RIGHT" colspan="2">
			  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
	         <font size="3"><B>Security Settings</B></font></font>
	      </TD>
	   </TR>
		~;

	   foreach (@sec_vars) {
	      chomp;
			$html_output .= table_text ($vars{$_},$_,$r_setup);
		}

	   $html_output .=qq~
	   <TR><TD BGCOLOR="$bg_color_0" ALIGN="RIGHT" colspan="2">
			  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
	         <font size="3"><B>Forum Color and Font Settings</B></font></font>
	      </TD>
	   </TR>
		~;
	   foreach (@color_vars) {
	      chomp;
			$html_output .= table_text ($vars{$_},$_,$r_setup);
		}

	   $html_output .=qq~
	   <TR><TD BGCOLOR="$bg_color_0" ALIGN="RIGHT" colspan="2">
			  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
	         <font size="3"><B>Forum Options</B></font></font>
	      </TD>
	   </TR>
		~;

	   foreach (@setup_vars) {
	      chomp;
			$html_output .= table_text ($vars{$_},$_,$r_setup);
		}

	   $html_output .=qq~
	   <TR>
	      <TD BGCOLOR="$bg_color_3" colspan="2" ALIGN="Center" VALIGN="CENTER">
	      <INPUT type="submit" value="Change Settings">
	      <INPUT type="reset" value="Reset">
	      </TD>
	   </TR>
	   </TABLE>
	   </FORM>
	   ~;
	
	   $html_output;
		
	}

}

sub table_text {

	my ($value,$key,$r_setup) = @_;
	my $output;

   if ($key eq "auth_default_group") {
	   $output .= qq~
         <TR>
			<TD BGCOLOR="$bg_color_3" ALIGN="LEFT" Colspan="2">
		  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<b>$desc{$key}</b></font><br>
			   <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
	         <select name="form_$_">~;
        		foreach $group (@group) {
          		if ($value eq $group) {
            		$output .= "<option value=\"$group\" selected>$group\n";
          		}
          		else {
           	 		$output .= "<option value=\"$group\">$group\n";
          		}
        		}
        		$output .= qq~
        		</select></font></td></tr>~;
   }
   elsif ($key eq "date_format") {
		my @options = qw(
			mmm-dd-yy
			dd-mmm-yy
			mm-dd-yy
			dd-mm-yy );

	   $output .= qq~
         <TR>
			<TD BGCOLOR="$bg_color_3" ALIGN="LEFT" Colspan="2">
		  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<b>$desc{$key}</b></font><br>
			   <font size="$font_size_3" color="$font_color_3" face="$font_face_3">
	         <select name="form_$_">~;
        		foreach $option (@options) {
          		if ($value eq $option) {
            		$output .= "<option value=\"$option\" selected>$option\n";
          		}
          		else {
           	 		$output .= "<option value=\"$option\">$option\n";
          		}
        		}
        		$output .= qq~
        		</select></font></td></tr>~;
   }
   elsif ($value eq "on") {
         $output .=qq~
         <TR>
			<TD BGCOLOR="$bg_color_3" ALIGN="left" colspan="2">
		  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<b>$desc{$key}</b><br>
			<INPUT TYPE="radio" name="form_$key" value="on" checked> on
			<INPUT TYPE="radio" name="form_$key" value="off"> off
         </font></TD>
         </TR>
         ~;
   }
   elsif ($value eq "off") {
         $output .=qq~
            <TR>
			<TD BGCOLOR="$bg_color_3" ALIGN="left" colspan="2">
		  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<b>$desc{$key}</b><br>
		<INPUT TYPE="radio" name="form_$key" value="on"> on
		<INPUT TYPE="radio" name="form_$key" value="off" checked> off
            </font></TD>
   	    </TR>
         ~;
   }
   else {
         $output .=qq~
	   <TR>
		<TD BGCOLOR="$bg_color_3" ALIGN="LEFT" COLSPAN="2">
		  	<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<b>$desc{$key}</b></font><br>
           <input type="text" name="form_$key" value="$value" size="40">
           </TD>
           </TR>
         ~;
   }

	return $output;
	
}

1;