# admin_faq_manager.pl
#
# NOT USED FOR DCF2000
#
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# admin_faq_manager
# utility for managing FAQ
#===================================================================

sub admin_faq_manager {

	my ($r_in,$r_setup) = @_;
	my $html_output;
	my $r_data = {};

	print_header();
	print_header_end();

	$html_output = qq~
	   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
	   <TR>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="CENTER" COLSPAN="3">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<B><font size="3">FAQ Manager</font></b><br>
			</font></TD></TR></table>~;

	$r_data = readdata("$password_file_dir/$faq_list");

	if ($r_in->{'command'} eq 'post' or
	    $r_in->{'command'} eq 'edit') {

		$r_in->{'answer'} = dc_encode($r_in->{'answer'});
		$r_in->{'question'} = dc_encode($r_in->{'question'});

		my $text = join("$join_delim",$r_in->{'date'},$r_in->{'localtime'},
				$r_in->{'question'},$r_in->{'answer'});

		appenddata("$password_file_dir/$faq_list",$text);

		if ($r_in->{'command'} eq 'edit') {		
			remove_faq($r_in);
			$html_output .= print_status("Your faq has been updated");
		}
		else {
			$html_output .= print_status("Your faq has been posted");
		}

	}
	elsif ($r_in->{'command'} eq 'Delete') {
		remove_faq($r_in);
		$html_output = print_status("FAQ list have been updated");
	}
	# If $r_in->{'command'} is still not empty, then it is edit
	elsif ($r_in->{'command'}) {

		$r_in->{'command'} = 'edit';
		my ($ldate,$ltime,$question,$answer) = 
				get_faq($r_in->{'selected'},$r_data);
		$r_in->{'ldata'} = $ldate;
		$r_in->{'ltime'} = $ltime;
		$r_in->{'question'} = dc_decode($question);
		$r_in->{'answer'} = dc_decode($answer);
		$html_output = faq_form($r_in);

	}			
	else {

		$r_in->{'command'} = 'post';
		$html_output .= qq~
		<FORM ACTION="$boardurl" METHOD=POST>
		<input type="hidden" name="az" value="$r_in->{'az'}">
	   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
		   <TR>
		      <TH BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP">
				<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Select
				</font>
		      </TH>
		      <TD BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="TOP">
				<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				question/answer
				</font>
		      </TD>
		   </TR>
			~;

		if (@{$r_data}) {
			foreach (@{$r_data}) {
				chomp;
				my ($ldate,$ltime,$question,$answer) = split /$split_delim/;
				my $select_id = $ldate . "::" . $ltime;
				$question = dc_decode($question);
				$answer = text_to_html($answer);
				$html_output .= qq~
				   <TR>
			      <TD BGCOLOR="$bg_color_2" ALIGN="LEFT" VALIGN="TOP">
					<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
					<input type="checkbox" name="selected" value="$select_id">
					</font></TD>
			      <TD BGCOLOR="$bg_color_1" ALIGN="LEFT" VALIGN="TOP" width="100%">
					<font size="$font_size_1" face="$font_face_1" color="$font_color_1">
					<b>question: $question</b><br>
					$ltime $ldate
					<hr>
					$answer
					</font>
			      </TD>
			   </TR>~;
			}
			$html_output .= qq~
			   <TR>
		      <TD BGCOLOR="$bg_color_2" ALIGN="LEFT" VALIGN="TOP" colspan="3">
				<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<input type="submit" name="command" value="Delete">
				<input type="submit" name="command" value="Edit (Select only one)">
				<input type="reset" value="Reset">
				</font></TD>
			   </TR>~;
		}
		else {		
				$html_output .= qq~
				   <TR>
			      <TH BGCOLOR="$bg_color_3" ALIGN="CENTER" VALIGN="TOP" COLSPAN="3">
					<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
					No faqs in the database.
					</font></TH>
			   </TR>~;
		}

		$html_output .= "</table></Form>";
		
		$html_output .= faq_form($r_in);

	}

	$html_output;	

}

#======================================================================#
# function remove_faq
# Remove faqs from the list
#======================================================================#

sub remove_faq {

   my $r_in = shift;
	my @remove_list = split(/\0/,$r_in->{'selected'});
	my $r_data = readdata("$password_file_dir/$faq_list");

   for ($j=0;$j<@{$r_data};$j++) {
		my $line = $r_data->[$j];
	   chomp $line;
		my ($ldate,$ltime,$question,$answer) = split(/$split_delim/,$line);
		my $selected_id = $ldate . "::" . $ltime;
		foreach (@remove_list) {
			if ($selected_id eq $_) {
				splice(@{$r_data},$j,1);
				$j--;
			}
		}
	}
	writedata("$password_file_dir/$faq_list",$r_data);
}

#======================================================================#
# function get_faq
# Get selected faq from the list
#======================================================================#

sub get_faq {

   my ($selected_id,$r_data) = @_;
   foreach (@{$r_data}) {
	   chomp;
		my ($ldate,$ltime,$question,$answer) = split /$split_delim/;
		my $selected = $ldate . "::" . $ltime;
		if ($selected_id eq $selected) {
			return ($ldate,$ltime,$question,$answer);
		}
	}
	
}

#======================================================================#
# function get_faq
# Get selected faq from the list
#======================================================================#

sub faq_form {

	my $r_in = shift;
	my $output = qq~
		<FORM ACTION="$boardurl" METHOD=POST>
		<input type="hidden" name="az" value="$r_in->{'az'}">
		<input type="hidden" name="command" value="$r_in->{'command'}">
		~;
	if ($r_in->{'selected'}) {
		$output .= qq~
		<input type="hidden" name="selected" value="$r_in->{'selected'}">~;
	}
	
	$output .= qq~
	   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
		   <TR>
		      <TH BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="TOP" Colspan="3">
				<font size="$font_size_0" face="$font_face_0" 
					color="$font_color_0">
				Post an FAQ.
				</font>
		      </TH>
		   </TR>
		   <TR>
		      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
				<font size="$font_size_3" face="$font_face_3" 
					color="$font_color_3">
				Question:
				</font></TH>
		      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP"  COLSPAN="2">
				<input type="text" name="question" size="50" value="$r_in->{'question'}">
		      </TD></TR>
		   <TR>
		      <TH BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
				<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				Answer:</font></TH>
		      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP"   COLSPAN="2">
				<textarea name="answer" rows="10" cols="50" wrap="virtual">$r_in->{'answer'}</textarea>
		   </TR>
		   <TR>
		      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
				&nbsp;
				</td>
		      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP" COLSPAN="2">
				<input type="submit" value="Submit">
				<input type="reset" value="Reset">
				</td>
		   </TR>
			
			</TABLE>
			</FORM>
			~;

	return $output;
}


1;