# admin_create_new_account.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# admin_create_new_account
# admin utility for creating a new user account
#===================================================================

sub admin_create_new_account {

	my ($r_in,$r_setup) = @_;
	my $r_local = {};
	my $az_type;
   my $html_output;

	require "$cgilib/auth_lib.pl";
	require "$cgilib/auth_lib_2.pl";
   $r_local = auth_init($r_in,\@login_fields,\%field_form_type);

  	if ($r_in->{'command'}) {

		# End of HTTP Header
    	print_header_end();

		# Check and make sure all required fields are
		# submitted
    	my @required = split(/\,/,$r_in->{'required'}); 
    	foreach (@required) {
      	unless ($r_in->{$_}) {
        		push(@ERROR,$_);
      	}
    	}

		# Incomplete form    
    	if (@ERROR) {
      	$html_output = print_status("
			<font size=3>Incomplete Registration Form!</font><p>
				Some of the required 
				fields have not been provided.<br>
      		Please try again.");			
      	$html_output .= output_form($r_in,$r_local);
    	}
    	else {

			$username = $r_in->{'Username'};
			$password = $r_in->{'Password'};
	      $error = register($r_in,$r_local);

		   if ($error) {
   	      $sub_heading = "$error";
      	   $html_output = output_form($r_in,$r_local,$r_setup);
         }
         else {
				$html_output = print_status("New user account created!");
         } 
		}
   }
   else {

      $r_local->{'form_type'}->{'Status'} = join("$join_delim",
         "hidden","$r_setup->{'auth_activate_user_on_registration'}");

      $r_local->{'form_type'}->{'Group'} = join("$join_delim",
         "select",@group);

		$html_output = print_status("Complete the following form 
			to create a new user account.");
      $html_output .= output_form($r_in,$r_local,$r_setup);

   }

	return $html_output;

}


1;
