# admin_conf_manager.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# admin_conf_manager
# utility for managing conferences
#===================================================================

sub admin_conf_manager {

	my($r_in,$r_setup) = @_;
	
	if ($r_in->{"command"} eq "reorder_conf_form") {
		$form_title = "Reorder Conference";
		$form_desc = "Reassign numerical order to the conferences below.";
	   $r_in->{'command'} = "reorder_conf";
	   $html_output = &reorder_conf_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "m_conf_form") {
	   $r_in->{'command'} = "m_conf";
		$form_title = "Modify Conference";
		$form_desc = "Modify the following form to update conference information.";
	   $html_output = conf_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "reorder_conf") {
	   $html_output = &reorder_conf($r_in);
	}
	elsif ($r_in->{"command"} eq "c_conf_form") {
	   $r_in->{'command'} = "c_conf";
		$form_title = "Create Conference";
		$form_desc = "Complete the form below to create a new conference";
	   $html_output = conf_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "c_conf") {
		$r_in->{'conf_desc'} =~ s/\n\n/<p>/g;
		$r_in->{'conf_desc'} =~ s/\r\n/<br>/g;
		$r_in->{'conf_desc'} =~ s/\n/<br>/g;
		
		my $conf_id = get_id("$password_file_dir/$conf_id");
	   $conf_id = $conf_root . $conf_id;
	
		my $temp = join("$join_delim",$conf_id,$r_in->{'conf_name'},$r_in->{'conf_desc'},$r_in->{'conf_status'});
		check_datafile("$password_file_dir/$conf_file");
	   appenddata("$password_file_dir/$conf_file",$temp);
	   $html_output = print_status("Sucessfully created $r_in->{'conf_name'} conference");
	}
	elsif ($r_in->{"command"} eq "r_conf_select") {
	   $r_in->{'command'} = "r_conf";
		$form_title = "Remove Conference";
		$form_desc = "Select the conference you wish to remove.";
	   $html_output = r_conf_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "r_conf") {
	   $html_output = m_conf($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "m_conf_select") {
	   $r_in->{'command'} = "m_conf_form";
		$form_title = "Modify Conference";
		$form_desc = "Select the conference you wish to modify.";
	   $html_output = r_conf_form($r_in,$r_setup);
	}
	elsif ($r_in->{"command"} eq "m_conf") {
		$r_in->{'conf_desc'} =~ s/\n\n/<p>/g;
		$r_in->{'conf_desc'} =~ s/\r\n/<br>/g;
		$r_in->{'conf_desc'} =~ s/\n/<br>/g;
	   $html_output = m_conf($r_in,$r_setup);
	}



}

###
# subroutine m_conf
# Modify conference
###

sub m_conf {
   my ($r_in,$r_setup) = @_;
   my $output;
	my @new_conf;
	my $new_string = join("$join_delim",$r_in->{'conf_id'},$r_in->{'conf_name'},
		$r_in->{'conf_desc'},$r_in->{'conf_status'});
	my $r_conf = readdata("$password_file_dir/$conf_file");

	foreach (@$r_conf) {
		chomp;
		if ($_ =~ /^$r_in->{'conf_id'}$split_delim/) {
			if ($r_in->{'command'} eq 'm_conf') {
				push(@new_conf,"$new_string\n");
			}
		}
		else {
			push(@new_conf,"$_\n");
		}
	}
	writedata("$password_file_dir/$conf_file",\@new_conf);
   $output = print_status("Conference information has been updated!");
   $output;
}

###
### subroutine conf_form
### displays the form for creating a new forum
###

sub conf_form {

   my ($r_in,$r_setup) = @_;
   my $html_output = "";
	my ($conf_id,$conf_name,$conf_desc,$conf_status);
	if ($r_in->{'command'} eq 'm_conf') {
		my $r_conf = readdata("$password_file_dir/$conf_file");

		foreach (@$r_conf) {
			chomp;
			if ($_ =~ /^$r_in->{'conf_id'}$split_delim/) {
				($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;
				last;
			}
		}

	}

	$html_output .=qq~
    <FORM METHOD=POST>
    <input type="hidden" name="az" value="$r_in->{'az'}">
    <input type="hidden" name="command" value="$r_in->{'command'}">
    <TABLE BORDER="0" CELLPADDING="4" WIDTH="100%" ALIGN="CENTER">
	 ~;

	if ($conf_id) {
		$html_output .=qq~
			<input type="hidden" name="conf_id" value="$conf_id">
		~;
	}

	$html_output .=qq~
      <TR><TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP" Colspan="2">
		   <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	      <font size="3"><b>$form_title</b></font><br>
			$form_desc
       	</FONT></TD></TR>
      <TR><TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		   <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	      <b>Conference Name:</b>
       	</FONT></TD>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<input type="text" size="40" name="conf_name" value="$conf_name">
      	</TD></TR>
      <TR><TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		   <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	      <b>Conference Description:</b>
       	</FONT></TD>
     		<TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<textarea rows="4" cols="40" name="conf_desc" wrap="virutal">$conf_desc</textarea>
      	</TD></TR>
      <TR><TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		   <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
	      <b>Conference Status:</b>
       	</FONT></TD>
     		<TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">~;

	if ($conf_status eq "on") {
		$html_output .= qq~
			<input type="radio" name="conf_status" value="on" checked>on
			<input type="radio" name="conf_status" value="off">off
			~;
	}
	else {
		$html_output .= qq~
			<input type="radio" name="conf_status" value="on">on
			<input type="radio" name="conf_status" value="off" checked>off
			~;
	}

	$html_output .= qq~
      	</TD></TR>
      <TR><TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP" colspan="2">
		   <font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		   <INPUT type="submit" value="Submit This Form">
   		<INPUT type="reset" value="Reset"></TD></TR></TABLE></FORM>
   ~;

	$html_output;
}

###
### subroutine r_conf_form
### displays the form modifying and for removing conf
###


sub r_conf_form {

	my ($r_in,$r_setup) = @_;

	my $html_output .=qq~
	<FORM METHOD=POST>
	<input type="hidden" name="az" value="$r_in->{'az'}">
    <input type="hidden" name="command" value="$r_in->{'command'}">
   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
   <TR>
      <Td colspan="5" BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
			<font size="3"><b>$form_title</b></font>
			<br>$form_desc
		</font>
      </Th></tr>
   <TR>
      <Th BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Select
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Conference ID
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Conference Name
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Conference Description
		</font>
      </Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="CENTER" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Conference Status
		</font>
      </Th>
   </TR>
	~;

	my $r_conf = readdata("$password_file_dir/$conf_file");

	foreach (@$r_conf) {
		chomp;
		my ($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;

		$html_output .=qq~
	   <TR>
	      <TD BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
				<input type="radio" name="conf_id" value="$conf_id">
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$conf_id
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$conf_name
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$conf_desc
			</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
			<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$conf_status
			</font>
	      </TD>
	   </TR>
		~;

	}	
	$html_output .=qq~
   <TR>
      <TD BGCOLOR="$bg_color_3"  colspan="6" ALIGN="LEFT" VALIGN="CENTER">
	   <INPUT type="submit" value="Submit">
   		<INPUT type="reset" value="Reset">
      </TD>
   </TR>
   </TABLE>
   </FORM>
   ~;

   $html_output;
}

###
### subroutine reorder_conf_form
### displays the form for reordering conference
###

sub reorder_conf_form {

	my ($r_in,$r_setup) = @_;
	my $html_output = "";

	$html_output .=qq~
	<FORM METHOD=POST>
	<input type="hidden" name="az" value="$r_in->{'az'}">
    <input type="hidden" name="command" value="$r_in->{'command'}">
   <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%" ALIGN="CENTER">
   <TR>
      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="CENTER" COLSPAN="3">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
		<B><font size="3">$form_title</font></b><br>
		$form_desc
		</font></TD></TR>
   <TR>
      <Th BGCOLOR="$bg_color_0" ALIGN="RIGHT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Order Number</font></Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Conference Name</font></Th>
      <Th BGCOLOR="$bg_color_0" ALIGN="LEFT" VALIGN="CENTER">
		<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
			Conference Description</font></Th></TR>~;

	my $j = 0;

	my $r_conf = readdata("$password_file_dir/$conf_file");

	foreach (@$r_conf) {
		chomp;
		my ($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;

		$j++;

		$html_output .=qq~
	   <TR>
	      <TD BGCOLOR="$bg_color_3" ALIGN="RIGHT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				<input type="text" name="order_$conf_id" value="$j" size="5"></font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$conf_name</font>
	      </TD>
	      <TD BGCOLOR="$bg_color_3" ALIGN="LEFT" VALIGN="TOP">
		<font size="$font_size_3" face="$font_face_3" color="$font_color_3">
				$conf_desc</font>
	      </TD>
	   </TR>
		~;

	}

	$html_output .=qq~
   <TR>
      <TD BGCOLOR="$bg_color_0"  colspan="3" ALIGN="Center" VALIGN="CENTER">
	   <INPUT type="submit" value="Submit">
   		<INPUT type="reset" value="Reset">
      </TD>
   </TR>
   </TABLE>
   </FORM>
   ~;

   $html_output;
}


###
### subroutine reorder_conf
### reorder conference listing
###

sub reorder_conf {

	my ($r_in) = shift;
	my $output;

	my $r_data = readdata("$password_file_dir/$conf_file");	

	foreach (@$r_data) {
		chomp;
		my ($conf_id,$conf_name,$conf_desc,$conf_status) = split /$split_delim/;
		$order{ $r_in->{"order_$conf_id"} } = $_;

	}

	my @newrow;

	foreach (sort {$a <=> $b} keys %order) {
		push(@newrow,"$order{$_}\n");
	}
	
	writedata("$password_file_dir/$conf_file",\@newrow);

   $output = print_status("Conferences have been reordered successfully!");

   $output;
}



1;