# admin_archive_threads.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#===================================================================
# admin_archive_threads
# utility for archiving threads
#===================================================================

sub admin_archive_threads {

	my($datafile,$r_in,$r_setup) = @_;
	my $r_rowdata = readdata($datafile);
	my $html_output = "";
	my $ext = $r_in->{'ext'};
	my $forum = $r_in->{'forum'};
	my $forum_dir = $password_file_dir;
	my $forum_file = $forum_file;
	my $filename;
	my @newrow,$arc_row;
	my @file_selected = split(/\0/,$r_in->{'selected'});

	my $num_threads = @file_selected;
	my $num_posts = 0;
	# temporarily save data links in arc_row, just in case
	# the action to perform is archive
	
	foreach (@$r_rowdata) {
		$hit = '';
		chomp;
	   my ($num,$date,$ltime,$name,$subject,$caption,
			$lock,$read,$user_rating,$replies) = split /$split_delim/;
		foreach (@file_selected) {
			if ($num == $_) {
				$hit = 'yes';
				last;
			}
		}
		unless ($hit) {
			push(@newrow,"$_\n");
		}
		else {
			$num_posts += 1;
			$num_posts += $replies;
			$arc_row .= "$_\n";
		}
		
	}

   my @stuff = split(/\//,$datafile);
   my $file = pop(@stuff);
   my $datadir = join("\/",@stuff);

	chomp($arc_row);
	appenddata("$datadir/arc_$file",$arc_row);

	foreach (@file_selected) {
		chomp;
		$r_in->{'om'} = $_;
		$r_in->{'archive'} = "yes";
	   create_message($r_in,$r_setup);
		push(@FILE_REMOVED,$_);
	}

   writedata("$maindir/$forum/$database",\@newrow);

	$r_setup->{'forum_threads'}->{$forum} = 
		$r_setup->{'forum_threads'}->{$forum} - $num_threads;
	$r_setup->{'forum_archive'}->{$forum} = 
		$r_setup->{'forum_archive'}->{$forum} + $num_threads;
	$r_setup->{'forum_posts'}->{$forum} = 
		$r_setup->{'forum_posts'}->{$forum} - $num_posts;

   save_forum_info("$forum_dir/$forum_file",$r_setup);

	my $file_selected = join("\, ",@file_selected);
   my $file_removed = join("\, ",@FILE_REMOVED);
   my $not_removed = join("\, ",@NOT_REMOVED);
   my $no_file = join("\, ",@NO_FILE);

	$html_output .= qq~
	<table border="0" cellpadding="3" width="100%">
		<tr><Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Selected Files</font>
			</th>
		  <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Archived Files</font>
			</th>
		  <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				Not Archived</font>
			</th>
		  <Th ALIGN="CENTER" BGCOLOR="$bg_color_0">
		  	<font size="$font_size_0" face="$font_face_0" color="$font_color_0">
				File Not Found</font>
			</th>
		</tr>
		<tr>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$file_selected</font>
			</td>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$file_removed</font>
			</td>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$not_removed</font>
			</td>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_2">
		  	<font size="$font_size_2" face="$font_face_2" color="$font_color_2">
				<FONT SIZE=2>$no_file</font>
			</td>
		</tr>
		<tr>
		  <TD ALIGN="CENTER" BGCOLOR="$bg_color_0" colspan="4">
			&nbsp;
			</td>
		</tr>
	</table>
  <hr size="1">
  </CENTER>
   ~;

	if ($ENV{'HTTP_REFERER'} =~ /$boardurl/i or
       $ENV{'HTTP_REFERER'} =~ /$mainurl/i) {
		print "Location: $boardurl?az=list&forum=$forum\n\n";
	}
	else {
	   print_header();
	}

	$html_output;
}

1;