# add_message.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# add_messages                                                         #
# adds new thread                                                      #
#======================================================================#

sub add_message {

   my ($datafile,$r_in,$r_setup) = @_;

   my $num_threads;
   my $temp_time = substr($r_in->{'localtime'},0,5);
   my $last_date = "$temp_time $r_in->{'date'}";

	# Create Caption
   my $caption = $r_in->{'body'};
   $caption =~ s/<([^>]|\n)*>/ /g;
   $caption =~ s/$split_delim/&pip;/g;
   $caption = substr($caption,0,$r_setup->{'caption_length'});

	# Prepare message line
	# Last three zeros are: views, rating, and replies
   my $data_in = join("$join_delim",$r_in->{'om'},
        $r_in->{'date'},$r_in->{'localtime'},
        $r_in->{'name'},$r_in->{'subject'},$caption,'',0,'',0);

   my $r_rowdata = readdata($datafile);
  
	# If the number of threads exceed preset max, then prune threads...
	# But make sure $r_in->{'max_threads_allowed'} is defined and not equal to 0

   if ($max_threads_allowed > 0) {

      $num_threads = @{$r_rowdata};
      if ($num_threads >= $max_threads_allowed) {

	      @prune_list = @$r_rowdata[$max_threads_allowed-1..$num_threads-1];
   	   @$r_rowdata = @$r_rowdata[0..$max_threads_allowed-2];

			# auto_archive is off so delete the message
			if ($r_setup->{'auto_archive'} eq 'off') {
      	   foreach (@prune_list) {
         	   my ($p_num,@dummy) = split(/$split_delim/, $_);
            	if (-e "$maindir/$forum/$p_num\.$ext") {
			  	   	unlink("$maindir/$forum/$p_num\.$ext");
					}
         	}
			}

			# auto_archive is on so archive the message
			else {

				my $arc_threads = @prune_list;
				# Update total number of messages
   			$r_setup->{'forum_archive'}->{$forum} += $arc_threads;
      	   foreach $thread (@prune_list) {
					chomp($thread);
         	   my ($p_num,@dummy) = split(/$split_delim/, $thread);
	   			$r_setup->{'forum_posts'}->{$forum} = 
						$r_setup->{'forum_posts'}->{$forum} - $dummy[7] - 1;
            	if (-e "$maindir/$forum/Data/$p_num\.txt") {
						# ok, temporarily save the new message number
						appenddata("$maindir/$forum/arc_$database",$thread);
						my $old_om = $r_in->{'om'};
						$r_in->{'om'} = $p_num;
						$r_in->{'archive'} = "yes";
					   create_message($r_in,$r_setup);
						# ok, restore new message number
						$r_in->{'om'} = $old_om;
						$r_in->{'archive'} = '';
					}
         	}
			}
      }
   }

   # Write back to the database

   unshift(@$r_rowdata,"$data_in\n");
   writedata($datafile,$r_rowdata);
  
   # Now, let's update forum thread total and
   # lasttime it was updated

   $r_setup->{'forum_last'}->{$forum} = $last_date;

	# Update total number of messages
   $r_setup->{'forum_posts'}->{$forum}++;

   if ($max_threads_allowed > $num_threads) {
      $r_setup->{'forum_threads'}->{$forum} = $num_threads + 1;
   }
   else {
      $r_setup->{'forum_threads'}->{$forum} = $max_threads_allowed;
   }
   save_forum_info("$password_file_dir/$forum_file",$r_setup);

}

1;
