# a_mesg.pl
# DCForum2000 Version 1.0
# Part of DCForum by DCScripts
# Copyright  1997-2000 DCScripts All Rights Reserved
# 
# As part of the installation process, you will be asked
# to accept the terms of Agreement outlined in the readme.txt
# included with this distribution. This Agreement is
# a legal contract, which specifies the terms of the license
# and warranty limitation between you and DCScripts.
# You should carefully read this terms agreement before
# installing or using this software.  Unless you have a different license
# agreement obtained from DCScripts, installation or use of this software
# indicates your acceptance of the license and warranty limitation terms
# contained in this Agreement. If you do not agree to the terms of this
# Agreement, promptly delete and destroy all copies of this software
#
#======================================================================#
# function a_mesg                                                      #
# takes input message from post form and adds to the database          #
#======================================================================#

sub a_mesg {

   my ($r_in,$r_setup) = @_;
   my $new_mesg;
   my ($heading, $sub_heading, $html_output,$menu_button);

   $heading = $forum_title;

   require "$cgilib/dcforumlib2.pl";
#  require "$cgilib/rand_lock.pl";
   require "$cgilib/add_message.pl";
   require "$cgilib/update_thread.pl";
   require "$cgilib/update_database.pl";
   require "$cgilib/email_notification.pl";
   require "$cgilib/show_thread.pl";
      
   # First get user's information
   $r_in->{'userdata'} = check_user($r_in,$r_setup);

   # If user clicked on preview then
   if ($r_in->{"preview"}){
      require "$cgilib/pview.pl";
      ($heading, $sub_heading, $html_output,$menu_button) = pview($r_in,$r_setup);
      return ($heading, $sub_heading, $html_output,$menu_button);
   }

   # Get input data
   get_form_variables($r_in,$r_setup);

   # If it's not a double posting then
   # add the message to the forum

#   if (check_rand_lock($r_in->{'rand1'})) {

      # Filter remote and other bad postings
      filter_bad_posts($r_in,$r_setup);

      # Write to log file
      # Keeps track of user actions
      write_to_log($r_in->{'name'},"post",$r_in);

      # If this forum is moderated, then
      # write to the queue database and then
      # redirect to the main page
      if ($r_setup->{'forum_queue'}->{$forum} eq 'on') {
         if ($r_in->{'om'} == 0 or $r_in->{'om'} eq "") {
            $r_in->{'om'} = get_number("$maindir/$forum/$datafile",$r_in);
            $r_in->{'omm'} = -1;
         }
         queue_message($r_in,$r_setup);
         print "Location: $boardurl?az=list&forum=$forum\n\n";
         exit(0);
      }

      # New topic
      if ($r_in->{'om'} == 0 or $r_in->{'om'} eq "") {
         $r_in->{'om'} = get_number("$maindir/$forum/$datafile",$r_in);
         create_thread($r_in,$r_setup);
         add_message("$maindir/$forum/$database",$r_in,$r_setup);
         $new_mesg = 'yes';
      }
      else {
         update_database("$maindir/$forum/$database",$r_in);
         update_thread($r_in,$r_setup);
      }

      # If subscription is ON
      if ($r_setup->{'subscription'} eq 'on') {
         unless ($r_in->{'omm'}) {
            $r_in->{'omm'} = 0;
         }
         subscription($r_in,$r_setup);
      }

      create_message($r_in,$r_setup);
      log_ip($r_in,$r_setup);

#   }

   # OK, all the messages are updated...let's send some emails
   if ($r_setup->{'email_notification'} eq 'on') {
      email_users($r_in,$r_setup);
   }

   # If the message added is a reply, redirect to that thread
   unless ($new_mesg) {
      $r_in->{'indent'} = '';
      $r_in->{'omm'} = $r_in->{'next_file_num'};
      if ($r_setup->{'forum_type'}->{ $forum } eq 'Private') {
         print_header();
         print_header_end();
         $sub_heading = "Added your message!";
         ($dum, $dum, $html_output,$menu_button) = show_thread($r_in,$r_setup);
      }
      elsif ($r_setup->{'max_messages'} < $r_in->{'omm'}) {
         print_header();
         print_header_end();
         $sub_heading = "Added your message!";
         ($dum, $dum, $html_output,$menu_button) = show_thread($r_in,$r_setup);
      }
      else {
         print "Location: $mainurl/$forum/$r_in->{'om'}.$ext#$r_in->{'omm'}\n\n";
         exit(0);
      }
   }
   else {
      print "Location: $boardurl?az=list&forum=$forum\n\n";
      exit(0);
   }

   return ($heading, $sub_heading, $html_output,$menu_button);

}

#======================================================================#
# function get_number                                                  #
# For new posts, get next topic ID number                              #
#======================================================================#

sub get_number {

   my ($datafile,$r_in) = @_;
   my $num;

   open(NUMBER,"$datafile") 
         or my_die("Can't read from $datafile",$!);               
   flock(NUMBER,2);
      $num = <NUMBER>;
   flock(NUMBER,8);
   close(NUMBER);

   # If the topic number is very high, reset to 1
   if ($num == 99999999999 or $num eq "")  {
      $num = "1";
   }
   else {
      if ($r_in->{'om'} == 0) {
         $num++;
      }
   }

   open(NUM,">$datafile")
      or my_die("Can't write to $datafile",$!); 
   flock(NUMBER,2);
      print NUM "$num";
   flock(NUMBER,8);
   close(NUM);
   
   return $num;
}

#======================================================================#
# function filter_bad_posts                                            #
# filter bad posts - remotely posted or bad IP address                 #
#======================================================================#

sub filter_bad_posts {

   my ($r_in,$r_setup) = @_;

   # If remote URL is not from $cgiurl
   # put this user's info into security.txt file
   unless ( $ENV{'HTTP_REFERER'} =~ /$cgiurl/i) {
      my $temp = join("::",$r_in->{'userdata'}->{'Username'},
         $ENV{'REMOTE_HOST'},$ENV{'REMOTE_ADDR'});
      check_datafile("$password_file_dir/$sec_file");
      appenddata("$password_file_dir/$sec_file",$temp);
      print_header();
      print_header_end();
      $heading = "POSTING ERROR - PLEASE CONTACT YOUR ADMIN";
      my %namespace = (
         FORUMLINKS => $html_forum_links,
         MENU => $menu_button,
         TITLE => $title,
         HEADER => $heading,
         SUBHEADER => $sub_heading,
         HTMLOUTPUT => $html_output
      );
      display_output($templatefile,\%namespace);
      exit(0);
   }

   # If IP blocking is on and the user's IP address
   # is listed in the $bad_ip_list, then block this
   # posting
   # put this user's info into security.txt file
   elsif ($r_setup->{'ip_blocking'} eq 'on') {
      my $r_data = readdata("$password_file_dir/$bad_ip_list");
      foreach (@$r_data) {
         chomp;
         if ($_ eq $ENV{'REMOTE_ADDR'}) {
            print_header();
            print_header_end();
            $heading = "POSTING ERROR - PLEASE CONTACT YOUR ADMIN";
            my %namespace = (
               FORUMLINKS => $html_forum_links,
               MENU => $menu_button,
               TITLE => $title,
               HEADER => $heading,
               SUBHEADER => $sub_heading,
               HTMLOUTPUT => $html_output
            );
            display_output($templatefile,\%namespace);
            exit(0);
         }
      }# End of foreach
   }

   return 0;
}

#======================================================================#
# function queue_message                                               #
# If forum is moderated, this function saves the input message         #
# in $password_file_dir/$queue file                                    #
#======================================================================#

sub queue_message {

   my ($r_in,$r_setup) = @_;
   my $record = join("$join_delim",
      $forum,
      $r_in->{'om'},
      $r_in->{'omm'},
      $r_in->{'date'},
      $r_in->{'localtime'},
      $r_in->{'name'},
      $r_in->{'email'},
      $r_in->{'subject'},
      $r_in->{'body'});

   appenddata("$password_file_dir/$queue",$record);
   
}

#======================================================================#
# function subscription                                                #
# Write message to subscription file so that administrator can         #
# send subscriptions out                                               #
#======================================================================#

sub subscription {

   my ($r_in,$r_setup) = @_;

   my $record = join("$join_delim",
      $forum,
      $r_in->{'om'},
      $r_in->{'omm'},
      $r_in->{'date'},
      $r_in->{'localtime'},
      $r_in->{'name'},
      $r_in->{'email'},
      $r_in->{'subject'},
      $r_in->{'body'});

   appenddata("$password_file_dir/$subscription",$record);

}

#======================================================================#
# function log_ip                                                      #
# Records the user's IP address when they post a new message           #
# The output files is $password_file_dir/$ipfile                       #
#======================================================================#

sub log_ip {

   my ($r_in,$r_setup) = @_;

   my $temp_time = substr($r_in->{'localtime'},0,5);
   my $last_date = "$temp_time $r_in->{'date'}";

   my $new_data = join("$join_delim",$r_in->{'forum'},$r_in->{'om'},
               $r_in->{'omm'},$r_in->{'date'},$r_in->{'localtime'},
               $r_in->{'name'},$r_in->{'subject'},$ENV{'REMOTE_ADDR'});
   appenddata("$password_file_dir/$ipfile",$new_data);

}

1;