#!/usr/bin/perl
##############################################################################
# Country Determinator              Version 1.0                              #
# Copyright 1998 UtilMind Solutions info@utilmind.com                        #
#                                   http://www.utilmind.com                  #
# Created Nov 19, 1998              Last Modified Nov 19, 1998               #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998, UtilMind Solutions.  All Rights Reserved.                  #
#                                                                            #
# Country script may be used and modified free of charge by anyone so long   #
# as this copyright notice and the comments above remain intact. By using    #
# this code you agree to indemnify UtilMind Solution from any liability that #
# might arise from it's use.                                                 #
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden. In other words, please ask first before you try and   #
# make money off of my program.                                              #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium. In all cases copyright and header must remain intact. #
##############################################################################
# Set Variables
$countries_path	= "countries.txt";

print "Content-Type: text/html\n\n";

$host = &gethostname;
$host =~ tr/a-z/A-Z/;	# UpperCase

$hostlength = length($host);
&smartdetect;

# Get domain extension
$tempstr = $host;

for ($i = $hostlength; $i >= 0; $i--) {
 $ch = chop($tempstr);
 if ($ch eq '.') {
  $host = substr($host, $i, $hostlength - $i);
  $i = 0;
 }
}

# Get needed Country name from file
open(FILE,$countries_path) || die Cant locate countries.txt file;
@LINES = <FILE>;
close(FILE);
$SIZE = @LINES;

for ($i = 0; $i <= $SIZE; $i++) {
 $countrystr = $LINES[$i];
 $tempstr = $countrystr;
 $len = length($countrystr);
 for ($j = $len; $j >= 0; $j--) {
  $ch = chop($tempstr);
  if ($ch eq '`') {
   $country_ext = substr($countrystr, 0, $j - 1);
   if ($host eq $country_ext) {
    $host = substr($countrystr, $j, $len - $j - 1);
    print "$host";
    exit;
   }
   $j = 0;
  }
 }
}

print "Unknown";

exit;

################################################
# Detecting Country by other parameters
# For example, my RemoteHost - xxx.Kiev.dial.sovam.com, but country is Ukraine
#  - .KIEV. is Ukraine
sub smartdetect {
  &seeksubstr('.KIEV.', 'Ukraine');
}


########################################################################
# Usage: seeksubstr(SubString, Country);                               #
# Returns: nothing, but print country name and exit if substring found #
########################################################################
sub seeksubstr {
 $len = length($_[0]);

 if ($hostlength > $len) {
  for ($i = $hostlength - $len; $i >= 0; $i--) {
   $tempstr = substr($host, $i, $len);
   if ($tempstr eq $_[0]) {
    print "$_[1]";
    exit;
   }
  }
 }
}

###############################
#                             #
#  GET HOST NAME FUNCTION     #
#                             #
###############################
sub gethostname {
  $ipnum = $ENV{'REMOTE_ADDR'};
  @digits = split (/\./, $ipnum);
  $address = pack ("C4", @digits);
  $host = gethostbyaddr ($address, 2);

  return $host
}