#!/usr/bin/perl
# 
#  Matrix Counter
#  Version 2.0
#  
#########################
# AUTHOR: David Powell
# http://www.matrixvault.com/cgi/
# Copyright 1999, David Powell and "The Matrix Vault"
# A Matrix Vault Production.
# Tested and run on a UNIX system with PERL 5
# This script is an original script by David Powell. You may use it free of charge, if you keep this header intact, 
# along with any other copyright notices found in the resulting HTML output or text files generated by this script. 
#  
#########################
# 
#  INSTALLATION:
# 1. Edit the variables below
# 2. Upload the script to the $UNIX dir. Chmod it and this script to 755 or 777
# 3. Upload digits 0-9.jpg to the same dir. 
# 4. Call either by SSI or stand alone:
#    SSI:  <!--#exec cgi ="/your_cgi-bin/Mcounter.cg"-->
#    Stand Alone: http://www.yoursite.com/your_cgi-bin/Mcounter.cgi
#
#     NOTE: if you want to change the graphic style of the digits, just make your
#               own graphics for 0-9 and upload them to the $UNIX dir. Use JPEGs only.
#
#########################
#   E D I T   V A R I A B L E S

# The UNIX DIR of the counter program. No trailing slash!
$UNIX = "/virtualhosts/matrixvault.com/www/cgi/scripts2/Mcounter";

#The HTTP URL of the dir this script is in. No trailing slash!
$URL="http://www.matrixvault.com/cgi/scripts2/Mcounter";

# Reset IP Time- in seconds. 24hours = 86400
$reset_time = 86400;

# Show Daily count?
$daily = "0";

# Show Unique Count
$show_uniques="1";

# Show last visitor data (time and date of last hit)
$show_last = "0";

#Page Name?
$page="CGI_demo_text";

# Graphic counter or text? 1=graphic
$graphic="0";

# Keep a log file for each day's total? 
# Filename is: $page+DAILY.log IE: $pageDAILY.log
$keep_totals = "1";

# Flat border Width, set to 0 for none.
$flat_border="0";

# 3d Table Border width, set to 0 for none
$border_3d="0";

# Cell color (the background color of the table.)
# Remember it should not be the same as the flat border color
$cell_color="\#000000";

#Flat border Color- set as the same as your cell color for none.
$border_color="\#CC6600";

#Font Color (take the cell color into consideration!)
$font_color = "\#FFCC00";

#Font Style
$font_face = "ARIAL";

# Font size in relative terms: IE: +2, +1, 0, -1, -2
# On most computers, 0=12 points, -1=10, -2=8.
# these sizes are generally universal, however some 
# computers and custom window settings will show
# them differently.
$font_size="-2";

# Cell padding with each cell of the table
$cell_padding="4";

# Cell Spacing (The space between each cell)
$cell_spacing="0";

# E N D   E D I T  V A R I A B L E S
##########################

	print "Content-type: text/html\n\n";

##########################
#  Read the command line and start 
#  processing
##########################

	$IP=$ENV{'REMOTE_ADDR'};
	$IP_LOGNAME = "$page"."IP.log";
	$date_file = "$page"."DATE.log";
	$date = localtime(time);
	$last_hit_file = "$page"."LAST.log";
	&checkdate;
	&readcounter;
	&checkIP;
	&record_IP;

##########################
# Update the counter file with the new
# count and update the last hit log.
##########################

	$count++;
	open (DAT,">$UNIX/$page.dat") || &error ("Cannot Open Counter: $page");
	print DAT "$count";
	close (DAT);
	open (DATE_LOG, ">$UNIX/$last_hit_file");
	print DATE_LOG "$date";
	close (DATE_LOG);
	&finish;


##########################
# Output
##########################

sub finish
{
	&daily_total;
	print qq!<table border=0 cellpadding=$flat_border cellspacing=0 bgcolor=$border_color><tr><td>!;
	print qq!<center><table bgcolor =$cell_color BORDER="$border_3d" CELLSPACING=$cell_spacing CELLPADDING=$cell_padding ><tr>!;

##  UNIQUE VISITORS DISPLAY
	if ($show_uniques eq "1")
		{
		print qq!
		<td VALIGN=TOP>
		<font color=$font_color face="$font_face"><font size=$font_size>Unique Visitors: 
		<font color=$font_color face="$font_face"><font size=$font_size>!;

	if ($graphic eq "1") 
		{
		chomp($count);
		@numerals = split(//,$count);
		foreach $number (@numerals) 
			{
			print "<img src=\"$URL/$number.jpg\" align=abscenter>";
			}
		} else {print "<font  color=$font_color face=\"$font_face\"><font size=$font_size>$count";}
	print "</td></tr><tr>";
			}


# VISITORS TODAY DISPLAY

	if ($daily eq "1")
		{
		print qq!<td valign=TOP>
		<font color=$font_color face="$font_face"><font size=$font_size>Today's Visitors: !;

	if ($graphic eq "1") 
		{
		chomp($count);
		@numerals = split(//,$daily_count);
		foreach $number (@numerals) 
			{
			print "<img src=\"$URL/$number.jpg\" align=abscenter>";
			}
		} else {print "<font color=$font_color size=$font_size>$daily_count";}

		print "</td></tr><tr>\n";

		} 
		

##    LAST VISITOR DATA

	if ($show_last eq "1") {
		print qq!
		<td>
		<font color=$font_color  face="$font_face"><font size=$font_size>Last Hit:
		<font color=$font_color face="$font_face"><font size=$font_size>$last_hit</td>!;
		}
	if (($daily eq "1") && ($show_uniques eq "1")) {$colspan="2";}
		print qq!</tr><tr><td><CENTER><font  color=$font_color face="$font_face" size=$font_size><B>Counter by: "<a href="http://www.matrixvault.com/cgi">Matrix's CGI Vault</a>"
		</B></center></td></tr></table></center></tr></table></center>!;
}

##########################
#  Check the reset date and reset if
#  Neccessary
##########################

sub checkdate
{
	$current_time = time;
	unless (-e "$UNIX/$date_file") 
	{
		open (date,">$UNIX/$date_file");
		print date "$current_time";
		close (date);
	}

	open (date,"$UNIX/$date_file");
	$time = <date>;
	close (date);
	$res = $current_time - $time;
	if ($res >= $reset_time) 
		{
		if ($keep_totals eq "1")
			{
			&daily_total;
			$hit_file="$page"."DAILY.log";
			open (LOG,">>$hit_file");
			print LOG "$date|$daily_count\n";
			close (LOG);
			$daily_count ="";
			}
   		unlink ("$UNIX/$IP_LOGNAME");
		open (date,">$UNIX/$date_file");
		print date "$current_time";
		close (date);
   		} 
}

##########################
#  Record the user's IP address
##########################

sub record_IP
{
	open (IP_LOG,">>$UNIX/$IP_LOGNAME");
	print IP_LOG "$IP\n";
	close (IP_LOG);
}

##########################
#  CHECK the IP
##########################

sub checkIP
{
	unless (-e "$UNIX/$IP_LOGNAME")
	{
		open (LOG,">$UNIX/$IP_LOGNAME");
		close (LOG);
	}
		open (IP_LOG,"$UNIX/$IP_LOGNAME") || &error ("Cannot Open IP log!");
    		while (<IP_LOG>)
			{
			$log_address = $_;
			chop $log_address;
   			if ($log_address eq $IP) 
				{
				close(IP_LOG);
				&finish;
				exit;
				}
			}
		close(IP_LOG);
	}
##########################
# Open the counter file
##########################
sub readcounter
{
	open (DAT,"$UNIX/$page.dat");
	$count=<DAT>;
	close (DAT);
	open (DATE_LOG,"$UNIX/$last_hit_file");
	$last_hit = <DATE_LOG>;
	close (DATE_LOG);
}



################
#  ERROR HANDLING
################

sub error
{
	print "<BOLD><FONT size=-2>Matrix Counter Error:<FONT COLOR=\"#FF0000\"> <B>$_[0]</B></FONT></FONT><BR>";
	exit;
}

################
#  Count the Daily total
################
sub daily_total
{
	open (IP_LOG,"$UNIX/$IP_LOGNAME") || &error ("Cannot Open IP log!");
	while (<IP_LOG>) {$daily_count++;}
	if ($daily_count eq""){$daily_count="1";}
	close (IP_LOG);
}