#!/usr/bin/perl -Tw
##########################################################################
# Click Manager 2.2.2                                                    #
# Copyright (c) 2001-2002 Aardvark Industries                            #
#                         http://www.aardvarkind.com/                    #
#                                                                        #
# You can redistribute and/or modify this script under the terms of the  #
# Aardvark Industries License, either version 1.0 or (at your option)    #
# any later version published by Aardvark Industries.                    #
#                                                                        #
# This program is distributed in the hope that it will be useful, but    #
# WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Aardvark #
# Industries License for more details.                                   #
##########################################################################
use Fcntl qw(:DEFAULT :flock);
my $dir = '.';
sysopen(CLICKMANAGER, "$dir/clickmanager.txt", O_RDONLY) || die "$dir/clickmanager.txt\n\n$!, stopped";
flock(CLICKMANAGER, 2);
my @db = <CLICKMANAGER>;
close(CLICKMANAGER);
my $num = 0;
foreach (@db) {
  chomp;
  my($id, $url, $hits) = split(/\|/);
  $num+=$hits;
}
sysopen(TOTAL, "$dir/total.txt", O_RDWR) || die "$dir/total.txt\n\n$!, stopped";
flock(TOTAL, 2);
my($hits_today, $hits_1, $hits_2, $hits_3, $hits_highest, $hits_total) = split(/\|/, <TOTAL>);
truncate(TOTAL, 0);
seek(TOTAL, 0, 0);
my $hits_days = int($num / (($hits_today + $hits_1 + $hits_2 + $hits_3) / 4));
print TOTAL join('|', $hits_today, $hits_1, $hits_2, $hits_3, "0", $num, $hits_days);
close(TOTAL);
print "Content-type: text/html\n\nGo to <a href=\"total.txt\">total.txt</a>.  There should now be seven numbers separated by \"|\".  The third to last number should be 0.<br /><br />\nIf everything worked right, delete this file.";